<?php
// Copyright 1999-2025. WebPros International GmbH. All rights reserved.
$messages = [
    'action-log.logFiles' => "Журнали",
    'action-log.fromDate' => "Від:",
    'action-log.toDate' => "До:",
    'action-log.clearLog' => "Очистити журнал",
    'action-log.downloadLog' => "Завантажити",
    'action-log.loggedActions' => "Записані операції",
    'action-log.storeLogsInDb' => "Зберігати записи в базі даних",
    'action-log.storeNumber' => "Записи",
    'action-log.dontRemoveRecs' => "Не видаляйте записи",
    'action-log.confirmCleanLog' => "Ви впевнені, що бажаєте видалити виділені записи з журналу реєстрації операцій?",
    'action-log.incorrectDate' => "Вказано невірну дату",
    'action-log.incorrectNumPeriods' => "Вказано невірний період ротації.",
    'action-log.incorrectNumRecords' => "Вказано невірну кількість записів.",
    'action-log.yes' => "Так",
    'action-log.no' => "Ні",
    'action-log.mixed' => "(змішаний)",
    'action-log.period' => "Період",
    'action-log.invalidDatePeriod' => "Неприпустимий період дат",
    'action-log.submitDone' => "Зміни параметрів реєстрації операцій збережено.",
    'action-log.clearDone' => "Журнал дій очищено.",
    'action-log.periodDay' => "дні",
    'action-log.periodWeek' => "тижні",
    'action-log.periodMonth' => "місяці",

    'admin-info.adminInfoSection' => 'Інформація для адміністратора',
    'admin-info.description-admin' => 'Опис адміністратора',
    'admin-info.description-reseller' => 'Опис посередника',
    'admin-info.description-owner' => 'Опис власника',
    'admin-info.description' => 'Опис',
    'admin-info.descriptionSuccess' => 'Опис було оновлено.',
    'admin-info.longDescription' => 'Зазначений опис занадто довгий. Він не може перевищувати %%max%% символів.',
    'admin-info.add' => 'Додати опис',
    'admin-info.edit' => 'Редагувати',
    'admin-info.remove' => 'Видалити',
    'admin-info.confirmOnRemove' => 'Ви дійсно бажаєте видалити опис?',
    'admin-info.popupTitle-customer' => '%%descriptionType%% клієнта %%name%%',
    'admin-info.popupTitle-reseller' => '%%descriptionType%% посередника %%name%%',
    'admin-info.popupTitle-subscription' => '%%descriptionType%% підписки %%name%%',
    'admin-info.popupTitle-site' => '%%descriptionType%% для %%name%%',
    'admin-info.popupHint-admin' => 'Цей опис є видимим тільки для адміністратора.',
    'admin-info.popupHint-reseller' => 'Цей опис є видимим для посередника та адміністратора.',
    'admin-info.popupHint-owner' => 'Цей опис є видимим для автора та його постачальника хостингу.',
    'admin-info.customerDescriptionHint' => 'Замовники не можуть бачити цей опис.',
    'admin-info.subscriptionDescriptionHint' => "Ця інформація є видимою тільки для постачальника хостингу (адміністратора Plesk або посередника).",

    'apache-settings.formGeneralHint' => 'На цій сторінці ви можете налаштувати параметри веб-серверу Apache для цього веб-сайту. Налаштування конфігурації Apache буде корисним, якщо, наприклад, ви бажаєте використовувати на своєму сайті новий тип індекс-файлів або прив’язати певні типи MIME до певних розширень імені файла. Значення За замовчуванням означає, що Apache буде використовувати відповідну директиву зі своєї загальносерверної конфігурації. Якщо Apache працює разом з nginx, який виступає як сервер переднього плану, то на цій сторінці ви також можете визначити параметри nginx.',
    'apache-settings.general' => 'Загальні параметри Apache',
    'apache-settings.example' => "Наприклад:\n%%example%%",
    'apache-settings.settingOn' => 'Увімкнено',
    'apache-settings.settingOff' => 'Вимкнено (за замовчуванням)',
    'apache-settings.settingDefault' => 'За замовчуванням',
    'apache-settings.settingCustom' => 'Ввести користувацьке значення',
    'apache-settings.mimeTypes' => 'Типи MIME',
    'apache-settings.mimeTypesExample' => "text/plain .txt\nimage/jpeg .jpeg",
    'apache-settings.mimeTypesFullDescription' => 'Типи MIME пов’язують розширення файлів з їх типами. Зазвичай це використовується для створення спеціальних розширень файлів для стандартних типів файлів.',
    'apache-settings.handlers' => 'Обробники',
    'apache-settings.handlersExample' => "php-script .php\ncgi-script .cgi",
    'apache-settings.handlersFullDescription' => "Дескриптори Apache визначають, як веб-сервер оброблює файли з певними розширеннями при надходженні відповідного запиту. Наприклад, рядок 'php-script .script' означає, що Apache оброблятиме файли з розширенням .script як php-скрипти.",
    'apache-settings.deny' => 'Заборонити доступ до сайту',
    'apache-settings.allow' => 'Виключення',
    'apache-settings.denyExample' => "10.1.0.0/16\n192.168.1.110\n\nВказані вузли та мережі не мають доступу до сайту. Щоб заборонити всі підключення, введіть симовол '*'.",
    'apache-settings.allowExample' => "192.168.0.0/16\n10.1.1.21\n\nВказані вузли та мережі мають доступ до сайту.",
    'apache-settings.directoryIndex' => 'Індексні файли',
    'apache-settings.directoryIndexExample' => "index.htm index.php index.pl",
    'apache-settings.directoryIndexFullDescription' => "При отриманні запиту на сторінку індексів Apache шукатиме зазначені файли.",
    'apache-settings.expires' => 'Спливає строк дії',
    'apache-settings.expiresStaticOnly' => 'відповідь із заголовками «Спливає строк дії» лише для статичних файлів',
    'apache-settings.expiresFullDescription' => 'Веб-сервер додасть до веб-сторінок заголовки відповіді «Спливає строк дії». Часову позначку припинення строку дії можна отримати доданням вищенаведеної кількості часу до часу, в який було надіслано запит до веб-сторінки.',
    'apache-settings.expiresStaticOnlyDescription' => 'Заголовок «Спливає строк дії» буде додаватися лише до статичних файлів. Опції "Ефективна обробка статичних файлів" та «Надання статичних файлів безпосередньо nginx» відповідають за вибір файлів, які вважатимуться статичними.',
    'apache-settings.expiresUnitDays' => 'дні',
    'apache-settings.expiresUnitHours' => 'годин',
    'apache-settings.expiresUnitMinutes' => 'хвилини',
    'apache-settings.expiresUnitSeconds' => 'секунди',
    'apache-settings.expiresSize' => 'Закінчення періоду дії',
    'apache-settings.expiresUnitSize' => 'Одиниці закінчення періоду дії',
    'apache-settings.nginxCacheTimeoutSize' => 'Таймаут кеша',
    'apache-settings.nginxCacheTimeoutUnitSize' => 'Одиниці тайм-ауту кеша',
    'apache-settings.headers' => 'Додаткові заголовки',
    'apache-settings.headersExample' => "Cache-Control: public\nStrict-Transport-Security: max-age=63072000\nX-Frame-Options: DENY",
    'apache-settings.headersFullDescription' => "Веб-сервер додасть зазначені заголовки відповіді HTTP.",
    'apache-settings.restrictFollowSymLinks' => 'Обмежити здатність переходити за символьними посиланнями',
    'apache-settings.restrictFollowSymLinksDescription' => "Вибрати цю опцію, щоб заборонити користувачам використовувати директиву FollowSymLink у .htaccess і підвищити рівень безпеки серверу.",
    'apache-settings.nginx' => 'параметри nginx',
    'apache-settings.nginxProxyMode' => 'Режим proxy',
    'apache-settings.nginxProxyModeDescription' => 'Запити Nginx proxies до Apache. Вимкніть, щоб припинити використання Apache.',
    'apache-settings.nginxHttp3Enabled' => 'Підтримка HTTP/3',
    'apache-settings.nginxHttp3EnabledDescription' => 'Експериментальна функція. Під час рідкісних інцидентів може впливати на доступність вебсайту.',
    'apache-settings.nginxTransparentMode' => 'Ефективна обробка статичних файлів',
    'apache-settings.nginxTransparentModeDescription' => 'Якщо вимкнена, Apache буде обробляти всі запити файлів. nginx буде лише передавати запити та відповіді без модіфікації. Вимикайте цю опцію лише для пошуку неполадок.',
    'apache-settings.nginxServeStatic' => 'Обслуговувати статичні файли за допомогою nginx',
    'apache-settings.nginxStaticExtensionsLabel' => 'Вкажіть розширення файлів ',
    'apache-settings.nginxStaticExtensions' => 'Вкажіть розширення файлів, розділяючи їх символом "|". Запити цих файлів будуть оброблятись nginx та ніколи не досягнуть Apache. Увага: правила підстановки Apache не будуть застосовуватись.',
    'apache-settings.nginxServePhp' => 'Обробка файлів PHP за допомогою nginx',
    'apache-settings.nginxServePhpDescription' => 'Файли PHP (.php) будуть оброблятись nginx та PHP-FPM. Якщо вимкнути, файли PHP будуть оброблятись Apache.',
    'apache-settings.nginxClientMaxBodySize' => 'Максимальний дозволений розмір тіла запиту HTTP',
    'apache-settings.nginxClientMaxBodySizeDescription' => 'Запити з тілом, що перевищує ліміт, буде відхилено із зазначенням помилки HTTP 413 Payload Too Large (налаштовує значення директиви nginx client_max_body_size).',
    'apache-settings.nginxClientMaxBodySizeDisabled' => 'Параметр вимкнено глобально за допомогою порожнього/нульового значення директиви clientMaxBodySize в panel.ini',
    'apache-settings.nginxCacheEnabled' => 'Увімкнути кешування nginx',
    'apache-settings.nginxCacheEnabledDescription' => 'Кешування може зменшити час, необхідний для відповіді вебсайта, та зменшити навантаження сервера, але його слід використовувати обережно.',
    'apache-settings.nginxCacheSize' => 'Розмір кеша',
    'apache-settings.nginxCacheSizeGb' => 'Гбайт',
    'apache-settings.nginxCacheSizeMb' => 'Мбайт',
    'apache-settings.nginxCacheSizeKb' => 'Кбайт',
    'apache-settings.nginxCacheSizeBytes' => 'Б',
    'apache-settings.nginxCacheTimeout' => 'Таймаут кеша',
    'apache-settings.nginxCacheTimeoutDays' => 'дні',
    'apache-settings.nginxCacheTimeoutHours' => 'години',
    'apache-settings.nginxCacheTimeoutMinutes' => 'хвилини',
    'apache-settings.nginxCacheTimeoutSeconds' => 'секунди',
    'apache-settings.nginxCacheKey' => 'Кеш-ключ',
    'apache-settings.nginxCacheCookies' => 'Кешувати запити з cookies',
    'apache-settings.nginxCacheBypassLocations' => 'Вимкнути кешування для місць',
    'apache-settings.nginxCacheBypass' => 'Обійти кеш, коли',
    'apache-settings.nginxCacheBypassHeaderNocache' => 'В запиті отримано заголовки HTTP no-cache',
    'apache-settings.nginxCacheBypassHeaderAuth' => 'В запиті отримано заголовки HTTP-авторизації',
    'apache-settings.nginxCacheBypassGetNocache' => 'В запиті отримано параметр GET nocache',
    'apache-settings.nginxCacheUseStale' => 'Виписати прострочені кешовані записи',
    'apache-settings.nginxCacheUseStale5xx' => 'Upstream повертає помику сервера 5xx',
    'apache-settings.nginxCacheUseStale4xx' => 'Upstream повертає помику сервера 4xx',
    'apache-settings.nginxCacheUseStaleUpdating' => 'Відбувається оновлення кешу',
    'apache-settings.additional' => 'Додаткові директиви Apache',
    'apache-settings.additionalSettingsDescription' => 'Якщо ви не можете знайти деякі окремі параметри, ви можете додати їх у поля нижче. Ці параметри замістять загальносерверні директиви Apache. Директиви з першого поля використовуються, коли користувач звертається до сайту через протокол HTTP. Загалом, необхідно вносити директиви в обидва поля. Використовуйте такий саме синтаксис, як і у файлі httpd.include. Наприклад, щоб налаштувати спеціальну сторінку відображення помилок, необхідно додати рядок: ErrorDocument 401 /my_error_page.html',
    'apache-settings.additionalSettings' => 'Додаткові директиви для HTTP',
    'apache-settings.additionalSslSettings' => 'Додаткові директиви для HTTPS',
    'apache-settings.additionalSettingsError' => 'Некоректна конфігурація Apache: %%error%%',
    'apache-settings.rollbackFailed' => 'Неможливо застосувати поточний файл конфігурації Apache або повернутись до попередньої версії файлу, тому що обидва ці файли містять некоректну конфігурацію.',
    'apache-settings.additionalNginx' => 'Додаткові директиви nginx',
    'apache-settings.additionalNginxSettingsDescription' => 'На цій сторінці ви можете вказати параметри реверсивного проксі-серверу nginx, який запущений перед Apache. Ваші директиви замістять загальносерверну конфігурацію nginx. Наприклад, ви можете змінити час очікування підключення або упакувати запроси за допомогою gzip. Використовуйте такий саме синтаксис, як і у файлі nginx.conf. Наприклад, щоб упакувати всі проксі-запити за допомогою gzip, необхідно додати рядок: \'gzip_proxied any;\'.',
    'apache-settings.additionalNginxSettings' => 'Додаткові директиви nginx',
    'apache-settings.additionalNginxSettingsError' => 'Некоректна конфігурація nginx: %%error%%',
    'apache-settings.nginxRollbackFailed' => 'Неможливо застосувати поточний файл конфігурації nginx або повернутись до попередньої версії файлу, тому що обидва ці файли містять некоректну конфігурацію.',
    'apache-settings.clearCache' => 'Очистити кеш',
    'apache-settings.clearCacheHint' => 'Очистити кеш nginx для %%website%%',
    'apache-settings.cacheHasClearedSuccessfuly' => 'Кеш успішно очищено',

    'backup.backup-password-protection.securitySettingsSection' => 'Налаштування безпеки резервного копіювання',
    'backup.backup-password-protection.backupPasswordFromFtpSettings' => 'Отримати пароль з «Налаштування віддаленого сховища»',
    'backup.backup-password-protection.backupPasswordManualInput' => 'Ввести пароль вручну.',
    'backup.backup-password-protection.providePasswordCheckbox' => 'Ввести пароль',
    'backup.backup-password-protection.backupPassword' => 'Пароль',
    'backup.backup-password-protection.inputPasswordType' => 'Тип паролю',
    'backup.backup-password-protection.confirmBackupPassword' => 'Повторіть пароль',
    'backup.backup-password-protection.backupPasswordHint' => 'Якщо ви забули свій пароль, зніміть виділення для цієї опції. Майте на увазі, що в цьому випадку деякі конфіденційні дані не будуть відновлені належним чином. Наприклад, паролі користувачів буде замінено на випадкові, інформацію про попередньо встановлені APS-застосунки буде втрачено, і так далі.',
    'backup.backup-password-protection.backupPasswordFtpHint' => 'Якщо ви використовували захист паролем для цієї резервної копії, введіть пароль у нижчезазначених полях. Зауважте, що в разі введення неправильного пароля Plesk не відновить резервну копію. Замість цього резервну копію буде скопійовано в локальне сховище.',

    'backup.conflict-database.dbMappingLegend' => 'Відображення сервера бази даних',
    'backup.conflict-database.serverType' => 'Тип серверу',
    'backup.conflict-database.hostName' => 'Ім’я хосту',
    'backup.conflict-database.port' => 'Порт',
    'backup.conflict-database.destinationDbServer' => 'Сервер цільової бази даних',
    'backup.conflict-database.mysql' => 'MariaDB/MySQL',
    'backup.conflict-database.postgresql' => 'PostgreSQL',
    'backup.conflict-database.mssql' => 'MSSQL',
    'backup.conflict-database.migrationDbServerNotFind' => 'Неможливо відновити базу даних:  відсутній потрібний сервер бази даних.',

    'backup.conflict-ip.buttonUploadMappingFile' => 'Завантажте файл з IP-мапуванням',
    'backup.conflict-ip.ipMappingLegend' => 'Відображення IP',
    'backup.conflict-ip.buttonSaveCurrentMapping' => 'Зберегти нинішній ІР-мапування у файл',
    'backup.conflict-ip.ipAddressNotFound' => 'Вільні ІР-адреси цього типу відсутні.',
    'backup.conflict-ip.sharedIp' => 'спільна',
    'backup.conflict-ip.dedicatedIp' => 'виділена',
    'backup.conflict-ip.fileNotFound' => 'Файл не повинен бути порожнім.',
    'backup.conflict-ip.invalidIpToMap' => 'Невірне значення для старої ІР-адреси: %%ip%%',
    'backup.conflict-ip.invalidMappingValue' => 'Невірне значення для нової ІР-адреси: %%ip%%',
    'backup.conflict-ip.ipNotFound' => 'ІР-адресу %%ip%% не знайдено у базі даних.',
    'backup.conflict-ip.uploadIpMappingFileLegend' => 'Завантажити файл зіставлення ІР',
    'backup.conflict-ip.ipMappingFileHint' => 'Файл ІР-мапування є файлом відкритих даних. Кожен рядок цього файлу містить IP-мапування в форматі: <old IP address> <new IP address>',
    'backup.conflict-ip.oldIp' => 'Старі ІР-адреси',
    'backup.conflict-ip.newIp' => 'Нові ІР-адреси',

    'backup.copy-to-server.ignoreBackupSign' => 'Завантажити файли резервної копії, які не мають коректного підпису',
    'backup.copy-to-server.wrongPassword' => 'Зазначений пароль невірний. Під час відновлення резервної копії, Plesk запросить повторне введення паролю.',
    'backup.copy-to-server.corruptedSignatureUploaded' => 'Завантажений файл резервної копії %%fileName%% було змінено, пошкоджено, створено на іншому сервері або в старій версії Plesk, яка не підтримує підписування резервних копій. Перед відновленням даних з цього файлу резервної копії, переконайтеся, що ви можете довіряти джерелу цього файлу.',
    'backup.copy-to-server.corruptedSignatureNotUploadedUser' => 'Неможливо завантажити резервну копію файлу %%fileName%%. Файл містить змінені чи пошкоджені дані, або його було створено на іншому сервері чи в старій версії Plesk. Для відновлення даних з цього файлу, зверніться до вашого постачальника хостингу.',
    'backup.copy-to-server.corruptedSignatureNotUploadedAdmin' => 'Неможливо завантажити файл резервної копії %%fileName%%. Файл було змінено, пошкоджено, створено на іншому сервері або в старій версії Plesk, яка не підтримує підписування резервних копій. Якщо довіряєте цій резервній копії, оберіть опцію "Завантажити файли резервної копії без дійсних підписів" та повторіть завантаження.',
    'backup.copy-to-server.unableToMoveToLocalRepository' => "Не вдається перемістити %%fileName%% обраної резервної копії до сховища сервера. Помилка: %%error%%.",
    'backup.copy-to-server.missedPartsWarning' => "Нижченаведені частини інкрементного резервування не було скопійовано: %%endl%%%%missedParts%%%%endl%% Скопіюйте пропущені частини.",

    'backup.ftp-settings.isActive' => 'Використовувати сховище FTP(S)',
    'backup.ftp-settings.host' => 'Ім’я хосту сервера FTP або IP',
    'backup.ftp-settings.directory' => 'Каталог для зберігання файлів резервного копіювання',
    'backup.ftp-settings.directoryHint' => 'Приклад: /myfolder/mybackups',
    'backup.ftp-settings.ftpLogin' => 'Ім’я користувача FTP',
    'backup.ftp-settings.ftpPassword' => 'Пароль FTP',
    'backup.ftp-settings.usePassiveMode' => 'Використовуйте пасивний режим',
    'backup.ftp-settings.useFtps' => 'Використовуйте FTPS',
    'backup.ftp-settings.errorHostIsLocal' => 'Використання локального сервера Plesk FTP як віддаленного сховища заборонено. Зазначте віддалене розташування.',
    'backup.ftp-settings.warningHostIsLocal' => 'Параметри сховища FTP(S) були сконфігуровані для зберігання резервних копій на сервері де розміщено файли ваших підписок. Через ризик втрати даних та надмірне використання дискового простору така конфігурація не рекомендується.',
    'backup.ftp-settings.enterFtpLogin' => 'Введіть правильне ім\'я користувача.',
    'backup.ftp-settings.enterFtpPassword' => 'Введіть правильний пароль.',

    'backup.remote-settings.isActive' => 'Використовуйте сховище',
    'backup.remote-settings.initError' => 'Неможливо запустити сторінку налаштувань %%extName%%: %%error%%',

    'backup.remote-storages.backupSecuritySettings' => 'Налаштування безпеки резервного копіювання',

    'backup.restore.detailsSection' => 'Деталі',
    'backup.restore.contentInfoSection' => 'Вміст резервного копіювання',
    'backup.restore.restorationOptionsSection' => 'Опції відновлення',
    'backup.restore.emailNotification' => 'Після виконання завдання з відновлення відправте сповіщення електронною поштою до',
    'backup.restore.comments' => 'Коментарі',
    'backup.restore.creationDate' => 'Дата створення',
    'backup.restore.systemNotes' => 'Системні записи',
    'backup.restore.ownerAdmin' => 'Створено адміністратором.',
    'backup.restore.ownerReseller' => 'Створено посередником.',
    'backup.restore.ownerCustomer' => 'Створено замовником.',
    'backup.restore.ownerServiceUser' => 'Створено додатковим користувачем.',
    'backup.restore.partOfParentBackup' => 'Частина резервного копіювання %%type%%.',
    'backup.restore.server' => 'сервер',
    'backup.restore.reseller' => 'посередник',
    'backup.restore.client' => 'замовник',
    'backup.restore.incremental' => 'Інкрементний.',
    'backup.restore.multiVolume' => 'Мульті-об\'єм.',
    'backup.restore.backupSize' => 'Розмір резервного копіювання',
    'backup.restore.backupSizeFirstIncremental' => '%%this%% (це доповнення) + %%base%% (початкове резервне копіювання) = %%total%%',
    'backup.restore.backupSizeIncremental' => '%%this%% (це доповнення) + %%prev%% (попередні доповнення) + %%base%% (початкове резервне копіювання) = %%total%%',
    'backup.restore.download' => 'Завантажити',
    'backup.restore.downloadHint' => 'Завантажити файл резервної копії на ваш локальний комп\'ютер.',
    'backup.restore.downloadDisabled' => 'Завантаження файлів резервного копіювання тимчасово недоступно. Спробуйте пізніше або зверніться до вашого постачальника послуг.',
    'backup.restore.copy' => 'Копіювати до сховища сервера',
    'backup.restore.copyHint' => 'Копіювати обрані резервні файли до сховища сервера.',
    'backup.restore.contentInfo' => 'Резервне копіювання містить',
    'backup.restore.restoreButton' => 'Відновити',
    'backup.restore.mail' => 'Пошта',
    'backup.restore.domainConfiguration' => 'Конфігурація домену',
    'backup.restore.virtualHost' => 'Вміст віртуального хосту',
    'backup.restore.database' => 'Бази даних',
    'backup.restore.serverConfiguration' => 'Налаштування сервера',
    'backup.restore.serverConfigurationLicense' => 'Ліцензійний ключ',
    'backup.restore.serverPersonalConfiguration' => 'Конфігурація облікових записів адміністратора',
    'backup.restore.serverPersonalDomains' => 'Домени адміністратора',
    'backup.restore.serverPersonalClients' => 'Замовники адміністратора',
    'backup.restore.resellers' => 'Посередники',
    'backup.restore.resellerPersonalConfiguration' => 'Конфігурація облікового запису посередника',
    'backup.restore.resellerPersonalDomains' => 'Домени посередника',
    'backup.restore.resellerPersonalClients' => 'Замовники посередника',
    'backup.restore.clientPersonalConfiguration' => 'Конфігурація облікового запису замовника',
    'backup.restore.clientPersonalDomains' => 'Домени замовника',
    'backup.restore.restoreModifiedSection' => 'Відновити резервну копію файлу незважаючи на пошкоджений підпис.',
    'backup.restore.restoreModifiedDump' => 'Відновити цю резервну копію, незважаючи на те, що вона не має дійсного підпису',
    'backup.restore.resolutionPolicy' => 'Політика вирішення',
    'backup.restore.resolutionPolicyDescription' => 'Конфлікти синхронізації виникають, коли в системі вже існує відновлюваний об’єкт з пізнішою датою модифікації або відновлюваний об’єкт не існує в системі на момент відновлення.',
    'backup.restore.backupRestoreFtpWrongPassword' => 'Зазначений пароль невірний. Резервний файл буде скопійовано в локальне сховище сервера.',
    'backup.restore.backupRestoreLocalWrongPassword' => 'Неможливо відновити резервну копію. Зазначений пароль невірний.',
    'backup.restore.serverContentAndConfiguration' => 'Конфігурація та вміст сервера',
    'backup.restore.serverConfigurationOnly' => 'Конфігурація сервера',
    'backup.restore.resellerContentAndConfiguration' => 'Конфігурація та вміст облікового запису посередника',
    'backup.restore.resellerConfigurationOnly' => 'Конфігурація облікового запису посередника',
    'backup.restore.clientContentAndConfiguration' => 'Конфігурація та вміст облікового запису замовника',
    'backup.restore.clientConfigurationOnly' => 'Конфігурація облікового запису замовника',
    'backup.restore.domainContentAndConfiguration' => 'Конфігурація та вміст домену',
    'backup.restore.domainConfigurationOnly' => 'Конфігурація домену',
    'backup.restore.restoreType' => 'Що саме ви бажаєте відновити?',
    'backup.restore.restoreTypeFull' => 'Усі об\'єкти (загальна система)',
    'backup.restore.restoreTypeGranular' => 'Вибрані об’єкти',
    'backup.restore.restoreObjectType' => 'Тип об’єкту для відновлення',
    'backup.restore.restoreObjectTypeSubscriptions' => 'Підписка',
    'backup.restore.restoreObjectTypeCustomers' => 'Замовник',
    'backup.restore.restoreObjectTypeResellers' => 'Посередник',
    'backup.restore.restoreObjectTypeMailUsers' => 'Обліковий запис електронної пошти',
    'backup.restore.restoreObjectTypeDatabases' => 'База даних',
    'backup.restore.restoreObjectTypeCertificates' => 'Сертифікати SSL/TLS',
    'backup.restore.restoreObjectTypeSites' => 'Сайти',
    'backup.restore.restoreObjectTypeDnsZones' => 'Зона DNS',
    'backup.restore.restoreObjectTypeMailLists' => 'Переліки поштових розсилок',
    'backup.restore.restoreObjectTypeWebContent' => 'Файли доменів',
    'backup.restore.restoreObjects' => '%%objectType%%',
    'backup.restore.restoreObjectsWebContent' => 'Вибрані файли',
    'backup.restore.restoreSubscriptionLookup' => 'Підписка',
    'backup.restore.restoreComponents' => 'Компоненти для відновлення',
    'backup.restore.errorLog' => 'Журнал помилок',
    'backup.restore.backupDetailsLogDoesntExist' => 'Журнал резервного копіювання недоступний.',
    'backup.restore.dumpFailedSection' => 'Журнал помилок',
    'backup.restore.dumpFailed' => 'Неможливо відновити дані: резервна копія файлу недійсна.',
    'backup.restore.granularNotSupported' => 'ви можете вибрати об\'єкти для відновлення тільки під час відновлення з резервних копій, створених у Plesk 12.0 або пізнішій версії.',
    'backup.restore.fullNotSupportedInResellerPowerUser' => 'Відновлення всіх даних з резервної копії в Панелі посередника Power User не підтримується. Виберіть об’єкти для відновлення. ви можете змінити представлення свого інтерфейсу в %%interfaceLink%%',
    'backup.restore.interfaceLink' => 'Параметри інтерфейсу',
    'backup.restore.contentRestoreType' => 'Відновити',
    'backup.restore.contentRestoreTypeSettingsOnly' => 'Тільки конфігурація обраних об\'єктів',
    'backup.restore.contentRestoreTypeFull' => 'Конфігурація та зміст обраних об\'єктів',
    'backup.restore.errorWrongFormat' => 'Резервну копію неможливо відновити, оскільки її файл конфігурації пошкоджено.',
    'backup.restore.errorContentError' => 'Не всі резервні дані можна відновити, оскільки резервна копія містить помилки вмісту.',
    'backup.restore.warningSignError' => 'Неможливо перевірити резервний підпис. Файл резервної копії міг бути змінений, пошкоджений, створений на іншому сервері або в попередній версії Plesk.',
    'backup.restore.warningSignErrorNotAdmin' => 'Це резервне копіювання може бути відновлене лише адміністратором Plesk.',
    'backup.restore.warningPartial' => "Наведені нижче частини інкрементного резервного копіювання знайдено не було: %%endl%%%%missedParts%%%%endl%% Не всі файли можуть бути відновлені. Завантажте пропущені частини та повторіть спробу відновлення.",
    'backup.restore.errorPackedInvalid' => 'Резервну копію неможливо відновити. Файли резервної копії могли бути змінені, пошкоджені, створені в попередній версії Plesk або відсутні.',
    'backup.restore.warningDeprecatedBackupVersion' => 'Резервна копія, яку ви намагаєтесь відновити, була створена у версії Plesk, що вже не підтримується, і її неможливо відновити. Використовуйте розширення Plesk Migrator для переносу ваших даних зі старих версій Plesk.',
    'backup.restore.encryptionKeyError' => 'Паролі для одного чи більше облікових записів у цій резервній копії неможливо відновити; вони будуть скинуті. Мабуть, цю резервну копію було створено на іншому сервері Plesk і зашифровано його ключем шифрування.',
    'backup.restore.errorCorruptedContent' => 'Наступні файли не знайдені або були пошкоджені: ',
    'backup.restore.statusSection' => 'Стан резервного копіювання',
    'backup.restore.statusDetails' => 'Подробиці стану',
    'backup.restore.restoreBlocked' => 'Неможливо відновити резерні копії файлів.',
    'backup.restore.restoreBlockedDescription' => 'Наразі неможливо відновити резерне копіювання типу %%backupType%%. Для його відновлення увійдіть як власник резервних копій файлів і натисніть на це ім\'я резервних копій файлів в розділі Менеджер резервного копіювання.',

    'backup.schedule.scheduleSection' => 'Графік',
    'backup.schedule.backupEnable' => 'Активувати це завдання з резервного копіювання',
    'backup.schedule.backupPeriod' => 'Запустити це завдання з резервного копіювання',
    'backup.schedule.on' => 'у',
    'backup.schedule.at' => 'о',
    'backup.schedule.every' => 'кожний',
    'backup.schedule.hours' => '{period, plural, one {година} few {# години} other {# годин}}',
    'backup.schedule.retainHours' => 'годин',
    'backup.schedule.useIncremental' => 'Скористайтесь інкрементним резервуванням',
    'backup.schedule.useIncrementalDisableHint' => 'Вміст, вибраний для резервного копіювання, дозволяє створити лише повну резервну копію.',
    'backup.schedule.fullBackupPeriod' => 'Виконати повне резервне копіювання',
    'backup.schedule.hourly' => 'Погодинно',
    'backup.schedule.daily' => 'Щодня',
    'backup.schedule.weekly' => 'Щотижня',
    'backup.schedule.monthly' => 'Щомісяця',
    'backup.schedule.yearly' => 'Щорічно',
    'backup.schedule.days' => 'дні',
    'backup.schedule.weeks' => 'тижні',
    'backup.schedule.months' => 'місяці',
    'backup.schedule.years' => 'років',
    'backup.schedule.backupTimeDescription' => 'Часовий пояс: %%timezone%%.',
    'backup.schedule.systemTimeZone' => 'Часовий пояс системи за замовчуванням',
    'backup.schedule.first' => 'перший',
    'backup.schedule.last' => 'останній',
    'backup.schedule.dayOfMonth' => 'день',
    'backup.schedule.email' => 'У разі виникнення помилок під час виконання цього завдання з резервного копіювання, відправте сповіщення електронною поштою до',
    'backup.schedule.invalidFields' => 'Деякі поля порожні або містять неприпустиме значення: %%fields%%.',
    'backup.schedule.maxDumpFiles' => 'Максимальна кількість файлів повного резервного копіювання, що зберігатимуться (включаючи як заплановані, так і ручні резервні копії)',
    'backup.schedule.retainDumpFilesFor' => 'Зберігати повну резервну копію протягом',
    'backup.schedule.maxDumpFilesUnlimitedDescription' => 'Залиште це поле порожнім, якщо не бажаєте автоматично видаляти всі резервні копії.',
    'backup.schedule.maxDumpFilesLimitedDescription' => 'Обмеження, визначене постачальником хостингу для сховища сервера дорівнює %%max%%. Ваш ліміт може бути меншим або дорівнювати %%max%%.',
    'backup.schedule.retainLimitedDescription' => 'Обмеження, визначене хостинг-провайдером для зберігання на сервері, становить {max, plural, one {# резервну копію} few {# резервні копії}  many {# резервних копій} other {# резервні копії}} (включно з усіма запланованими й ручними резервними копіями).',
    'backup.schedule.backupToCloudIsNotAllowed' => 'Зберігання резервних копій запланованих підписок у віддаленому хмарному сховищі є преміум-функцією, яку потрібно придбати в онлайн-магазині Plesk.',
    'backup.schedule.backupHourlyWarning' => 'Погодинне резервне копіювання може призвести до підвищеного використання ресурсів сервера.',
    'backup.schedule.titleHourly' => 'Налаштування погодинного резервного копіювання',
    'backup.schedule.titleDaily' => 'Налаштування щоденного резервного копіювання',
    'backup.schedule.titleWeekly' => 'Налаштування щотижневого резервного копіювання',
    'backup.schedule.titleMonthly' => 'Налаштування щомісячного резервного копіювання',
    'backup.schedule.titleCustom' => 'Користувацькі налаштування резервного копіювання',

    'backup.secure-backup.hint' => 'Ви можете використовувати пароль для шифрування паролів користувачів, що зберігаються у резервній копії у базі даних Plesk. Зауважте, що відновлення резервної копії, захищеної паролем, без пароля змусить Plesk згенерувати паролі користувачів випадковим чином.',
    'backup.secure-backup.hintAdmin' => 'Ви можете шифрувати паролі бази даних Plesk, що зберігаються у резервних копіях, за допомогою ключа шифрування Plesk, або пароля. Ключ є унікальним для кожної інсталяції Plesk. Резервні копії, зашифровані ключем, можуть бути відновлені лише в інсталяції Plesk, де вони були створені, і не можуть бути відновлені у іншій інсталяції Plesk. Зауважте, що Plesk не захищає усі конфіденційні дані у резервній копії. Ми рекомендуємо вам зберігати резервні копії у віддаленому хмарному сховищі та вмикати шифрування резервних копій на стороні хмарного сховища.',
    'backup.secure-backup.usePasswordProtection' => 'Використовуйте захист паролем (рекомендується)',
    'backup.secure-backup.backupPasswordSource' => 'Тип пароля',
    'backup.secure-backup.pleskKey' => 'Код шифрування Plesk',
    'backup.secure-backup.userPassword' => 'Заданий пароль',
    'backup.secure-backup.password' => 'Пароль',
    'backup.secure-backup.passwordConfirmation' => 'Повторіть пароль',

    'backup.subform.settingsSection' => 'Налаштування резервного копіювання',
    'backup.subform.prefix' => 'Додати префікс до імені резервного копіювання',
    'backup.subform.comment' => 'Коментарі',
    'backup.subform.splitSize' => 'Створіть багатотомну резервну копію, розмір тому (МБ)',
    'backup.subform.repository' => 'Зберігати резервне копіювання в',
    'backup.subform.repositoryDescription' => 'Налаштування сховища FTP(S) не задані. %%configure%%',
    'backup.subform.localAndSpecialRepositoryBackup' => 'Як сховище сервера, так і %%name%%',
    'backup.subform.remoteRepositoryOption' => 'Віддалене сховище',
    'backup.subform.remoteRepository' => 'віддалене сховище',
    'backup.subform.remoteRepositoryText' => 'Виберіть віддалене хмарне середовище',
    'backup.subform.configureRemoteRepositories' => '<a href="%%url%%">Налаштуйте віддалене сховище</a> на зберігання резервних копій у хмарі.',
    'backup.subform.configureFtpRepository' => '<a href="%%url%%">Налаштуйте FTP-сховище</a> на зберігання резервних копій поза межами сайту.',
    'backup.subform.configureRemoteDesc' => '%%link%%, щоб зберігати резервні копії у хмарі.',
    'backup.subform.configureRemoteLink' => 'Налаштувати віддалене сховище',
    'backup.subform.configureFtpDesc' => '%%link%%, щоб зберігати резервні копії поза межами сайту.',
    'backup.subform.configureFtpLink' => 'Налаштувати FTP-сховище',
    'backup.subform.repositoryConfigure' => 'Конфігурувати',
    'backup.subform.email' => 'По завершенні завдання резервного копіювання, відправте повідомлення електронною поштою до',
    'backup.subform.contentSection' => 'Вміст резервного копіювання',
    'backup.subform.domainConfiguration' => 'Конфігурація',
    'backup.subform.domainConfigurationVhost' => 'Користувацькі файли та бази даних',
    'backup.subform.domainConfigurationFile' => 'Користувацькі файли',
    'backup.subform.domainConfigurationDatabase' => 'Бази даних',
    'backup.subform.domainConfigurationMail' => 'Поштові повідомлення',
    'backup.subform.content' => 'Створити резервну копію',
    'backup.subform.backupAll' => 'Вся конфігурація та вміст',
    'backup.subform.backupConfiguration' => 'Лише конфігурація',
    'backup.subform.backupVhost' => 'Вся конфігурація та вміст, окрім поштових повідомлень',
    'backup.subform.backupMailFile' => 'Уся конфігурація й вміст, окрім користувацьких баз даних',
    'backup.subform.backupMailDatabase' => 'Уся конфігурація й вміст, окрім користувацьких файлів',
    'backup.subform.backupMail' => 'Лише конфігурація та поштові повідомлення',
    'backup.subform.backupDatabase' => 'Лише конфігурація й користувацькі бази даних',
    'backup.subform.backupFile' => 'Лише конфігурація й користувацькі файли',
    'backup.subform.mssqlNativeBackup' => 'Бажано використовувати власні функціональні можливості MS SQL з резервного копіювання',
    'backup.subform.mssqlNativeBackupAdmin' => 'Використовуйте власну функціональність MS SQL з резервного копіювання. (Для віддалених баз даних пересвідчтеся, що ви сконфігурували налаштування резервного копіювання віддаленого серверу MS SQL в Інструменти та налаштування> Сервери бази даннх)',
    'backup.subform.localRepository' => 'Сховище сервера',
    'backup.subform.localRepositoryPath' => 'Сховище сервера в %%path%%',
    'backup.subform.backupNodeRepository' => '',
    'backup.subform.ftpRepository' => 'Сховище FTP(S) в %%uri%% <a href="%%link%%">Змінити налаштування</a>',
    'backup.subform.ftpRepositoryText' => 'Сховище FTP(S) в %%uri%%',
    'backup.subform.type' => 'Тип',
    'backup.subform.typeFullBackup' => 'Повний',
    'backup.subform.typeIncremental' => 'Інкрементний',
    'backup.subform.typeIncrementalDescription' => 'Зробіть резервне копіювання веб-даних та даних веб-хостингу, що змінилися з останнього резервного копіювання (для бази даних завжди проводиться повне резервне копіювання).',
    'backup.subform.incrementalNotAvailable' => 'Для створення інкрементних резервних копій спочатку необхідно створити повну резервну копію.',
    'backup.subform.excludeLogs' => 'Вилучте журнали',
    'backup.subform.excludeFiles' => 'Вилучте окремі файли з резервного копіювання',
    'backup.subform.excludeFilesDescription' => 'Ви можете вилучити файли лише в межах веб-просторів. Визначте шлях або шляхи, що відносяться до кореня веб-простору, розділяючи окремі файли комами. Використання символа маски дозволено (нпр. /somedir/log*).',

    'backup.upload.uploadHint' => 'Тут можна завантажити резервні файли до сховища Plesk. Максимальний розмір файлу обмежено до двох гігабайт.',
    'backup.upload.backupFile' => 'Резервна копія файлу',
    'backup.upload.removeLink' => 'Видалити',
    'backup.upload.addFileLink' => 'Завантажити більше файлів',
    'backup.upload.backupSecuritySettings' => 'Налаштування безпеки резервного копіювання',
    'backup.upload.signatureHint' => 'Plesk перевіряє резервні копії на допустимість структури та підпис. Файли, які було змінено, пошкоджено або створено на іншому сервері, вважаються недовірчими.  Нижчезазначена опція дозволяє відновити дані з таких файлів. Виберіть цю опцію, лише якщо ви довіряєте джерелу резервної копії; завантаження такого файлу може поставити під загрозу безпеку або порушити роботу сервера. Примітка: резервні копії файлів, які були створені у версіях-попередниках Plesk 11.5, вважаються недовірчими через брак підписів. Відновлюйте такі файли, якщо ви довіряєте їх джерелу.',
    'backup.upload.ignoreSign' => 'Завантажити файли резервної копії, які не мають коректного підпису',
    'backup.upload.passwordHint' => 'Якщо для цієї резервної копії ви використовували захист паролем, введіть пароль у нижчезазначених полях. Майте на увазі, що в разі надання невірного паролю Plesk попередить вас, але все одно вивантажить резервну копію на сервер. Під час відновлення резервної копії вам буде запропоновано повторне введення паролю.',
    'backup.upload.alreadyExistsWarning' => 'Резервний файл %%fileName%% вже існує в локальному сховищі сервера.',
    'backup.upload.incorrectPasswordWarning' => 'Зазначений пароль невірний. Під час відновлення резервної копії, Plesk запросить повторне введення паролю.',
    'backup.upload.deprecatedDumpError' => 'Резервна копія файлу, яку ви намагаєтесь вивантажити, була створена у версії Plesk, що вже не підтримується, і її неможливо імпортувати. Використовуйте розширення Plesk Migrator для переносу ваших даних зі старих версій Plesk.',
    'backup.upload.mailFormatWarning' => 'Резервну копію файла %%fileName%% було завантажено до сховища. Важливо: у резервній копії файла %%fileName%% є вміст пошти, який не буде відновлено, тому що його формат (Plesk 8.3 - 8.6) не підтримується. Для уможливлення відновлення вмісту пошти скопіюйте його за допомогою інструменту резервного копіювання Plesk, виберіть опцію резервного копіювання вмісту пошти та Виберіть опцію з дампом,  що зберігається на сервері пошти.',
    'backup.upload.corruptedSignatureAdminWarning' => 'Завантажену резервну копію файла (%%fileName%%) було змінено, пошкоджено, створено на іншому сервері або в старій версії Plesk, яка не підтримує підписування резервних копій. Перед відновленням даних з цієї резервної копії файла переконайтеся, що ви можете довіряти джерелу цього файлу.',
    'backup.upload.corruptedSignatureAdminError' => 'Не вдалося завантажити резервну копію файла (%%fileName%%).  Файл було змінено, пошкоджено, створено на іншому сервері або в старій версії Plesk, яка не підтримує підписування резервних копій. Якщо ви довіряєте цій резервній копії, Виберіть опцію \"Завантажити резервні копії файлів без дійсних підписів\" і повторіть завантаження.',
    'backup.upload.corruptedSignatureUserWarning' => 'Завантажена резервна копія файла (%%fileName%%) містить змінені чи пошкоджені дані, або вона була створена на іншому сервері чи в старій версії Plesk.',
    'backup.upload.corruptedSignatureUserError' => 'Не вдалося резервну копію файла (%%fileName%%).  Файл містить змінені чи пошкоджені дані, або він був створений на іншому сервері чи в старій версії Plesk. Для відновлення даних з цього файлу зверніться до вашого постачальника хостингу.',
    'backup.upload.uploadError' => 'Не вдалося завантажити %%fileName%% до сховища сервера: %%error%%',
    'backup.upload.fileNotSelected' => 'Для завантаження не було обрано жодного файлу. Виберіть хоча б один профіль.',
    'backup.upload.missedPartsWarning' => "Нижченаведені частини інкрементного резервування завантажено не було: %%endl%%%%missedParts%%%%endl%% Завантажте пропущені частини.",
    'backup.upload.unknownType' => 'Невідомий тип об\'єкту.',
    'backup.upload.storageLink' => 'інше сховище',
    'backup.upload.anotherStorage' => 'Дамп був завантажений до %%storageLink%%.',
    'backup.upload.resellerNotFound' => 'Посередника %%name%% не найдено. Створіть його, щоб відновити завантажений дамп.',
    'backup.upload.clientNotFound' => 'Замовника %%name%% не знайдено. Створіть його, щоб спочатку відновити завантажений дамп.',
    'backup.upload.domainNotFound' => 'Домен %%name%% не знайдено. Створіть його, щоб спочатку відновити завантажений дамп.',

    'backup.web-content-dynamic.addButtonTitle' => 'Додати файли',
    'backup.web-content-dynamic.noItems' => 'Жодного файлу не вибрано',
    'backup.web-content-dynamic.hint' => 'Використовувати прапорці для вибору файлів і папок.',
    'backup.web-content-dynamic.title' => 'Вибрати файли',
    'backup.web-content-dynamic.columnName' => 'Ім’я',
    'backup.web-content-dynamic.columnChangeDate' => 'Змінений',
    'backup.web-content-dynamic.columnSize' => 'Розмір',
    'backup.web-content-dynamic.columnPermissions' => 'Права доступу',
    'backup.web-content-dynamic.columnUser' => 'Користувач',
    'backup.web-content-dynamic.columnGroup' => 'Група',
    'backup.web-content-dynamic.waitButtonTitle' => 'Будь ласка, зачекайте',
    'backup.web-content-dynamic.loadingTitle' => 'Зачекайте, будь ласка. Завантаження…',

    'backup.invalidFields' => 'Деякі поля порожні або містять неприпустиме значення.',
    'backup.notEnoughDiskSpace' => 'За шляхом %%path%% недостатньо дискового простору, аби створити резервну копію. Необхідно мінімум %%required%% ГБ вільного простору (доступно %%available%% ГБ)',

    'change-subscriptions-owner.ownerSection' => 'Новий власник',
    'change-subscriptions-owner.subscriptionsSection' => 'Вибрані підписки',
    'change-subscriptions-owner.owner' => 'Власник',
    'change-subscriptions-owner.subscriptionName' => 'Підписка',
    'change-subscriptions-owner.ownerName' => 'Власник',
    'change-subscriptions-owner.currentIpAddress' => 'Чинні IP-адреси',
    'change-subscriptions-owner.newIpAddress' => 'Нові ІР-адреси',
    'change-subscriptions-owner.noIpAddress' => 'Немає доступних ІР-адрес',
    'change-subscriptions-owner.submit' => 'Перепризначити',
    'change-subscriptions-owner.warningCustom' => "Підписку буде відв'язано від чинного плану послуг і вона стане «Користувацькою».",
    'change-subscriptions-owner.warningEmptyPool' => "Пул ІР-адрес провайдера нового власника порожній. Переконайтеся, що провайдер має принаймні одну ІР-адресу в пулі.",

    'cgroups-settings.cgroupsSettingsTab' => 'RAM, ЦП, дисковий ввід/вивід',
    'cgroups-settings.cgroupsSettingsTabDescription' => 'Встановіть обмеження на споживання системних ресурсів підпискою. Plesk використовує властивість ядра Linux, що називається «контрольні групи» (cgroups), щоб забезпечити дотримання обмежень.',
    'cgroups-settings.cpuSettings' => 'ЦП',
    'cgroups-settings.cpuSettingsDescription' => 'Обмежте індивідуальні підписки визначеним обсягом використання ЦП.',
    'cgroups-settings.cpuPeriodLimit' => 'Інтервал для перевірки використання ЦП',
    'cgroups-settings.percentUsageDescription' => 'Загальна кількість часу ЦП дорівню %%total%%%%units%% вашого сервера',
    'cgroups-settings.ramSettings' => 'RAM',
    'cgroups-settings.ramSettingsDescription' => 'Обмежте індивідуальні підписки визначеним обсягом використання RAM. Зауважте, що якщо підписка перевищує це обмеження, то процес, який споживає найбільше пам\'яті, буде зупинено.',
    'cgroups-settings.ramPeriodLimit' => 'Інтервал для перевірки використання RAM',
    'cgroups-settings.diskSettings' => 'Дисковий ввід/вивід',
    'cgroups-settings.diskReadSettings' => 'Диск для зчитування',
    'cgroups-settings.diskReadSettingsDescription' => 'Дозволити індивідуальним підпискам використовувати пропускну здатність диску для зчитування лише в межах визначеного обмеження.',
    'cgroups-settings.diskReadPeriodLimit' => 'Інтервал для перевірки диску для зчитування',
    'cgroups-settings.diskWriteSettings' => 'Диск для запису',
    'cgroups-settings.diskWriteSettingsDescription' => 'Дозволити індивідуальним підпискам використовувати пропускну здатність диску для запису лише в межах визначеного обмеження.',
    'cgroups-settings.diskWritePeriodLimit' => 'Інтервал для перевірки диску для запису',
    'cgroups-settings.limit' => 'Обмеження',
    'cgroups-settings.threshold' => 'Сповістити, коли досягне',
    'cgroups-settings.limitNotificationEnabled' => 'Активовано сповіщення',
    'cgroups-settings.periodFiveMinutes' => '5 хвилин',
    'cgroups-settings.periodHour' => '1 година',
    'cgroups-settings.periodDay' => '1 день (24 години)',
    'cgroups-settings.mb' => 'МБ',
    'cgroups-settings.mbs' => 'МБ/сек',

    'custom-button.privateLabel' => 'Відображати лише для мене',
    'custom-button.textLabel' => 'Ярлик кнопки',
    'custom-button.tooltipLabel' => 'Текст-підказка',
    'custom-button.iconLabel' => 'Фонова картинка',
    'custom-button.priorityLabel' => 'Пріоритетність',
    'custom-button.urlLabel' => 'URL',
    'custom-button.urlParamsLabel' => 'Додайте параметри до URL',
    'custom-button.placeLabel' => 'Положення',
    'custom-button.internalLabel' => 'Відкрити URL в Plesk',
    'custom-button.internalDescription' => 'Вказати, чи слід відкрити URL на сторінці Plesk або в новому вікні оглядача.',
    'custom-button.noFrameLabel' => 'Не використовуйте фрейми',
    'custom-button.noFrameDescription' => 'Якщо ви додаєте користувацьку кнопку, яка веде до розширення Plesk, або застосунок до розділу Панель замовника, то ви можете визначити як саме це розширення/застосунок буде відображатися: в окремій рамці, чи в якості частини Plesk GUI.',
    'custom-button.urlParamLabel_dom_id' => 'Додайте ідентифікатор підписки, ідентифікатор домену та ідентифікатор псевдоніму домену',
    'custom-button.urlParamLabel_dom_name' => 'Включити ім’я основного домену',
    'custom-button.urlParamLabel_ftp_user' => 'Включити ім’я користувача FTP',
    'custom-button.urlParamLabel_ftp_pass' => 'Включити пароль FTP',
    'custom-button.urlParamLabel_cl_id' => 'Включіть ID замовника',
    'custom-button.urlParamLabel_cname' => 'Включіть назву компанії замовника',
    'custom-button.urlParamLabel_pname' => 'Включіть контактне ім’я замовника',
    'custom-button.urlParamLabel_email' => 'Включіть електронну адресу замовника',
    'custom-button.buttonPlace_navigation' => 'Загальний доступ',
    'custom-button.buttonPlace_admin' => 'Головна сторінка адміністратора',
    'custom-button.buttonPlace_admin-settings' => 'Сторінка інструментів та налаштувань адміністратора',
    'custom-button.buttonPlace_reseller' => "Головна сторінка посередника",
    'custom-button.buttonPlace_reseller-settings' => 'Сторінка Інструменти та утиліти посередника',
    'custom-button.buttonPlace_client' => 'Головна сторінка замовника',
    'custom-button.buttonPlace_domain' => "Веб-сайти та сторінка доменів підписки",
    'custom-button.buttonPlace_domain_powerUser' => "Веб-сайти та сторінка доменів мережевого простору",
    'custom-button.buttonPlace_domain-properties' => 'Інструменти веб-сайту',
    'custom-button.fileNotUploaded' => 'Неможливо завантажити файл.',

    'database-server-change-password.adminPassword' => 'Пароль адміністратора',
    'database-server-change-password.success' => 'Пароль адміністратора було успішно оновлено.',

    'database-server-create.general' => 'Загальні дані',
    'database-server-create.type' => 'Тип серверу бази даних',
    'database-server-create.unixSocket' => '(локальне з’єднання)',
    'database-server-create.host' => 'Ім’я хосту або ІР-адреса',
    'database-server-create.port' => 'Номер порту',
    'database-server-create.portDescription' => 'Залиште порожнім для номера порту за замовчуванням',
    'database-server-create.version' => 'Версія серверу бази даних',
    'database-server-create.default' => 'Використовувати цей сервер за замовчуванням для %%type%%',
    'database-server-create.externalConnections' => 'Дозволити локальному серверу MariaDB/MySQL приймати зовнішні підключення',
    'database-server-create.externalConnectionsDescription' => 'Зміна цього налаштування призведе до перезапуску локального сервера MariaDB/MySQL. Щоб увімкнути віддалений доступ до інших серверів MariaDB/MySQL, зареєстрованих у Plesk, змініть вручну їх конфігурацію.',
    'database-server-create.authentication' => 'Підтвердження автентичності',
    'database-server-create.authenticationAddDescription' => 'Вказати облікові дані адміністратора бази даних, які Plesk використає для доступу до сервера бази даних. Обліковий запис адміністратора з цими обліковими даними повинен бути на сервері бази даних.',
    'database-server-create.authenticationEditDescription' => 'Тут ви можете змінити облікові дані, які Plesk використовує для доступу до сервера бази даних. Ці облікові дані повинні співпадати з обліковими даними адміністратора бази даних. Наприклад, після того як ви змінили облікові дані адміністратора на сервері бази даних, вам також необхідно їх змінити і в Plesk.',
    'database-server-create.authenticationChangeDescription' => 'Тут ви можете змінити облікові дані, які Plesk використовує для доступу до сервера бази даних. Якщо ви зміните нижчезазначені ім\'я користувача або пароль, то обліковий запис користувача бази даних з правами адміністратора буде оновлений як на сервері бази даних, так і в Plesk.',
    'database-server-create.adminLogin' => 'Ім\'я користувача',
    'database-server-create.adminPassword' => 'Пароль',
    'database-server-create.createSuccess' => 'Сервер бази даних успішно створено.',
    'database-server-create.createError' => 'Сервер бази даних створено з помилкою: %%error%%',
    'database-server-create.updateSuccess' => 'Сервер бази даних оновлено.',
    'database-server-create.updateError' => 'Сервер бази даних оновлено з помилкою: %%error%%.',
    'database-server-create.backupSettings' => 'Резервне копіювання',
    'database-server-create.backupTempDir' => 'Тимчасова директорія',
    'database-server-create.backupTempDirDescription' => 'Шлях до фізичної папки на віддаленому сервері, де розташований MS SQL сервер. MS SQL сервер повинен мати доступ до цієї папки для прочитання та запису тимчасових файлів резервного копіювання. Наприклад, C:\\\\DirectoryPath',
    'database-server-create.backupNetworkTempDir' => 'Каталог тимчасової мережі',
    'database-server-create.backupNetworkTempDirDescription' => 'Шлях до мережевого ресурсу повинен бути прив\'язаний до вищезазначеної фізичної папки. Plesk отримає доступ до мережевої папки для завантаження та завантаження файлів. (наприклад, \\ServerName\\DirectoryPath)',
    'database-server-create.backupNetworkUser' => 'Ім\'я користувача',
    'database-server-create.backupNetworkUserDescription' => 'На віддаленому сервері створено користувацьке ім’я користувача мережі. Наприклад, ServerName\UserName. Користувач повинен мати доступ до вищезазначеної спільної папки.',
    'database-server-create.backupNetworkPassword' => 'Пароль',

    'domain.connection-info.title' => 'Інфо підключення',
    'domain.connection-info.systemUserCredentials' => 'Дані входу користувачів системи',
    'domain.connection-info.systemUserCredentialsHint' => 'Доступ через FTP завжди ввімкнений, доступ через SSH або віддалений комп\'ютер - лише якщо %%details%%.',
    'domain.connection-info.systemUserCredentialsHintDetails' => 'наданий дозвіл',
    'domain.connection-info.systemUserRemoveAccessEnabled' => 'Ваш доступ через SSH або віддалений комп\'ютер увімкнений, і ви не можете управляти його станом.',
    'domain.connection-info.systemUserRemoveAccessDisabled' => 'Ваш доступ через SSH або віддалений комп\'ютер вимкнений, і ви не можете управляти його станом.',
    'domain.connection-info.ipAddress' => 'IP-адреса',
    'domain.connection-info.copyIpAddressTooltip' => 'Копіювати IP-адресу в буфер обміну',
    'domain.connection-info.username' => 'Ім\'я користувача',
    'domain.connection-info.copyUsernameTooltip' => 'Копіювати ім\'я користувача в буфер обміну',
    'domain.connection-info.password' => 'Пароль',
    'domain.connection-info.changeSystemUserPasswordTitle' => 'Зміна пароля користувача системи',
    'domain.connection-info.changePasswordTooltip' => 'Змінити пароль',
    'domain.connection-info.newPassword' => 'Новий пароль',
    'domain.connection-info.manageAccess' => 'Управляти доступом',
    'domain.connection-info.additionalFtpAccounts' => 'Додаткові облікові записи FTP',
    'domain.connection-info.database' => 'База даних',
    'domain.connection-info.databaseHint' => '1 з %%number%% баз даних, що належать до підписки.',
    'domain.connection-info.databaseNotCreatedHint' => 'База даних не створена.',
    'domain.connection-info.databaseType.mysql' => 'MySQL',
    'domain.connection-info.databaseType.mssql' => 'MS SQL сервер',
    'domain.connection-info.databaseType.postgresql' => 'PostgreSQL',
    'domain.connection-info.databaseType.mariadb' => 'MariaDB',
    'domain.connection-info.databaseType.percona' => 'Percona',
    'domain.connection-info.databaseHost' => 'Хост',
    'domain.connection-info.databaseHostValue' => '%%value%% (%%fork%%)',
    'domain.connection-info.databaseName' => 'Ім’я бази даних',
    'domain.connection-info.addDatabase' => 'Додати базу даних',
    'domain.connection-info.manageDatabases' => 'Управляти базами даних',
    'domain.connection-info.phpMyAdmin' => 'phpMyAdmin',
    'domain.connection-info.changeDatabaseUserPasswordTitle' => 'Зміна пароля користувача бази даних',
    'domain.connection-info.changeDatabaseUserPasswordNotice' => 'Не забудьте оновити пароль у файлах налаштування вашого застосунку, після того як зміните його тут.',
    'domain.connection-info.buttonSave' => 'Зберегти',
    'domain.connection-info.buttonSaving' => 'Збереження...',
    'domain.connection-info.buttonCancel' => 'Скасувати',
    'domain.connection-info.copyHostTooltip' => 'Копіювати ім\'я хоста в буфер обміну',
    'domain.connection-info.copyDatabaseNameTooltip' => 'Копіювати ім’я бази даних до буфера обміну',
    'domain.connection-info.copyDatabaseUserTooltip' => 'Копіювати користувача бази даних у буфер обміну',

    'domain.move.title' => 'Перемістити домен %%name%%',
    'domain.move.hint' => 'Домен буде перенесений до нової підписки разом з усім вмістом, файлами конфігурації, файлами журналу та застосунками APS.',
    'domain.move.hintMain' => 'Домен буде перенесений до нової підписки разом з усім вмістом, файлами конфігурації, файлами журналу, базами даних, користувачами баз даних, додатковими користувачами FTP, запланованими завданнями та застосунками APS.',
    'domain.move.hintSubdomains' => 'Піддомен(и) %%subdomains%% буде перенесено разом з батьківським доменом.',
    'domain.move.hintAliases' => 'Псевдонім(и) домену %%aliases%% буде перенесено разом з батьківським доменом.',
    'domain.move.hintSubdomainsAndAliases' => 'Піддомен(и) %%subdomains%% та псевдонім(и) домену %%aliases%% буде перенесено разом з батьківським доменом.',
    'domain.move.labelDatabases' => 'Після переміщення домену, відкрийте вкладку «Бази даних» для переміщення пов\'язаних баз даних.',
    'domain.move.hintDatabases' => 'У разі необхідності, переміщайте бази даних окремо.',

    'domain.move.Form.submitButton' => 'Перемістити',
    'domain.move.Form.cancelButton' => 'Скасувати',

    'domain.move.selectTarget' => 'Доступні підписки',
    'domain.move.nothingFound' => 'Нічого не знайдено',
    'domain.move.targetIsRequred' => 'Оберіть підписку для переміщення домену.',
    'domain.move.selectNewSubscription' => 'Створити нову підписку',
    'domain.move.ipv4Address' => 'IPv4-адреса',
    'domain.move.ipv4AddressHint' => 'IP-адреса, за якою закріплено веб-сайт, є мережевою адресою віртуального хосту веб-сайту.',
    'domain.move.ipv6Address' => 'IPv6-адреса',
    'domain.move.ipv6AddressHint' => 'IP-адреса, за якою закріплено веб-сайт, є мережевою адресою віртуального хосту веб-сайту.',
    'domain.move.ipAddressIsNotSelected' => 'Необхідно вибрати хоча б одну IP-адресу.',
    'domain.move.username' => 'Ім\'я користувача',
    'domain.move.usernameHint' => 'Обліковий запис системного користувача, призначений для веб-простору. Використовується для доступу до розміщених файлів через протоколи FTP та SSH.',
    'domain.move.usernameIsRequred' => 'Ви маєте надати ім\'я користувача.',
    'domain.move.password' => 'Пароль',
    'domain.move.passwordIsRequred' => 'Ви маєте надати пароль.',
    'domain.move.noAvailableSubscriptions' => 'Немає доступних підписок',
    'domain.move.noWebHosting' => 'Неможливо створити системного користувача, оскільки на домені немає веб-хостингу.',

    'domain.rename.title' => 'Змінити доменне ім\'я',
    'domain.rename.titleAlias' => 'Змінити псевдонім домену',
    'domain.rename.hint' => 'Зараз ви змінюєте доменне ім\'я %%domainName%%',
    'domain.rename.hintAlias' => 'Зараз ви змінюєте псевдонім домену %%domainName%%',
    'domain.rename.name' => 'Нове доменне ім\'я',
    'domain.rename.nameAlias' => 'Новий псевдонім домену',
    'domain.rename.domainNameIsRequired' => 'Обов’язкове поле не заповнено. Необхідно вказати значення.',
    'domain.rename.submitButton' => 'Змінити',
    'domain.rename.submitButtonProgress' => 'Змінюємо',
    'domain.rename.successMessage' => 'Доменне ім\'я %%oldName%% було змінене на %%newName%%.',
    'domain.rename.successMessageAlias' => 'Псевдонім домену %%oldName%% був змінений на %%newName%%.',

    'domain.rename.Form.cancelButton' => 'Скасувати',

    'domain.outgoing-messages.hint' => 'Тут ви можете змінити обмеження на кількість вихідних повідомлень для цього домену. Неможливо надсилати повідомлення, якщо їх кількість перевищує зазначений ліміт.',
    'domain.outgoing-messages.domainOutgoingMessagesSubscriptionDefault' => 'За замовчуванням (%%domainOutgoingMessages%% повідомлень за годину)',
    'domain.outgoing-messages.domainOutgoingMessagesSpecificHint' => 'повідомлень за годину',
    'domain.outgoing-messages.domainOutgoingMessages' => 'Обмеження на вихідні повідомлення',
    'domain.outgoing-messages.domainOutgoingMessagesCustomLimit' => 'Параметр користувача для цього домену',

    'domain.tech-domain-name.title' => 'Оберіть ваше доменне ім\'я',
    'domain.tech-domain-name.techDomainTitle' => 'Тимчасове доменне ім\'я',
    'domain.tech-domain-name.customDomainTitle' => 'Зареєстроване доменне ім\'я',
    'domain.tech-domain-name.techDomainText' => 'У мене ще немає зареєстрованого доменного імені',
    'domain.tech-domain-name.customDomainText' => 'У мене вже є зареєстроване доменне ім\'я',
    'domain.tech-domain-name.techDomain' => 'Ваше тимчасове доменне ім\'я',
    'domain.tech-domain-name.customDomain' => 'Зареєстроване доменне ім\'я',
    'domain.tech-domain-name.domainName' => 'Доменне ім’я',
    'domain.tech-domain-name.techDomainDesc' => 'Тимчасові доменні імена використовуються для доступу до вашого сайту до його реєстрації та придбання належного доменного імені. Вони надаються безкоштовно з наступними умовами:',
    'domain.tech-domain-name.techDomainRandom' => 'Імена створюються випадково',
    'domain.tech-domain-name.techDomainDns' => 'Вони розташовуються у DNS-зоні .plesk.page',
    'domain.tech-domain-name.techDomainSwitch' => 'Ви можете пізніше переключитися на зареєстроване доменне ім\'я у будь-який час, перейменувавши ваш домен у налаштуваннях домену.',
    'domain.tech-domain-name.error' => 'Виникла неочікувана помилка.',
    'domain.tech-domain-name.errorNoIpAddress' => 'Ви маєте обрати IP-адресу.',
    'domain.tech-domain-name.generating' => 'Генеруємо...',

    'get-password.label' => 'Відновити пароль',
    'get-password.text' => 'Введіть вашу адресу епошти або користувацьке ім\'я, зареєстроване у Plesk, і ми надішлемо вам епошту для скидання пароля.',
    'get-password.emailLabel' => 'Електронна адреса',
    'get-password.loginLabel' => 'Ім\'я користувача',
    'get-password.send' => 'Надіслати',
    'get-password.cancel' => 'Скасувати',
    'get-password.errorInvalidEmail' => 'Недійсна електронна пошта. Будь ласка, перевірте та спробуйте ще раз.',
    'get-password.messageSend' => "Епошта для скидання пароля була надіслана на пов'язану адресу епошти.\nЯкщо епошта не приходить, будь ласка зв'яжіться з вашим адміністратором Plesk.",
    'get-password.rateLimitReached' => "Занадто багато спроб скинути пароль. Спробуйте знову пізніше.",
    'iis-settings.formGeneralHint' => 'Тут ви можете вказати налаштування веб-серверу IIS для вашого веб-сайту, змінивши значення за замовчуванням. Ручне налаштування IIS є корисним, наприклад, коли вам необхідно використати новий тип індекс-файлів на вашому веб-сайті, або для того, щоб зв’язати якийсь конкретний тип MIME з розширенням файлу. Значення за замовчуванням зазвичай встановлюються вашим постачальником хостингу.',
    'iis-settings.formGeneralHint_powerUser' => 'Тут ви можете вказати налаштування веб-серверу IIS для цього веб-сайту. Налаштування IIS корисне, наприклад, коли вам необхідно використати новий тип індекс-файлів на вашому веб-сайті, або для того, щоб зв’язати якийсь конкретний тип MIME з розширенням файлу. Значення за замовчуванням означають, що IIS буде використовувати відповідні директиви зі своїх налаштуваннь за замовчуванням.',
    'iis-settings.virtualDirectoryLoadError' => 'Неможливо отримати властивості зазначеного  віртуального каталогу: %%errorMessage%%',
    'iis-settings.general' => 'Загальні налаштування',
    'iis-settings.example' => "Наприклад:\n%%example%%",
    'iis-settings.settingOn' => 'Увімкнено',
    'iis-settings.settingOff' => 'Вимкнено (за замовчуванням)',
    'iis-settings.settingDefault' => 'За замовчуванням',
    'iis-settings.settingCustom' => 'Ввести користувацьке значення',
    'iis-settings.mimeTypes' => 'Типи MIME',
    'iis-settings.mimeTypesExample' => "text/plain .mytxt\nimage/jpeg .myjpeg",
    'iis-settings.mimeTypesFullDescription' => 'Типи MIME пов’язують розширення файлів з їх типами. Зазвичай це використовується для створення спеціальних розширень файлів для стандартних типів файлів.',
    'iis-settings.documents' => 'Документи за замовчуванням',
    'iis-settings.documentsOff' => 'Вимкнений',
    'iis-settings.documentsCustom' => 'Введіть значення',
    'iis-settings.documentsExample' => "Index.html\nIndex.htm\nIndex.cfm",
    'iis-settings.documentsFullDescription' => 'Якщо браузером не повідомляється назва документа на вашому сайті, IIS шукатиме зазначені стандартні документи та надасть перший знайдений. Якщо ви не зазначите стандартні документи, але увімкнете перегляд каталогів, то в браузері замість сторінки індексів відображатиметься список каталогів.',
    'iis-settings.expires' => 'Спливає строк дії',
    'iis-settings.expiresFullDescription' => 'Веб-сервер додасть до веб-сторінок заголовки відповіді «Спливає строк дії». Часову позначку припинення строку дії можна отримати доданням вищенаведеної кількості часу до часу, в який було надіслано запит до веб-сторінки.',
    'iis-settings.expiresUnitDays' => 'дні',
    'iis-settings.expiresUnitHours' => 'години',
    'iis-settings.expiresUnitMinutes' => 'хвилини',
    'iis-settings.expiresUnitSeconds' => 'секунди',
    'iis-settings.headers' => 'Додаткові заголовки',
    'iis-settings.headersExample' => "Cache-Control: public\nStrict-Transport-Security: max-age=63072000; includeSubdomains;\nX-Frame-Options: DENY",
    'iis-settings.headersFullDescription' => 'Веб-сервер додасть зазначені заголовки відповіді HTTP.',
    'iis-settings.directoryBrowsing' => 'Перегляд каталогу',
    'iis-settings.directoryBrowsingDescription' => 'Дозволяє користувачам бачити список каталогів сайту у веб-оглядачі у випадках, коли встановлена за замовчуванням сторінка-покажчик не є доступною.',
    'iis-settings.securityTabDirectory' => 'Налаштування безпеки каталогу',
    'iis-settings.allowAnonymous' => 'Анонімна перевірка автентичності',
    'iis-settings.allowAnonymousDescription' => 'Анонімна перевірка автентичності надає користувачам доступ до публічного вмісту вашого сайту. Вміст вашого сайту, захищений паролем, а також вміст, захищений на рівні файлової системи, не будуть доступними для анонімних користувачів.',
    'iis-settings.allowWindows' => 'Перевірка автентичності Windows',
    'iis-settings.allowWindowsDescription' => 'Перевірка автентичності Windows (раніше називалась NTLM) захищає вміст вашого сайту на рівні файлової системи.',
    'iis-settings.requireSsl' => 'Потребує SSL/TLS',
    'iis-settings.requireSslDescription' => 'Якщо ви ввімкнули підтримку SSL/TLS для вашого сайту, ця опція буде змушувати веб-клієнтів (браузери) використовувати тільки захищені канали HTTPS.',
    'iis-settings.securityTabIpDeny' => 'Налаштування обмеження доступу',
    'iis-settings.deny' => 'Заборонити доступ до сайту',
    'iis-settings.denyOff' => 'За замовчуванням',
    'iis-settings.denyCustom' => 'Ввести користувацьке значення',
    'iis-settings.allow' => 'Виключення',
    'iis-settings.denyExample' => "10.1.0.0/16\n192.168.1.110\n\nВказані вузли та мережі не мають доступу до сайту. Щоб заборонити всі підключення, введіть симовол '*'.",
    'iis-settings.allowExample' => "192.168.0.0/16\n10.1.1.21\n\nВказані вузли та мережі мають доступ до сайту.",
    'iis-settings.dynamicIpSecurity' => 'Запобігання DoS-атакам за допомогою динамічного обмеження IP-адрес для IIS',
    'iis-settings.isDenyByConcurrentRequests' => 'Заборонити IP-адреси в залежності від кількості одночасних запитів від унікальної IP-адреси',
    'iis-settings.maxConcurrentRequests' => 'Максимальна кількість одночасних запитів',
    'iis-settings.isDenyByRequestRate' => 'Заборонити IP-адреси в залежності від кількості запитів протягом певного періоду часу',
    'iis-settings.maxRequests' => 'Максимальна кількість запитів',
    'iis-settings.requestInterval' => 'Період часу (у мілісекундах)',

    'ip-addresses-selector.ipAddress' => 'IP-адреса',
    'ip-addresses-selector.ipv4Address' => 'IPv4-адреса',
    'ip-addresses-selector.ipv4AddressHint' => "IP-адреса, за якою закріплено веб-сайт, є мережевою адресою віртуального хосту веб-сайту.",
    'ip-addresses-selector.ipv6Address' => 'IPv6-адреса',
    'ip-addresses-selector.ipv6AddressHint' => "IP-адреса, за якою закріплено веб-сайт, є мережевою адресою віртуального хосту веб-сайту.",
    'ip-addresses-selector.noIpAddressHint' => 'Немає',
    'ip-addresses-selector.shared' => 'спільна',
    'ip-addresses-selector.exclusive' => 'виділена',
    'ip-addresses-selector.ipV6OnlyNotSupported' => 'Сервер FTP не підтримує IPv6. Виділіть хоча б одну IPv4-адресу, інакше користувач не зможе вивантажувати файли на сервер через FTP.',

    'license-key-revert.description' => 'Буде відновлено ліцензійний ключ з такими властивостями:',
    'license-key-revert.submitButton' => 'Повернути до передньої версії',

    'license-key-upload.description' => 'Установіть свій ліцензійний ключ, ввівши код активації.',
    'license-key-upload.descriptionWithFileUpload' => 'Установіть свій ліцензійний ключ, ввівши код активації чи завантаживши файл ліцензійного ключа.',
    'license-key-upload.type' => 'Обрати одне з наступних:',
    'license-key-upload.code' => 'Ввести активаційний код',
    'license-key-upload.codeDescription' => 'Вставте отриманий код активації.',
    'license-key-upload.file' => 'Завантажити файл ліцензійного ключа',
    'license-key-upload.fileDescription' => 'Вкажіть шлях до файла, що містить ліцензійний ключ.',
    'license-key-upload.submitButton' => 'Встановити',

    'log-rotation.customLogsDescription' => 'Зауважте, що ваші користувацькі журнали не ротуються.',
    'log-rotation.logRotation' => 'Ротація журналів',
    'log-rotation.logRotationCondition' => 'Умова ротації журналів',
    'log-rotation.logRotationBySize' => 'За розміром',
    'log-rotation.logRotationByTime' => 'За часом',
    'log-rotation.logRotationDaily' => 'Щодня',
    'log-rotation.logRotationWeekly' => 'Щотижня',
    'log-rotation.logRotationMonthly' => 'Щомісяця',
    'log-rotation.logRotationSizeDescription' => 'Значення розміру повинно бути між %%min%% та %%max%% кБ.',
    'log-rotation.maximumNumberOfFiles' => 'Максимальна кількість журналів реєстрації',
    'log-rotation.compress' => 'Стиснути журнали',
    'log-rotation.sendLogToEmail' => 'Після того, як Plesk отримає дані з журналів мережі та FTP-серверів, пошліть журнали електронною поштою на цю адресу',
    'log-rotation.kb' => 'кБ',
    'log-rotation.logRotationPeriodGreater' => 'Період не може бути більшим за обмеження по серверу %%max%%.',

    'login.loginLabel' => 'Ім’я користувача',
    'login.passwdLabel' => 'Пароль',
    'login.loginButtonLabel' => 'Вхід',
    'login.enterUsername' => 'Введіть своє ім’я користувача.',
    'login.enterPassword' => 'Введіть свій пароль.',
    'login.whatUsernamePassword' => 'Які користувацьке ім\'я та пароль використовувати?',
    'login.forgotPasswordLabel' => 'Забули свій пароль?',
    'login.cookies' => 'Політика печива в Plesk',
    'login.avoidSSLWarningsMsg' => 'Для запобігання попереджень SSL під час входу у Plesk використовуйте %%link%%',
    'login.digitalOceanMsg' => 'Тільки починаєте з Plesk на DigitalOcean? Використайте для входу "root" та пароль, уведені під час створення цієї краплі. %%link%%',
    'login.amazonLightsailMsg' => 'Тільки починаєте з Plesk на Lightsail? Для входу в Plesk, увійдіть на сервер через SSH та використайте команду "plesk login". %%link%%',
    'login.readGuide' => 'Прочитати повний посібник.',
    'login.mobileApplicationMessage' => 'Аби було зручніше, ми рекомендуємо встановити програму %%name%%.',
    'login.mobileApplicationInstall' => 'Установити зараз',
    'login.mobileApplicationHide' => 'Ні, дякую',

    'force-reset-password.saveButton' => 'Зберегти',
    'force-reset-password.title' => 'Змінити свій пароль',
    'force-reset-password.passwordLabel' => 'Новий пароль',

    'panel-access.title' => 'Налаштування URL Plesk',
    'panel-access.hint' => 'Виберіть користувацькі URL для входу у Plesk. Це не скасує можливість входити у Plesk через порт %%httpsPort%%. %%link%%',
    'panel-access.details' => 'Подробиці',
    'panel-access.proxyEnabled' => 'Усі домени або піддомени, які належать IP-адресі сервера, але не використовуються для хостингу',
    'panel-access.proxyDomain' => 'Вказаний домен або піддомен, який належить IP-адресі сервера, але не використовується для хостингу',
    'panel-access.proxyDisabled' => 'Немає користувацьких URL. Лише https://<server-IP-or-hostname>:%%httpsPort%%',

    'panel-access.Form.submitButton' => 'Зберегти',
    'panel-access.Form.cancelButton' => 'Скасувати',

    'panel-access.domainNameIsRequired' => 'Ви маєте надати доменне ім\'я.',
    'panel-access.successMessage' => 'Обраний спосіб входу був застосований.',
    'panel-access.notSupported' => 'Обраний спосіб входу не підтримується у вашій версії Plesk.',
    'panel-access.notViaDomainName' => 'Щоб застосувати цей спосіб входу, оберіть першу опцію ("Усі домени та піддомени..."), увійдіть у Plesk через https://%%domainName%% та оберіть другу опцію.',
    'panel-access.notViaPort' => 'Щоб застосувати цей спосіб входу, спочатку увійдіть у Plesk через https://<server-IP-or-hostname>:%%httpsPort%%.',

    'php-settings.performance' => 'Продуктивність та параметри безпеки',
    'php-settings.performanceSettingsNote' => 'Ці значення не можна змінювати для окремого домену за допомогою файлів .htaccess, php.ini або .user.ini, якщо тільки домен не належить до підписки, яка має дозвіл «Керування настройками продуктивності хостингу».',
    'php-settings.settings' => 'Загальні налаштування',
    'php-settings.fastCgiSettings' => 'Налаштування FastCGI',
    'php-settings.fpmSettings' => 'Налаштування PHP-FPM',
    'php-settings.enableFastcgi' => 'Увімкнути налаштування FastCGI',
    'php-settings.plainTextEditing' => 'Додаткові директиви',
    'php-settings.placeAdditionalCustomizationDirectivesHere' => 'Можете визначити будь-які PHP-параметри, вписавши їх до нижченаведеного поля. Настанови будуть включені до PHP-конфігурації. Використовуйте той самий синтаксис, який ви використовуєте для php.ini. Наприклад, для автоматичного завантаження розширення mSQL додайте рядок: extension=msql.so.',
    'php-settings.placeAdditionalCustomizationDirectivesHereAddonPlan' => 'Якщо ви не можете знайти якісь конкретні параметри PHP, впишіть їх у поле нижче. Ці додаткові директиви будуть об’єднані з директивами основного сервісного плану. Використовуйте той самий синтаксис, який ви використовуєте для php.ini. Наприклад, якщо ви бажаєте автоматично завантажити розширення mSQL, додайте рядок: extension=msql.so.',
    'php-settings.placeFpmAdditionalCustomizationDirectivesHere' => 'Можете визначити будь-які PHP-параметри, вписавши їх до нижченаведеного поля. Настанови будуть включені до PHP-конфігурації. Використовуйте той самий синтаксис, який ви використовуєте для php.ini. Наприклад, для автоматичного завантаження розширення mSQL додайте рядок: extension=msql.so. Для персоналізації налаштувань PHP-FPM-пула додайте розділювач [php-fpm-pool-settings] та впишіть потрібні налаштування нижче.',
    'php-settings.additionalConfigurationDirectives' => 'Додаткові директиви з налаштувань',
    'php-settings.defaultValue' => 'За замовчуванням',
    'php-settings.predefinedValue' => 'Оберіть значення',
    'php-settings.customValue' => 'Ввести користувацьке значення',
    'php-settings.phpSettingDescription_memory_limit' => 'Максимальна кількість пам’яті в байтах, якими може розпоряджатися скрипт.',
    'php-settings.phpSettingDescription_max_execution_time' => 'Максимальний час в секундах, який дозволено працювати скрипту перед тим, як він буде припинений.',
    'php-settings.phpSettingDescription_max_input_time' => 'Максимальний час в секундах протягом якого скрипту дозволено аналізувати вхідні дані.',
    'php-settings.phpSettingDescription_post_max_size' => 'Максимальний розмір в байтах даних, які можуть бути розміщені методом POST. Зазвичай вказується розмір більше, ніж upload_max_filesize і менше, ніж memory_limit.',
    'php-settings.phpSettingDescription_upload_max_filesize' => 'Максимальний розмір файла для завантаження у байтах.',
    'php-settings.phpSettingDescription_safe_mode' => 'Безпечний режим роботи PHP включає низку обмежень для виконання скриптів, в першу чергу з огляду на безпеку.',
    'php-settings.phpSettingDescription_safe_mode_include_dir' => 'Файли в зазначеному каталозі є доступними за допомогою скриптів PHP, коли ввімкнено директиву safe_mode. Каталог також має знаходитись в include_path.',
    'php-settings.phpSettingDescription_safe_mode_exec_dir' => 'Програми в зазначеному каталозі можуть виконуватися за допомогою скриптів PHP, коли ввімкнено директиву safe_mode.',
    'php-settings.phpSettingDescription_include_path' => 'Список каталогів, в яких скрипти шукають файли (схожі на перемінну PATH системи). Для відділення каталогів один від другого використовуйте двокрапку (:) для Лінукса і крапку з комою (;) для Windows.',
    'php-settings.phpSettingDescription_sessionsave_path' => 'Каталог для зберігання файлів PHP сесії.',
    'php-settings.phpSettingDescription_mailforce_extra_parameters' => 'Додаткові параметри для функції mail().',
    'php-settings.phpSettingDescription_register_globals' => 'Зареєструвати зміст перемінних EGPCS (Environment, GET, POST, Cookie, Server) як глобальних перемінних.',
    'php-settings.phpSettingDescription_open_basedir' => 'Файли в зазначених каталогах є доступними за допомогою скриптів PHP. Для відділення каталогів один від іншого використовуйте двокрапку (:) для Лінукса і крапку з комою (;) для Windows.',
    'php-settings.phpSettingDescription_error_reporting' => 'Рівень звітності помилок.',
    'php-settings.phpSettingDescription_display_errors' => 'Визначає, чи повинні відображатися помилки як частина вихідних даних.',
    'php-settings.phpSettingDescription_log_errors' => 'Увімкнути реєстрацію помилок PHP.',
    'php-settings.phpSettingDescription_allow_url_fopen' => 'Дозволяє функціям PHP-файлу отримувати дані з віддалених місць через FTP чи HTTP.',
    'php-settings.phpSettingDescription_file_uploads' => 'Дозволяє завантажувати файли через HTTP.',
    'php-settings.phpSettingDescription_short_open_tag' => 'Дозволяє використовувати коротку форму ( ) відкриваючого тегу PHP.',
    'php-settings.phpSettingDescription_magic_quotes_gpc' => 'Встановлює режим magic_quotes для GPC (Get/Post/Cookie) операцій. Коли режим magic_quotes ввімкнений, всі одиночні лапки, подвійні лапки, зворотні слеші та нульові спеціальні знаки автоматично замінюються на зворотні слеші.',
    'php-settings.phpSettingDescription_disable_functions' => 'Ця настанова дозволяє вам вимикати деякі функції. Настанова приймає список імен функцій, розділених комою',
    'php-settings.phpSupport' => 'Підтримка PHP',
    'php-settings.phpRunAs' => 'запустити PHP як',
    'php-settings.phpVersion' => 'Версія РНР',
    'php-settings.phpHandlerOutdated' => '(Застаріла)',
    'php-settings.phpHandlerDeprecated' => '(Вже не підтримується)',
    'php-settings.phpServedByApache' => 'обслуговується з Apache',
    'php-settings.phpServedByNginx' => 'обслуговується з nginx',
    'php-settings.phpSettingsPhpVersion' => 'Ваша нинішня версія PHP: %%version%%.',
    'php-settings.phpSettingsPhpDisabled' => 'PHP вимкнений.',
    'php-settings.phpHandlerTypeHint' => 'Нижче наведено подробиці конфігурації PHP вебсайту. Ви можете змінити конфігурацію PHP, якщо постачальник хостингу надає вам відповідний дозвіл.',
    'php-settings.fpmDedicatedHandlerHint' => 'Використання цього обробника збільшує стабільність вебсайта, але також спричиняє додаткове споживання пам\'яті.',
    'php-settings.phpHandlerChangeHint' => 'Ви змінили налаштування обробника PHP. Якщо ви збережете ці налаштування, то, через налаштування вашого сервера, сценарії PHP на вашому вебсайті можуть зупинитися на %%interval%% с.',
    'php-settings.phpHandlerOutdatedHint' => 'Аби перевірити, чи доступна нова версія PHP, %%link%% і перегляньте категорію «Веб-хостинг» компонентів продукту.',
    'php-settings.phpHandlerOutdatedHintLink' => 'відкрити Plesk Installer',
    'php-settings.phpHandlerTypeHelpLink' => 'Дізнайтеся, як вибрати найбільш підходящі налаштування PHP',
    'php-settings.phpHandlerTypeNotAvailableHint' => 'Неможливо ввімкнути підтримку PHP, тому що поточна конфігурація хостинга не включає версії PHP, доступні для цього домена.',
    'php-settings.phpHandlersNotAvailableHint' => 'Неможливо ввімкнути підтримку PHP, тому що поточна конфігурація Plesk не включає доступні версії PHP.',
    'php-settings.phpHandlerTypeNotAvailableHelpLink' => 'Дізнайтеся, як увімкнути інші версії PHP.',
    'php-settings.phpSupportEditable' => '(Версія PHP %%version%%, запустити PHP як %%handler%%) %%link%%',
    'php-settings.phpSupportReadonly' => '(версія: %%version%%; handler: %%handler%%) %%link%%',
    'php-settings.phpSupportReadonlyNotRegistered' => '(не зареєстрований) %%link%%',
    'php-settings.showPhpInfo' => 'Переглянути сторінку phpinfo()',
    'php-settings.phpSettingsFormError' => 'Неможливо відновити налаштування PHP, тому що відсутні необхідні дані.',
    'php-settings.phpSettingsFormBrokenPhpHandler' => 'Неможливо отримати налаштування PHP, оскільки цю версію PHP не встановлено. Щоб продовжити, установіть вибрану версію PHP чи виберіть іншу для домену.',
    'php-settings.showPhpInfoTitle' => 'Переглянути phpinfo()',
    'php-settings.showPhpInfoDescription' => 'Деякі з ваших налаштувань PHP було змінено, але зміни ще не зберіглися. Щоб побачити нові значення на сторінці phpinfo(), спочатку застосуйте зміни, інакше ви побачите поточні значення.',
    'php-settings.showPhpInfoButton' => 'Переглянути phpinfo()',
    'php-settings.onState' => 'Увімкнути',
    'php-settings.offState' => 'Вимкнути',
    'php-settings.description' => 'Ця сторінка відображає конфігурацію PHP для вебсайта. Ці параметри є спеціальними параметрами вебсайту і вони не впливають на інші вебсайти, що знаходяться на підписці. ви можете змінити конфігурацію PHP, якщо постачальник хостингу надає вам відповідний дозвіл. Користувацькі налаштування PHP можуть використовуватися, наприклад, для обмеження використання системних ресурсів PHP-скриптами, або для того, щоб задовольнити вимоги якогось конкретного веб-застосунка. Коли ви встановлюєте значення параметру за замовчуванням, PHP використовує значення параметру з PHP конфігурації всього серверу.',
    'php-settings.availableVariables' => 'ви можете використовувати такі заповнювачі для значень параметрів:',
    'php-settings.variableDocroot' => '{DOCROOT} для кореневого каталогу з документами цього веб-сайту. Поточне значення - %%DOCROOT%%. %%HTTPS_DOCROOT%%',
    'php-settings.variableDocrootHttpsSame' => 'Кореневий каталог документів HTTPS той самий, що і для http.',
    'php-settings.variableDocrootHttpsDifferent' => 'Кореневий каталог документів HTTPS - %%DOCROOT%%.',
    'php-settings.variableWebspaceRoot' => '{WEBSPACEROOT} для кореневого каталогу з документами основного веб-сайту підписки.',
    'php-settings.variableTmp' => '{TMP} для каталогу, в якому зберігаються тимчасові файли.',
    'php-settings.note' => 'Примітка. Наведені нижче налаштування можуть бути перезаписані параметрами, вказаними у файлах .htaccess, php.ini або .user.ini.',
    'php-settings.showHelp' => 'Показати довідку',
    'php-settings.select-ariaLabel' => 'вибрати значення',
    'php-settings.tuxCarePhpPromo' => 'Вебсайти, які використовують застарілі версії PHP, можуть стати векторами атак. Захистіть їх зараз, перейшовши за допомогою %%link%%',
    'php-settings.tuxCarePhpLink' => 'розширеної підтримки життєвого циклу TuxCare для PHP.',
    'php-settings.phpHandlerLabel' => 'Обробник PHP',
    'php-settings.phpHandlerIdLabel' => 'Запустити PHP як',

    'pmm.agent.sync.check' => 'Migration & Transfer Agent перевіряє наявність оновлень.',
    'pmm.agent.sync.updating' => 'Синхронізація та скачування Migration & Transfer Agent',
    'pmm.agent.sync.done' => 'Migration & Transfer Agent успішно синхронізовано.',
    'pmm.agent.sync.downloadLink' => 'Натисніть та встановіть файл Migration & Transfer Agent, який необхідно встановити на вихідному хості перед початком міграції.',
    'pmm.agent.sync.error' => 'Migration & Transfer Agent не зміг отримати оновлення. Будь ласка, повторіть спробу пізніше.',

    'restore-password.title' => 'Змінити свій пароль',
    'restore-password.passwordLabel' => 'Новий пароль',
    'restore-password.buttonRestore' => 'Зберегти',
    'restore-password.buttonCancel' => 'Скасувати',
    'restore-password.isEmpty' => 'Обов\'язкове поле не заповнено. Необхідно вказати значення.',
    'restore-password.errorInvalidSecret' => 'Невірний секретний код',
    'restore-password.errorNotFoundSecret' => 'Надішліть запит нового секретного коду',
    'restore-password.restoreSuccess' => 'Пароль оновлено. Скористайтеся новим паролем, щоб увійти до Plesk або електронної пошти.',

    'scheduler.settings.schedulerNotification' => 'Заплановане сповіщення',
    'scheduler.settings.notificationOff' => "Вимкнено",
    'scheduler.settings.notificationDefault' => "Відіслати на електронну адресу за замовчуванням (%%email%%)",
    'scheduler.settings.notificationCustom' => "Відіслати на вказану мною електронну адресу",
    'scheduler.settings.crontabSecureShell' => 'Оболонка файлу Crontab',
    'scheduler.settings.schedulerTimezoneSelector' => 'Показувати розклад завдань з використанням часового поясу',
    'scheduler.settings.schedulerTimezoneSelectorDefaultWithLabel' => 'Використовувати часовий пояс в системі за замовчуванням (%%timezone%%)',
    'scheduler.settings.schedulerTimezoneSelectorDefault' => 'Використовувати часовий пояс в системі за замовчуванням',
    'scheduler.settings.schedulerTimezoneSelectorCustom' => 'Використовувати зазначений мною часовий пояс',

    'scheduler.task.active' => 'Активний',
    'scheduler.task.subscription' => 'Підписка',
    'scheduler.task.subscription_powerUser' => 'Веб-простір',
    'scheduler.task.type' => 'Тип завдання',
    'scheduler.task.typeCommand' => 'Запустити команду',
    'scheduler.task.typeUrl' => 'Запит URL',
    'scheduler.task.typeScript' => 'Запустити скрипт PHP',
    'scheduler.task.command' => 'Команда',
    'scheduler.task.arguments' => 'Аргументи',
    'scheduler.task.url' => 'URL',
    'scheduler.task.urlDescription' => 'Вкажіть абсолютний URL, наприклад, http://example.com. Якщо код стану відповіді 2xx або 3xx, то завдання було успішно виконано.',
    'scheduler.task.script' => 'Шлях скрипту',
    'scheduler.task.scriptRelativePathDescription' => 'Приклад: %%path%%',
    'scheduler.task.scriptAbsolutePathDescription' => 'Вкажіть повний шлях до скрипту. Приклад: %%path%%',
    'scheduler.task.scriptPhpVersion' => 'Скористайтесь версією PHP',
    'scheduler.task.scriptPathPopupTitle' => 'Шлях скрипту',
    'scheduler.task.chooseFile' => 'Вибрати файл',
    'scheduler.task.run' => 'Запустити',
    'scheduler.task.on' => 'у',
    'scheduler.task.at' => 'о',
    'scheduler.task.sysUser' => 'Системний користувач',
    'scheduler.task.hourly' => 'Щогодини',
    'scheduler.task.daily' => 'Щодня',
    'scheduler.task.weekly' => 'Щотижня',
    'scheduler.task.monthly' => 'Щомісяця',
    'scheduler.task.yearly' => 'Щороку',
    'scheduler.task.cronStyle' => 'Стиль Cron',
    'scheduler.task.cronStyleHint' => 'Використовувати формат UNIX crontab "хвилина година день-місяця місяць день-тижня". Наприклад, "0 22 * * 1-5". Для запуску завдання Plesk буде використовувати часовий пояс у системі за замовчуванням.',
    'scheduler.task.cronStyleWinHint' => 'Використовувати формат "хвилина година день-місяця місяць день-тижня", наприклад, "0 22 * * 6,7". Для запуску завдання Plesk буде використовувати часовий пояс у системі за замовчуванням.',
    'scheduler.task.notify' => 'Повідомляти',
    'scheduler.task.notifyIgnore' => 'Не сповіщати',
    'scheduler.task.notifyErrors' => 'Тільки помилки',
    'scheduler.task.notifyAlways' => 'Щоразу',
    'scheduler.task.notifyErrorsHint' => 'Сповіщення містять стандартний потік помилок команди. Якщо потік порожній, жодне повідомлення не надсилається.',
    'scheduler.task.notifyErrorsHintWin' => 'Сповіщення містять вивід команди і надсилаються тільки якщо код завершення не дорівнює нулю.',
    'scheduler.task.notifyAlwaysHint' => 'Сповіщення містять вивід команди. Якщо вивід порожній, жодне повідомлення не надсилається.',
    'scheduler.task.notifyAlwaysHintWin' => 'Сповіщення містять вивід команди і надсилаються незалежно від коду завершення команди.',
    'scheduler.task.emailType' => 'Надіслати повідомлення до',
    'scheduler.task.emailTypeDefault' => 'Користувач системи за замовчуванням (%%email%%)',
    'scheduler.task.emailTypeOwner' => 'Власник підписки (%%email%%)',
    'scheduler.task.emailTypeOwnerAdmin' => 'Адміністратор (%%email%%)',
    'scheduler.task.emailTypeCustom' => 'Інші користувачі',
    'scheduler.task.emailTypeCustomDescription' => 'Ви можете вказати декілька адрес, розділяючи їх комами.',
    'scheduler.task.minute' => 'Хвилина',
    'scheduler.task.shortMinute' => 'хв',
    'scheduler.task.dayOfMonth' => 'день',
    'scheduler.task.description' => 'Опис',
    'scheduler.task.scheduleTimezoneHint' => 'Часовий пояс для запуску завдання - %%timezone%%',
    'scheduler.task.runTaskNow' => 'Запустити зараз',
    'scheduler.task.runningTask' => 'Запуск завдання "%%task%%"...',

    'server-settings.submitDone' => "Змінено налаштування сервера.",
    'server-settings.systemSettings' => "Налаштування системи",
    'server-settings.fullHostName' => "Повне ім'я хосту",
    'server-settings.trafficStatisticsPeriod' => "Зберігати веб-статистику і статистику трафіку для",
    'server-settings.trafficStatisticsPeriodUnit' => "місяці",
    'server-settings.diskSpaceUsageCalculation' => "Включіть в підрахунки використання дискового простору",
    'server-settings.includeLogs' => "журнали",
    'server-settings.includeLogsAndStats' => "журнали й статистичні звіти",
    'server-settings.includeMysqlDatabases' => "Бази даних MariaDB/MySQL",
    'server-settings.includeMssqlDatabases' => "Бази даних Microsoft SQL",
    'server-settings.includePgsqlDatabases' => "Бази даних PostgreSQL",
    'server-settings.includeDatabases' => "бази даних",
    'server-settings.includeRemoteDatabases' => "бази даних віддаленого SQL-серверу",
    'server-settings.includeMailboxes' => "поштові скриньки",
    'server-settings.includeMailLists' => "поштові розсилки",
    'server-settings.includeDomainDumps' => "домен резервних файлів",
    'server-settings.includeAdminDumps' => "резервні копії, створені адміністратором",
    'server-settings.calculatingDiskSpaceUsage' => "При підрахунку використання дискового простору, розраховувати",
    'server-settings.typeByte' => "розмір файлу",
    'server-settings.typeBlock' => "обсяг використовуваного дискового простору",
    'server-settings.trafficCalculation' => "Включіть в трафік підрахунки",
    'server-settings.inboundAndOutbound' => "вхідний і вихідний трафік",
    'server-settings.onlyInbound' => "тільки вхідний трафік",
    'server-settings.onlyOutbound' => "тільки вихідний трафік",
    'server-settings.forbidCreateDnsSubZone' => "Заборонити користувачам створювати субзони DNS у надзонах DNS інших користувачів",
    'server-settings.webDeployIncludePassword' => "Включіть пароль користувача у файл з налаштуваннями Розгортання мережі",
    'server-settings.forbidSysUserRename' => "Замовники можуть змінювати імена своїх системних користувачів",
    'server-settings.alwaysAllowSysUserRename' => "завжди",
    'server-settings.ifPermissionIsGrantedAllowSysUserRename' => "тільки якщо надається дозвіл на управління хостингом",
    'server-settings.neverAllowSysUserRename' => "ніколи",
    'server-settings.forbidSubscriptionRename' => "Заборонити клієнтам та посередникам змінювати своє головне доменне ім'я",
    'server-settings.preferredDomain' => "Переважний домен для веб-сайтів",
    'server-settings.preferredDomainNone' => "жоден",
    'server-settings.preferredDomainToLanding' => "domain.tld",
    'server-settings.preferredDomainToWww' => "www.domain.tld",
    'server-settings.ipLogging' => "Запис IP",
    'server-settings.disableIpLogging' => "Вимкнути запис IP у журналах реєстрації IIS, FTP та пошти",
    'server-settings.disableIpLoggingDescription' => "Якщо вибрано, IIS та MailEnable більше не будуть записувати IP-адреси до журналів реєстрації",
    'server-settings.anonymizeIps' => "Анонімізувати ІР-адреси",
    'server-settings.logrotateAnonymizeIps' => "Анонімізувати IP-адреси під час ротації логів та збору мережевої статистики",
    'server-settings.logrotateAnonymizeIpsDescription' => 'Післяротаційний скрипт перед архівацією замінює останній октет IPv4-адрес у виведених файлах логів на «0». У IPv6-адресах скрипт замінює останню частину адреси (два октети після останньої двокрапки) на «0000» (у повній формі) або «0» (у короткій формі)',
    'server-settings.logrotate' => "Ротація логів",
    'server-settings.logrotateForce' => "Встановити примусову ротацію логів для усіх доменів",
    'server-settings.allowToStoreLogs' => "Дозволити зберігати журнали веб-сайтів для",
    'server-settings.logrotatePeriod' => "дні",
    'server-settings.configureUpdatePolicy' => "Сконфігурувати політику оновлення",

    'service-plan.mail.outgoing-messages.outgoingMessagesDefault' => 'Значення всього сервера за замовчуванням (%%default%% повідомлень за годину)',
    'service-plan.mail.outgoing-messages.outgoingMessagesSpecificPlan' => 'Користувацьке значення для плану',
    'service-plan.mail.outgoing-messages.outgoingMessagesSpecificSubscription' => 'Користувацьке значення для підписки',
    'service-plan.mail.outgoing-messages.outgoingMessagesSpecificHint' => 'повідомлення',
    'service-plan.mail.outgoing-messages.mboxOutgoingMessages' => 'Вихідні повідомлення з поштової скриньки (за годину)',
    'service-plan.mail.outgoing-messages.domainOutgoingMessages' => 'Вихідні повідомлення з домену (за годину)',
    'service-plan.mail.outgoing-messages.subscriptionOutgoingMessages' => 'Вихідні повідомлення з підписки (за годину)',
    'service-plan.mail.outgoing-messages.outgoingMessagesOverLimit' => 'Відсоток повідомлень, що перевищують ліміт на одну годину, і які повинні бути відправлені протягом наступної години',
    'service-plan.mail.outgoing-messages.outgoingMessagesOverLimitDescription' => 'Якщо обмеження на вихідні електронні повідомлення з поштової скриньки за годину становить 100 штук, а відсоток дорівнює 10%, то користувач має право надіслати 110 повідомлень за годину; 100 повідомлень будуть відправлені протягом години, а 10 повідомлень будуть поставлені в поштову чергу і заплановані до відправки протягом наступної години.',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmail' => 'Політика використання Sendmail',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailDefault' => 'Загальносерверні налаштування за замовчуванням (Sendmail дозволено)',
    'service-plan.mail.outgoing-messages.outgoingMessagesNotEnableSendmailDefault' => 'Загальносерверні налаштування за замовчуванням (Sendmail не дозволено)',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailCustomPlan' => 'Користувацькі налаштування для плану',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailCustomSubscription' => 'Користувацькі налаштування для підписки',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailCustomLabel' => 'Дозволити використовувати Sendmail скриптам і користувачам на цій підписці',
    'service-plan.mail.outgoing-messages.outgoingMessagesEnableSendmailCustomHint' => 'Скрипти і користувачі зможуть відправляти повідомлення електронної пошти (від імені системного користувача підписки) за допомогою Sendmail, навіть якщо було перевищено ліміт для поштової скриньки і домену. Максимальна кількість повідомлень, які можна відправити через Sendmail, визначатиметься обмеженням для всієї підписки.',

    'setup.hint' => 'Ласково просимо до Plesk, панелі управління, що допомагає вам управляти вашим сервером. Plesk надає вже готове для кодування середовище та дає вам низку потужних розширень, що допоможуть вам розробляти вебсайти та застосунки. Для того, щоб почати користуватися Plesk, завершіть процес налаштування (це триває лише хвилину).',
    'setup.contactInfoSection' => 'Контактна інформація',
    'setup.contactInfoSectionHint' => 'Введіть своє ім\'я та електронну поштову адресу, щоб визначити себе в якості власника сервера та отримувати важливі повідомлення щодо сервера. Якщо ви - адміністратор корпоративного сервера, не вводьте свої особисті ім\'я чи електронну поштову адресу. Замість цього використовуйте назву вашої посади та корпоративну електронну поштову адресу аби уникнути можливого порушення закону про захист даних.',
    'setup.contactName' => 'Ваше контактне ім\'я',
    'setup.emptyContactName' => 'Будь ласка, надайте ім\'я контактної особи.',
    'setup.contactNameTooLong' => 'Ім\'я контактної особи занадто довге (максимум %max% символів дозволено).',
    'setup.email' => 'Електронна пошта',
    'setup.emptyEmail' => 'Будь ласка, вкажіть адресу електронної пошти.',
    'setup.passwordSection' => 'Пароль',
    'setup.passwordSectionHint' => 'Наступного разу, коли ви ввійдете до Plesk, використовуйте пароль та ім\'я користувача \'admin\', що наведені нижче.',
    'setup.password' => 'Пароль',
    'setup.licenseSection' => 'Ліцензія',
    'setup.licenseSectionHint' => 'Для користування Plesk вам потрібно встановити ліцензію.',
    'setup.licenseType' => 'Виберіть тип вашої ліцензії',
    'setup.licenseTypePaid' => 'Продовжуйте з платною ліцензією',
    'setup.activationCodeLabel' => 'Ввести тут свій код активації',
    'setup.onlineStoreLink' => 'Онлайн-магазин',
    'setup.licenseTypeTrial' => 'Продовжуйте з повнофункціональною пробною ліцензією',
    'setup.activationCodeHint' => 'Якщо ви вже купили ліцензію Plesk, вставте отриманий активаційний код, тут. Якщо ні, то ви можете купити нову ліцензію в нашому %%onlineStoreLink%%.',
    'setup.privacyPolicyLink' => 'Політика конфіденційності WebPros',
    'setup.trialLicenseAgreement' => 'З ціллю видання тимчасової ліцензії WebPros International GmbH використовуватиме та оброблятиме надану інформацію у своїх внутрішніх системах відповідно до: %%privacyPolicyLink%%.',
    'setup.eulaAgreementLabel' => 'Я підтверджую, що прочитав і приймаю %%link%%',
    'setup.eula' => 'Ліцензійна угода для кінцевого користувача',
    'setup.invalidEulaAgreementValue' => 'Ви повинні прийняти ліцензійну угоду для кінцевого користувача',
    'setup.sendButton' => 'Вхід до Plesk >>',
    'setup.resetPasswordOnFirstLogin' => 'Скинути пароль адміністратора при наступному вході',

    'spam-filter.add.titleBlack' => 'Додати адреси до чорного списку',
    'spam-filter.add.titleWhite' => 'Додати адреси до білого списку',
    'spam-filter.add.fileDescription' => 'Вивантажити файл у кодуванні UTF-8 (наприклад, *.txt або *.csv).',
    'spam-filter.add.listDescription' => 'Правила форматування: <ul><li>Відокремлюйте кожну адресу комою, крапкою з комою, розривом рядка, пробілом або символами табуляції.</li><li>Не використовуйте символи, відсутні в системі ASCII, зліва від знака @.</li><li>Ви можете використовувати спеціальні символи «*» та «?» (наприклад, <nobr>*@domain.com,</nobr> <nobr>user?@*.com</nobr>).</li><li>Не використовуйте спеціальні символи в частинах доменних імен, кодування яких відрізняється від ASCII.</li></ul>',
    'spam-filter.add.fromFile' => 'З файлу',
    'spam-filter.add.fromList' => 'Зі списку',
    'spam-filter.add.success' => 'Адреси додано',

    'ssl-certificate.add.name' => 'Ім’я сертифікату',
    'ssl-certificate.add.longName' => 'Зазначене ім’я сертифікату занадто довге (дозволено не більше %max% символів).',
    'ssl-certificate.add.certificateNameUsed' => 'Сертифікат із іменем %%name%% вже існує.',
    'ssl-certificate.add.certificateAdded' => 'Сертифікат SSL/TLS було видано. Щоб його активувати, призначте цей сертифікат для захисту домену, пошти або веб-пошти.',
    'ssl-certificate.add.certificateUpdated' => 'Сертифікат SSL/TLS успішно додано.',
    'ssl-certificate.add.settings' => 'Налаштування',
    'ssl-certificate.add.settingsHint' => 'Використовуйте цю форму для того, щоб створити запит на сертифікат, купити сертифікат у вашого постачальника або щоб створити самопідписаний сертифікат.',
    'ssl-certificate.add.settingsHint2' => 'Запит – це CSR-файл, який містить інформацію про зазначений вами у формі домен. Для надання вам сертифікату ви можете надіслати запит до центру сертифікації. Потім ви його вивантажите, використовуючи одну з нижчезазначених форм вивантаження.',
    'ssl-certificate.add.settingsHint3' => 'Самопідписаний сертифікат - це сертифікат посвідчення, підписаний його власним автором. Використання такого сертифікату означає, що ви самостійно перевіряєте та засвідчуєте ваші вебсайти. Хоча самопідписані сертифікати дозволяють використання SSL/TLS, вони є менш довірчими та вважаються менш безпечними.',
    'ssl-certificate.add.bits' => 'Біт',
    'ssl-certificate.add.country' => 'Країна',
    'ssl-certificate.add.state' => 'Країна чи область',
    'ssl-certificate.add.longState' => 'Зазначена назва штату або провінції занадто довга.',
    'ssl-certificate.add.city' => 'Розташування (місто)',
    'ssl-certificate.add.longCity' => 'Вказана назва міста занадто довга.',
    'ssl-certificate.add.shortCity' => 'Вказана назва міста занадто коротка.',
    'ssl-certificate.add.companyName' => 'Назва організації (компанії)',
    'ssl-certificate.add.longCompanyName' => 'Вказане ім’я компанії занадто довге.',
    'ssl-certificate.add.companyUnitName' => 'Назва відділу чи підрозділу організації',
    'ssl-certificate.add.longCompanyUnitName' => 'Зазначена назва структурного підрозділу занадто довга (дозволено не більше %max% символів).',
    'ssl-certificate.add.domainName' => 'Ім\'я домену',
    'ssl-certificate.add.email' => 'Електронна пошта',
    'ssl-certificate.add.request' => 'Надіслати запит',
    'ssl-certificate.add.buyCertificate' => 'Купити сертифікат SSL/TLS',
    'ssl-certificate.add.selfSigned' => 'Самозасвідчуваний',
    'ssl-certificate.add.invalidCertificateParams' => 'Деякі поля порожні або містять невірні значення. Максимальна кількість знаків у полі: 64. Якщо ви використовуєте інтернаціоналізоване доменне ім’я, переконайтеся, що під час трансформування у формат ASCII жодна частина доменного імені між крапками не перевищує 63 символів. Перевірте поля:',
    'ssl-certificate.add.unableCreateCsr' => 'Не вдалося створити CSR: %%error%%',
    'ssl-certificate.add.unableCreateSelfSigned' => 'Не вдалося створити самопідписаний сертифікат: %%error%%',
    'ssl-certificate.add.unableCreateUpload' => 'Не вдається задати дані сертифіката: %%error%%',
    'ssl-certificate.add.unableSaveCertificate' => 'Не вдалося зберегти сертифікат у базі даних: %%error%%',
    'ssl-certificate.add.uploadFiles' => 'Завантажити файли сертифікату',
    'ssl-certificate.add.uploadFilesHint' => 'Скористайтесь цією формою для завантаження компонентів сертифіката як складових файлів.',
    'ssl-certificate.add.csr' => 'CSR (запит на підписання сертифікату)',
    'ssl-certificate.add.privateKey' => "Приватний ключ (*.key)",
    'ssl-certificate.add.certificate' => "Сертифікат (*.crt)",
    'ssl-certificate.add.caCertificate' => "Сертифікат ЦС (*-ca.crt)",
    'ssl-certificate.add.sendFiles' => "Завантажити сертифікат",
    'ssl-certificate.add.fileNotUploaded' => 'Не вдалося завантажити файл сертифікату: %%name%%.',
    'ssl-certificate.add.unableSetPrivateKey' => 'Не вдається задати приватний ключ: %%error%%',
    'ssl-certificate.add.unableSetCertificate' => 'Не вдається задати сертифікат: %%error%%',
    'ssl-certificate.add.unableSetCaCertificate' => 'Не вдається задати сертифікат ЦС: %%error%%',
    'ssl-certificate.add.unableCheckCaCertificate' => 'Не вдається перевірити, чи сертифікат ЦС підписує цей сертифікат: %%error%%',
    'ssl-certificate.add.removeCaCertificate' => 'Видалити',
    'ssl-certificate.add.removeCaCertificateConfirmation' => 'Ви дійсно бажаєте видалити сертифікат ЦС?',
    'ssl-certificate.add.unableRemoveCaCertificate' => 'Не вдається очистити сертифікат ЦС: %%error%%',
    'ssl-certificate.add.caCertificateRemoved' => 'ЦС- частину сертифікату вилучено.',
    'ssl-certificate.add.rename' => 'Перейменувати',
    'ssl-certificate.add.unableRenameCertificate' => 'Не вдається перейменувати сертифікат: %%error%%',
    'ssl-certificate.add.certificateRenamed' => 'Ім’я сертифікату змінено на %%name%%.',
    'ssl-certificate.add.uploadText' => "Завантажити сертифікат у вигляді тексту",
    'ssl-certificate.add.uploadTextHint' => 'Скористайтесь цією формою для завантаження компонентів сертифіката як тексту. Скопіюйте вміст файлу та вставте його у відповідне поле.',
    'ssl-certificate.add.sendText' => "Завантажити сертифікат",
    'ssl-certificate.add.componentIsMissing' => 'Компонент відсутній.',

    'ssl-certificate.find-private-key.findPrivateKey' => 'Завантажте сертифікат тут',
    'ssl-certificate.find-private-key.formGeneralHint' => 'Якщо ви створили запит на підпис сертифіката на цьому сервері та отримали файл сертифіката, вивантажте його тут. Якщо хочете вивантажити пару з сертифіката та приватного ключа, згенерованих на іншому сервері, чи створити самопідписаний сертифікат, натисніть <b>Додайте сертифікат SSL/TLS</b>.',
    'ssl-certificate.find-private-key.formCertificateAddingHint' => 'Після додання сертифікату SSL/TLS до домену вам необхідно включити підтримку SSL/TLS і вибрати цей сертифікат в налаштуваннях хостингу вебсайту: <b>Вебсайти та домени</b> > <b>Налаштування хостингу </b> цього домену > <b>Безпека</b>.',
    'ssl-certificate.find-private-key.uploadCertificate' => 'Сертифікат (*.crt)',
    'ssl-certificate.find-private-key.sendFile' => 'Завантажити сертифікат',
    'ssl-certificate.find-private-key.fileNotUploaded' => 'Не вдалося завантажити файл сертифікату.',
    'ssl-certificate.find-private-key.invalidCertificateFormat' => 'Невірний формат сертифіката.',
    'ssl-certificate.find-private-key.unableFindPrivateKey' => 'Неможливо знайти відповідний персональний ключ для сертифікату.',

    'ssl-certificate.secure.certificate' => 'Виберіть сертифікат',
    'ssl-certificate.secure.serverPool' => 'пул сервера',
    'ssl-certificate.secure.certificateName' => '%%certificateName%% (%%repositoryName%%)',

    'system-time.date' => "Дата",
    'system-time.dateAndTime' => "Дата і час",
    'system-time.daylight' => "Годинник, що автоматично налаштовується на літній час",
    'system-time.dayMonthYear' => "День-Місяць-Рік",
    'system-time.domainNameOrIp' => "І’мя домену чи IP",
    'system-time.hoursMinutesSeconds' => "Години:Хвилини:Секунди",
    'system-time.networkTime' => "Час мережі",
    'system-time.submitDone' => "Налаштування системного часу було змінено.",
    'system-time.synchronizedSystemTime' => "Синхронізуйте час системи",
    'system-time.title' => "Система дати та часу",
    'system-time.timezone' => "Часовий пояс",
    'system-time.time' => "Час",
    'system-time.updateSystemTime' => "Час оновлення системи",
    'system-time.yourTimezone' => "Ваш часовий пояс",

    'web-app-firewall.pageHint' => 'Брандмауер мережевих застосунків захищає мережеві застосунки від атак, перевіряючи та фільтруючи вхідні HTTP-запити, виходячи з правил, визначених користувачем.',
    'web-app-firewall.webSitePageHint' => 'Тут ви можете налаштувати мережевий екран веб-застосунку (ModSecurity).',
    'web-app-firewall.ruleEngine' => 'Режим мережевого екрану веб-застосунку',
    'web-app-firewall.ruleEngineOn' => 'Увімкнути',
    'web-app-firewall.ruleEngineOnDescription' => 'Кожен вхідний HTTP-запит та пов\'язана відповідь перевіряються набором правил. Якщо перевірка успішна, HTTP-запит передається до вмісту вебсайту. Якщо перевірка невдала, подія записується, надсилається сповіщення, а HTTP-відповідь надається з кодом помилки.',
    'web-app-firewall.ruleEngineOff' => 'Вимкнути',
    'web-app-firewall.ruleEngineOffDescription' => 'Вхідні HTTP-запити і пов\'язані з ними відповіді не перевіряються.',
    'web-app-firewall.ruleEngineDetectionOnly' => 'Тільки виявлення',
    'web-app-firewall.ruleEngineDetectionOnlyDescription' => 'Кожен вхідний HTTP-запит та пов\'язана відповідь перевіряються набором правил. Якщо перевірка успішна, HTTP-запит передається до вмісту вебсайту. Якщо перевірка невдала, подія записується і ModSecurity не виконує жодних інших дій. Інші послуги (наприклад, Fail2ban) все одно можуть виконувати свої власні дії з HTTP-запитами, що не пройшли перевірку.',
    'web-app-firewall.ruleSetsSection' => 'Набори правил',
    'web-app-firewall.ruleSetsSectionHint' => 'Оберіть який набір правил (пакунок файлів, що містить правила безпеки) використовуватиметься для перевірки вхідних HTTP-запитів.',
    'web-app-firewall.ruleSet' => 'Набір правил',
    'web-app-firewall.ruleSetCrs' => 'OWASP (безкоштовно)',
    'web-app-firewall.ruleSetCrsDescription' => 'Набір правил ядра ModSecurity OWASP може бути дуже обмежувальним і таким чином блокувати деякі функції (наприклад, спільний доступ до файлів або веб-пошта) та деякі функції веб-застосувань (наприклад, плагіни WordPress).',
    'web-app-firewall.ruleSetCrsConfirmTitle' => 'Застосувати зміни?',
    'web-app-firewall.ruleSetCrsConfirmDescription' => 'Правила OWASP можуть бути надто обмежувальними і відтак блокувати деякі функції, такі як спільний доступ до файлів, веб-пошта та деякі веб-застосунки.',
    'web-app-firewall.ruleSetTortix' => 'Стандартна версія Atomic (безкоштовно, можна покращити до розширеної версії)',
    'web-app-firewall.ruleSetTortixDescription' => 'Базова версія правил ModSecurity від Atomicorp. Надає базовий захист та оновлюється щомісяця.',
    'web-app-firewall.ruleSetTortixHowTo' => 'Для покращення цього набору правил до розширеної версії Atomic необхідно:',
    'web-app-firewall.ruleSetTortixBuy' => '%%linkPleskStore%% - придбати на веб-сайті Plesk та %%linkDocumentation%%.',
    'web-app-firewall.ruleSetTortixLinkPleskStoreLabel' => 'Розширені правила ModSecurity від Atomicorp',
    'web-app-firewall.ruleSetTortixLinkDocumentationLabel' => 'встановити придбаний додатковий ліцензійний ключ',
    'web-app-firewall.ruleSetTortixSelect' => 'Виберіть цей набір правил, який змінить свою назву на «Розширена версія Atomic (придбано у Plesk)»',
    'web-app-firewall.ruleSetTortixPro' => 'Розширена версія Atomic (придбано у Plesk)',
    'web-app-firewall.ruleSetTortixProDescription' => 'Розширені правила ModSecurity від Atomicorp містять стандартні правила Atomic та певну кількість розширених функцій.',
    'web-app-firewall.ruleSetAtomic' => 'Розширена версія Atomic (придбано у Atomicorp)',
    'web-app-firewall.ruleSetAtomicDescription' => 'Розширені правила ModSecurity від Atomicorp містять стандартні правила Atomic та певну кількість розширених функцій.',
    'web-app-firewall.ruleSetAtomicInstall' => 'Переключіться на інший обліковий запис Atomicorp.',
    'web-app-firewall.ruleSetAtomicInstalled' => 'Набір правил активовано.',
    'web-app-firewall.ruleSetAtomicHowTo' => 'Якщо ви вже маєте обліковий запис у Atomicorp з придбаною розширеною версією правил Atomic, вкажіть свої дані нижче, щоб увімкнути цей набір правил.',
    'web-app-firewall.ruleSetAtomicSwitchHowTo' => 'Якщо ви вже маєте обліковий запис Atomicorp з придбаними правилами Atomic Advanced, введіть дані облікового запису внизу для переключення облікового запису.',
    'web-app-firewall.ruleSetAtomicLogin' => 'Ім’я користувача',
    'web-app-firewall.ruleSetAtomicPassword' => 'Пароль',
    'web-app-firewall.ruleSetComodo' => 'Comodo (безкоштовна підписка)',
    'web-app-firewall.ruleSetComodoDescription' => 'Безкоштовні правила ModSecurity від Comodo. Надають базовий захист.',
    'web-app-firewall.ruleSetComodoInstall' => 'Переключіться на інший обліковий запис Comodo.',
    'web-app-firewall.ruleSetComodoInstalled' => 'Набір правил активовано.',
    'web-app-firewall.ruleSetComodoHowTo' => 'Для активації цього набору правил:',
    'web-app-firewall.ruleSetComodoSwitchHowTo' => 'Для того, аби переключитися на інший обліковий запис:',
    'web-app-firewall.ruleSetComodoRegister' => 'Зареєструватися на веб-сайті Comodo.',
    'web-app-firewall.ruleSetComodoCredentials' => 'Введіть своє ім’я користувача та пароль з цього веб-сайту.',
    'web-app-firewall.ruleSetComodoLogin' => 'Ім’я користувача',
    'web-app-firewall.ruleSetComodoPassword' => 'Пароль',
    'web-app-firewall.ruleSetComodoFree' => 'Comodo (безкоштовно)',
    'web-app-firewall.ruleSetComodoFreeDescription' => 'Безкоштовні правила ModSecurity від Comodo. Надають базовий захист.',
    'web-app-firewall.ruleSetCustom' => 'Користувальницький набір правил',
    'web-app-firewall.ruleSetCustomDescription' => 'Завантажте настроюваний набір правил мережевого екрану веб-застосунку. Підтримувані формати: zip, tar.gz, tgz, tar.bz2, conf.',
    'web-app-firewall.ruleSetCustomUpload' => 'Вибрати інший файл',
    'web-app-firewall.ruleSetError' => 'Не вдалося встановити набір правил ModSecurity: %%error%%',
    'web-app-firewall.ruleSetOWASPMissingError' => 'Відсутній набір правил OWASP. Перевстановіть ModSecurity із використанням Plesk installer.',
    'web-app-firewall.ruleSetCustomMissingError' => 'Відсутній набір правил користувача. Перевстановіть набір правил.',
    'web-app-firewall.ruleSetAuthError' => 'Невірне зазначене ім\'я користувача або пароль.',
    'web-app-firewall.ruleSetInvalid' => 'Обране правило не можна запустити на %%webServer%%.',
    'web-app-firewall.ruleSetSelectedInvalid' => 'Обране правило не може бути запущене на обраному мережевому сервері.',
    'web-app-firewall.webServer' => 'Запустити правила на',
    'web-app-firewall.webServerHint' => 'Оберіть бажану комбінацію мережевого сервера та версії ModSecurity, аби переглянути сумісні набори правил.',
    'web-app-firewall.webServerApache' => 'Apache (ModSecurity 2.9)',
    'web-app-firewall.webServerNginx' => 'Nginx (ModSecurity 3.0)',
    'web-app-firewall.webServerIis' => 'IIS (ModSecurity 2.9)',
    'web-app-firewall.nginxNotRunning' => 'Зворотний проксі-сервер (nginx) вимкнений і не може використовуватися для обробки запитів. Оберіть <a href="%%serverUrl%%">інший мережевий сервер</a> або ввімкніть зворотний проксі-сервер на <a href="%%servicesUrl%%">сторінці Управління послугами</a>.',
    'web-app-firewall.nginxIsIncompatible' => 'Вибір іншої версії ModSecurity може зробити деякі налаштування недійсними (наприклад, у ModSecurity 3 ви не можете використовувати регулярні вирази для вимикання правил безпеки). Переконайтеся, що після застосування змін ваші налаштування працюють як треба. Ви також можете скинути налаштування, що вимикають правила безпеки, до значень за замовчуванням.',
    'web-app-firewall.nginxResetCustomizations' => 'Скинути серверні та доменні налаштування, які вимикають правила безпеки, до значень за замовчуванням.',
    'web-app-firewall.ruleSetUpdate' => 'Оновити набори правил',
    'web-app-firewall.ruleSetUpdateDaily' => 'Щодня',
    'web-app-firewall.ruleSetUpdateWeekly' => 'Щотижня',
    'web-app-firewall.ruleSetUpdateMonthly' => 'Щомісяця',
    'web-app-firewall.currentRuleSet' => 'Набір правил',
    'web-app-firewall.currentRuleSetValue' => '%%ruleSet%% %%changeRuleSetLink%%',
    'web-app-firewall.currentRuleSetRunningOn' => '%%ruleSet%% запущено на %%webServer%%',
    'web-app-firewall.changeRuleSetLink' => 'Змінити набір правил',
    'web-app-firewall.ruleSetRollbackFailed' => 'Неможливо застосувати поточний набір правил ModSecurity та повернутись до попередньої версії, тому що вони містять некоректні правила.',
    'web-app-firewall.configurationSection' => 'Конфігурація',
    'web-app-firewall.configurationSectionHint' => 'Налаштуйте брандмауер мережевих застосунків, використовуючи передвизначений набір параметрів або ваші особисті директиви ModSecurity.',
    'web-app-firewall.configPreset' => 'Заздалегідь визначений набір значень',
    'web-app-firewall.configPresetFast' => 'Швидко',
    'web-app-firewall.configPresetFastDescription' => 'Будуть проаналізовані URI HTTP-запиту і частини заголовків.',
    'web-app-firewall.configPresetTradeOff' => 'Компроміс',
    'web-app-firewall.configPresetTradeOffDescription' => 'Будуть проаналізовані заголовки, URI і POST-дані HTTP-запиту.',
    'web-app-firewall.configPresetThrough' => 'Ретельно',
    'web-app-firewall.configPresetThroughDescription' => 'Будуть проаналізовані повні заголовки HTTP-запитів, POST-дані запиту і вміст тіла HTTP-відповіді.',
    'web-app-firewall.configCustom' => 'Користувацькі директиви',
    'web-app-firewall.configCustomDescription' => "Введіть директиву ModSecurity тут. Це скасує раніше зазначені директиви (набори правил, конкретні правила, заздалегідь визначений набір значень і так далі). Наприклад: SecDebugLogLevel 6",
    'web-app-firewall.configCustomError' => 'Некоректна конфігурація ModSecurity: %%error%%',
    'web-app-firewall.configRollbackFailed' => 'Неможливо використати поточний файл конфігурації ModSecurity і повернутися до попередньої версії файлу, оскільки вони містять неприпустиму конфігурацію.',
    'web-app-firewall.rulesSection' => 'Вимкнути правила безпеки',
    'web-app-firewall.rulesSectionHint' => 'Тут ви можете вимкнути правила безпеки. Це зручно якщо ви помітите, що певне правило безпеки занадто обмежує певні вебсайти. Для деактивації правил безпеки зазначте їхні ІД (наприклад, 340003 або 340005-340007), мітки (наприклад, CVE-2011-4898), або регулярні вирази, що використовуються у повідомленнях правил (наприклад, XSS).',
    'web-app-firewall.rulesSectionNginxHint' => 'Тут ви можете вимкнути правила безпеки. Це зручно якщо ви помітите, що певне правило безпеки занадто обмежує певні вебсайти. Для деактивації правил безпеки зазначте їхні ІД (наприклад, 340003 або 340005-340007), мітки (наприклад, CVE-2011-4898), або повідомлення правил (наприклад, Знайдений користувач-агент, пов\'язаний зі сканером безпеки).',
    'web-app-firewall.filterById' => 'Ідентифікатори правила безпеки',
    'web-app-firewall.filterByIdInvalid' => 'Наступні значення недійсні: %%values%%. ІД правила має складатися з цифр або діапазону цифр. Наприклад, 913100, 913105-913107.',
    'web-app-firewall.filterByIdInvalidRanges' => 'Наступні діапазони є недійсними: %%ranges%%.',
    'web-app-firewall.filterByTag' => 'Теги',
    'web-app-firewall.filterByTagActive' => 'Активний:',
    'web-app-firewall.filterByTagDeactivated' => 'Деактивований:',
    'web-app-firewall.filterByTagInvalid' => 'Наступні обрані значення недійсні: %%values%%.',
    'web-app-firewall.filterByRegexp' => 'Регулярні вирази у повідомленнях правил',
    'web-app-firewall.filterByRegexpInvalid' => 'Наступні значення є недійсними: %%values%%. Вони не мають містити жодних символів \', "',
    'web-app-firewall.filterByRegexpNginx' => 'Повідомлення правил',
    'web-app-firewall.filterByRegexpNginxHint' => 'Підтримуються тільки повні співпадіння.',
    'web-app-firewall.filterByRegexpNginxInvalid' => 'Наступні значення є недійсними: %%values%%. Повідомлення правила має складатися з літер, цифр, пробілів, або символів -:;.,!?#&$%*()/.',
    'web-app-firewall.auditLogSection' => 'Журнал аудиту ModSecurity',
    'web-app-firewall.auditLogHint1' => 'Журнал аудиту модуля ModSecurity містить найбільш корисну інформацію системи. Під час виявлення модулем ModSecurity будь-якої події, створюється запис у журналі аудиту.',
    'web-app-firewall.auditLogHint2' => 'Веб-сайт може перестати належно функціонувати після зміни режиму мережевого екрану веб-застосунків на ВМК з ВИМК або Тільки виявлення. У цьому випадку, проаналізуйте журнал аудиту ModSecurity для з’ясування обставин. Ви можете вимкнути занадто суворі правила безпеки або налаштувати веб-сайт.',
    'web-app-firewall.auditLogHint3' => 'Щоб з’ясувати, чому запит HTTP неможливо завершити для веб-сайту:',
    'web-app-firewall.auditLogPoint1' => 'Натисніть на нижченаведене посилання журналу ModSecurity та відкрити журнал аудиту в новому вікні оглядача.',
    'web-app-firewall.auditLogPoint2' => 'Використовуйте Пошук (Ctrl + F у більшості веб-оглядачів) для того, щоб знайти події для проблемного веб-сайту (ім\'я домену). Наприклад, your_domain.tld. Оглядач виділить такі записи, як HOST: your_domain.tld.',
    'web-app-firewall.auditLogPoint3' => 'На три рядки вище виділеного запису знайдіть рядок типу --eece5138-B--. Вісім символів між знаками дефісу (у нашому прикладі це eece5138) є ідентифікатором події, викликаної запитом HTTP.',
    'web-app-firewall.auditLogPoint4' => 'Шукайте далі інші записи з аналогічним ID події. Шукайте запис із літерою H після ID події (у нашому прикладі: eece5138-H--). Цей запис містить ID й опис правила безпеки, яке активується під час перевірки запиту HTTP. ID правила безпеки — ціле число в лапках із префіксом id у квадратних дужках (наприклад, [id "340003"]).',
    'web-app-firewall.auditLogPoint5' => 'Знайдіть ID правила безпеки в події за допомогою підрядка (наприклад, [id "3).',
    'web-app-firewall.auditLogPoint6' => 'Вимкніть правило безпеки з цим ідентифікатором у нижченаведеному розділі Правила безпеки: введіть ідентифікатор правила безпеки (тільки цифри) в поле ідентифікатора правила безпеки та натисніть кнопку ОК.',
    'web-app-firewall.auditLogViewLink' => 'Журнал ModSecurity',
    'web-app-firewall.auditLogListLink' => 'Архів журналів',
    'web-app-firewall.errorLogSection' => 'Журнал помилок',
    'web-app-firewall.errorLogSectionHint' => 'Веб-сайт може перестати належно функціонувати після зміни режиму мережевого екрану веб-застосунків на ВМК з ВИМК або Тільки виявлення. У цьому випадку, проаналізуйте журнал помилок для з’ясування обставин. Ви можете вимкнути занадто суворі правила безпеки або налаштувати веб-сайт.',
    'web-app-firewall.errorLogViewLink' => 'Журнал помилок',
    'web-app-firewall.notificationStateEnabled' => 'Сповіщення КІ Plesk про оновлення наборів правил увімкнені. %%notificationLink%%',
    'web-app-firewall.notificationStateDisabled' => 'Сповіщення КІ Plesk про оновлення наборів правил вимкнені. %%notificationLink%%',
    'web-app-firewall.notificationLink' => 'Управляйте ними на сторінці сповіщень',
    'web-app-firewall.tradeoffAndThoroughModeWarning' => 'Вибір параметрів Tradeoff або Thorough може призвести до несправності сайтів WordPress серед інших небажаних побічних ефектів через <a href="https://github.com/SpiderLabs/ModSecurity/issues/562" target="_blank">проблему з ModSecurity</a>.',
    'web-app-firewall.fileNotUploaded' => 'Неможливо завантажити файл.',

    'web-server-settings.selectUnitSize' => 'Виберіть розмір одиниці',
    'web-server-settings.inputSize' => 'Введіть розмір',

    'ProtectedDirectory.pathLabel' => 'Назва каталогу',
    'ProtectedDirectory.realmLabel' => 'Заголовок захищеної зони',
    'ProtectedDirectory.locationLabel' => 'Розташування каталогу',
    'ProtectedDirectory.isNonSslLabel' => 'non-SSL/TLS',
    'ProtectedDirectory.isCgiBinLabel' => 'cgi-bin',

    'SummaryReport.Layout.name' => 'Ім’я звіту',
    'SummaryReport.Layout.isDefault' => 'Використовувати як звіт за замовчуванням',
    'SummaryReport.Layout.sections' => 'Розділи',
    'SummaryReport.Layout.general' => 'Загальні дані',
    'SummaryReport.Layout.resellers' => 'Посередники',
    'SummaryReport.Layout.clients' => 'Замовники',
    'SummaryReport.Layout.personalClients' => 'Власні замовники',
    'SummaryReport.Layout.domains' => 'Домени',
    'SummaryReport.Layout.personalDomains' => 'Персональні домени',
    'SummaryReport.Layout.type.full' => 'Повний',
    'SummaryReport.Layout.type.summary' => 'Сумарний',

    'SummaryReport.Schedule.enable' => 'Увімкнути',
    'SummaryReport.Schedule.period' => 'Частота доставки',
    'SummaryReport.Schedule.daily' => 'Щодня',
    'SummaryReport.Schedule.weekly' => 'Щотижня',
    'SummaryReport.Schedule.monthly' => 'Щомісяця',
    'SummaryReport.Schedule.email' => 'Доставити',
    'SummaryReport.Schedule.isEmpty' => 'Введіть дійсну адресу електронної пошти.',

    'MassMailForm.name' => 'Ім\'я шаблону',
    'MassMailForm.fromEmail' => 'З (електронної адреси)',
    'MassMailForm.sendToAdmins' => 'Надіслати адміністратору Plesk',
    'MassMailForm.sendToResellers' => 'Надіслати посередникам',
    'MassMailForm.sendToClients' => 'Надіслати клієнтам',
    'MassMailForm.subject' => 'Тема',
    'MassMailForm.body' => 'Текст повідомлення',
    'MassMailForm.bodyDescription' => '
Ви можете використати перемінну <name> в тексті повідомлення (але не в заголовку). Вона буде замінена на контактне ім\'я замовника чи посередника.',
    'MassMailForm.sendToResellersMode' => 'Надіслати',
    'MassMailForm.sendToResellersModeAll' => 'Всі посередники',
    'MassMailForm.sendToResellersModeSelect' => 'Вибрані посередники',
    'MassMailForm.sendToResellersModeExcept' => 'Всім, крім вибраних посередників',
    'MassMailForm.sendToClientsMode' => 'Надіслати',
    'MassMailForm.sendToClientsModeAll' => 'Всі замовники',
    'MassMailForm.sendToClientsModeSelect' => 'Вибрані замовники',
    'MassMailForm.sendToClientsModeExcept' => 'Всім, крім вибраних клієнтів',

    'VirtualDirectory.DirectorySection.title' => 'Віртуальний каталог',
    'VirtualDirectory.DirectorySection.name' => 'Ім’я',
    'VirtualDirectory.DirectorySection.accessSource' => 'Доступ до джерела скрипту',
    'VirtualDirectory.DirectorySection.accessRead' => 'Дозвіл на читання',
    'VirtualDirectory.DirectorySection.accessWrite' => 'Написати дозвіл',
    'VirtualDirectory.DirectorySection.enableDirBrowsing' => 'Перегляд каталогу',
    'VirtualDirectory.DirectorySection.log' => 'Реєструвати відвідування',
    'VirtualDirectory.Path.path' => 'Шлях',
    'VirtualDirectory.Path.autoPathLabel' => 'Створіть фізичний каталог із тим самим ім\'ям, що й віртуальний',
    'VirtualDirectory.ApplicationSettingsSection.title' => 'Налаштування застосунку',
    'VirtualDirectory.ApplicationSettingsSection.appCreate' => 'Створіть застосунок',
    'VirtualDirectory.ApplicationSettingsSection.aspEnableParentPaths' => 'Дозволити використання батьківських шляхів',
    'VirtualDirectory.ApplicationSettingsSection.aspExecuteInMTA' => 'Дозволити виконання застосунку в режимі MTA (багатопотоковий підрозділ)',
    'VirtualDirectory.ScriptExecuteField.scriptExecute' => 'Виконати права доступу',
    'VirtualDirectory.SecuritySection.title' => 'Безпека каталогу',
    'VirtualDirectory.SecuritySection.authAnonymous' => 'Вмикає анонімну перевірку автентичності',
    'VirtualDirectory.SecuritySection.authNTLM' => 'Вмикає перевірку автентичності Windows',
    'VirtualDirectory.SecuritySection.requireSSL' => 'Потребує SSL/TLS',
    'VirtualDirectory.scriptExecuteOption.none' => 'Відсутня',
    'VirtualDirectory.scriptExecuteOption.script' => 'Тільки скрипти',
    'VirtualDirectory.scriptExecuteOption.scriptExecute' => 'Скрипти та виконувані програми',
    'VirtualDirectory.AspSection.title' => 'Налаштування ASP',
    'VirtualDirectory.AspSection.aspBufferingLimit' => 'Максимальний розмір буферу ASP (KB)',
    'VirtualDirectory.AspSection.aspMaxRequestEntityAllowed' => 'Максимальний розмір об’єкту запиту ASP (KB)',
    'VirtualDirectory.AspSection.aspEnableServerDebug' => 'Ввімкнути загально-серверний ASP скрипт налагодження',
    'VirtualDirectory.AspSection.aspEnableClientDebug' => 'Ввімкнути налагодження клієнтського скрипту ASP',
    'VirtualDirectory.AspSection.definedByIis' => 'Визначено IIS',
    'VirtualDirectory.AspSection.definedByIisWithSize' => 'Визначено IIS (%%size%% KB)',
    'VirtualDirectory.AspSection.definedByParent' => 'Визначено батьківським каталогом',
    'VirtualDirectory.AspSection.definedByParentWithSize' => 'Визначено батьківським каталогом (%%size%% KB)',
    'VirtualDirectory.AspSection.kbytes' => 'Кбайт',
    'VirtualDirectory.CheckboxField.true' => 'Так',
    'VirtualDirectory.CheckboxField.false' => 'Ні',
    'VirtualDirectory.DocumentsSection.title' => 'Документи',
    'VirtualDirectory.DocumentsSection.enableDefaultDoc' => 'Використати документи за замовчуванням',
    'VirtualDirectory.DefaultDocsField.defaultDocs' => 'Порядок пошуку документів за замовчуванням',
    'VirtualDirectory.DefaultDocsField.remove' => 'Видалити',
    'VirtualDirectory.NewDefaultDoc.add' => 'Додати',
    'VirtualDirectory.NewDefaultDoc.addTooltip' => 'Натисніть, щоб додати файл до переліку.',
    'VirtualDirectory.NewDefaultDoc.requiredWarning' => 'Введіть назву файлу, який потрібно додати до списку.',
    'VirtualDirectory.PhysicalDirectoryConflictDialog.description' => 'Фізичний каталог із таким ім\'ям вже існує. Якщо продовжити, каталог стане недоступним. Продовжити?',
    'VirtualDirectory.PhysicalDirectoryConflictDialog.proceed' => 'Продовжити',

    'VirtualDirectoryMimeType.extension' => 'Модуль',
    'VirtualDirectoryMimeType.content' => 'Вміст',
    'VirtualDirectoryMimeType.custom' => 'Вибірково',
];
