<?php
// Copyright 1999-2025. WebPros International GmbH. All rights reserved.
$messages = [
    'additional-keys.keyNumber' => 'Nøkkelnummer',
    'additional-keys.keyName' => 'Nøkkelnavn',
    'additional-keys.keyApp' => 'Program',
    'additional-keys.addGroup' => 'Legg til',
    'additional-keys.upload' => 'Installer ny nøkkel',
    'additional-keys.uploadDescription' => 'Last opp og installer en ny lisens.',
    'additional-keys.actionsGroup' => 'Handlinger',
    'additional-keys.install' => 'Installer',
    'additional-keys.installAll' => 'Installer alle',
    'additional-keys.installDescription' => 'Installer valgte lisensnøkler.',
    'additional-keys.installNoSelection' => 'Velg én eller flere lisensnøkler å installere, eller klikk på «Installer alle».',
    'additional-keys.installSuccess' => 'Installasjon av lisensnøkkel er startet.',
    'additional-keys.removeGroup' => 'Fjern',
    'additional-keys.remove' => 'Fjern',
    'additional-keys.removeDescription' => 'Fjern de valgte lisensnøklene.',
    'additional-keys.removeNoSelection' => 'Velg én eller flere lisensnøkler å fjerne.',
    'additional-keys.removeConfirmation' => 'Fjern {count, plural, =1 {lisensnøkkelen {name}} one { # valgt lisensnøkkel} other {# valgte lisensnøkler}}?',
    'additional-keys.removeSuccess' => 'De valgte lisensnøklene ble fjernet.',
    'additional-keys.download' => 'Nedlastingsnøkkel',
    'additional-keys.downloadDescription' => 'Last ned lisensnøkkel.',
    'additional-keys.emptyViewTitle' => 'Ingen flere lisensnøkler',

    'backup.tasks.startDate' => 'Startet',
    'backup.tasks.targetRepo' => 'Mållager',
    'backup.tasks.progress' => 'Oppgavefremdrift',
    'backup.tasks.repoTypeLocal' => 'Server',
    'backup.tasks.repoTypeFtp' => 'Personlig FTP',
    'backup.tasks.buttonRemoveTask' => 'Fjern',
    'backup.tasks.hintRemoveTask' => 'Fjern valgte sikkerhetskopieringsoppgaver.',
    'backup.tasks.buttonReload' => 'Last inn på nytt',
    'backup.tasks.hintReload' => 'Last inn oppgaveliste på nytt for å få aktiv status.',
    'backup.tasks.statusTaskWarnings' => 'Advarsler',
    'backup.tasks.statusTaskInfo' => 'Informasjon',
    'backup.tasks.statusTaskFailed' => 'Mislykket',

    'backup.disabledSelectHint' => 'Sikkerhetskopien kan ikke flyttes fordi den er en del av en server-, forhandler- eller en kunde-sikkerhetskopi.',
    'backup.buttonBackup' => 'Sikkerhetskopier',
    'backup.hintBackup' => 'Opprett en sikkerhetskopi.',
    'backup.buttonSchedule' => 'Tidsplan',
    'backup.hintSchedule' => 'Angi innstillinger for planlagt sikkerhetskopiering.',
    'backup.buttonReload' => 'Last inn på nytt',
    'backup.hintReload' => 'Last inn sikkerhetskopilisten på nytt.',
    'backup.buttonUpload' => 'Last opp',
    'backup.hintUpload' => 'Last opp en sikkerhetskopi fra datamaskinen din til serverens sikkerhetskopilager.',
    'backup.buttonSettings' => 'Innstillinger',
    'backup.hintSettings' => 'Konfigurere globale innstillinger for sikkerhetskopiering av data for å redusere belastningen av serverens CPU.',
    'backup.buttonRemoteStorages' => 'Innstillinger for ekstern lagring',
    'backup.hintRemoteStorages' => 'Konfigurer ditt eksterne lager for lagring av sikkerhetskopier.',
    'backup.buttonRemove' => 'Fjern',
    'backup.hintRemove' => 'Fjern valgte sikkerhetskopier fra serverlageret.',
    'backup.systemNotes' => 'Systemmerknader',
    'backup.incremental' => 'Trinnvis.',
    'backup.multiVolume' => 'Flere volumer.',
    'backup.remoteStorage' => 'I lagret: %%storage%%',
    'backup.status' => 'S',
    'backup.statusOff' => 'Dette er ikke en gyldig sikkerhetskopi. Kan ikke gjenopprette data fra denne filen. Klikk på sikkerhetskopi navnet for å få detaljer.',
    'backup.statusWarning' => 'Sikkerhetskopien er ikke helt gyldig. Klikk på sikkerhetskopi navnet for å få detaljer.',
    'backup.statusInfo' => 'Dette er en gyldig sikkerhetskopi. Data kan gjenopprettes fra denne sikkerhetskopien, men enkelte mindre problemer kan oppstå med måten data lagres på.',
    'backup.statusOn' => 'Dette er en gyldig sikkerhetskopi. Data kan gjenopprettes fra denne sikkerhetskopien.',
    'backup.date' => 'Opprettelsesdato',
    'backup.name' => 'Navn',
    'backup.comment' => 'Kommentarer',
    'backup.size' => 'Størrelse',
    'backup.download' => 'Last ned sikkerhetskopi til din lokale datamaskin.',
    'backup.downloadDisabled' => 'Nedlasting av sikkerhetskopi er midlertidig utilgjengelig. Vennligst prøv igjen eller ta kontakt med tjenestetilbyder.',
    'backup.total' => 'Sum sikkerhetskopier: %%total%%, størrelse: %%totalSize%%',
    'backup.totalFound' => '%%found%% sikkerhetskopier funnet (%%total%% total), størrelse: %%totalSize%%',
    'backup.confirmOnDelete' => 'Ønsker du å fjerne de valgte sikkerhetskopier?',
    'backup.incrementsRemovalLoading' => 'Laster inn...',
    'backup.incrementsRemovalConfirmation' => 'Jeg bekrefter at jeg ønsker å fjerne de valgte sikkerhetskopiene.',
    'backup.backupHasIncrements' => 'Sikkerhetskopien %%backupName%% vil fjernes sammen med dens inkrementer: %%backupIncrements%%',
    'backup.ftpStorage' => 'FTP',
    'backup.ftpStorageErrorCredentials' => 'Feil brukernavn eller passord for FTP-lager',
    'backup.ftpStorageErrorResolveHost' => "Kan ikke løse vertsnavnet.",
    'backup.ftpStorageErrorConnection' => "Kan ikke koble til ekstern server",
    'backup.unableToGetFtpDumpList' => 'Kunne ikke vise frem listen over sikkerhetskopier i FTP-lageret %%errorMessage%%. Vennligst sjekk <a href="%%ftpSettingsUrl%%">FTP lagringsinnstillingene</a>.',
    'backup.unableToGetExtDumpList' => 'Kunne ikke vise frem listen av sikkerhetskopier i %%storageTitle%% lagret: %%errorMessage%%. Vennligst sjekk innstillingene for lagring.',
    'backup.unableToGetLocalDumpList' => 'Kunne ikke vise frem listen over sikkerhetskopier som lagres på serveren: %%errorMessage%%.',
    'backup.skippedFilesAtExtStorage' => 'Enkelte av filene i lagret %%storageTitle%% vises ikke i listen fordi deres filnavn ikke følger reglene for navngivning av sikkerhetskopier. Om du er sikker på at disse filene er gyldige sikkerhetskopier, gi dem navn som passer med det følgende mønsteret: "backup_%%objectName%%&lt;YYMMDDHHmm&gt;.%%ext%%"',
    'backup.multiVolumeShow' => 'Vis volumer',
    'backup.multiVolumeHide' => 'Skjul volumer',
    'backup.backEncryptionRequired' => 'Av sikkerhetsårsaker, anbefaler vi at du beskytter sensitive data som inkluderes i sikkerhetskopier. Vennligst gå til %%link%% og oppdater sikkerhetsinnstillinger for sikkerhetskopier.',
    'backup.backupSettingPage' => 'Innstillinger for sikkerhetskopiering',
    'backup.statusTaskProgress' => 'Sikkerhetskopiering pågår.',
    'backup.statusTaskWarnings' => 'Sikkerhetskopiering ble fullført med advarsler.',
    'backup.statusTaskInfo' => 'Informasjon.',
    'backup.statusTaskFailed' => 'Sikkerhetskopiering mislyktes.',
    'backup.statusTaskStopping' => 'Sikkerhetskopieringsoppgaven stopper.',
    'backup.statusTaskStopped' => 'Sikkerhetskopieringsoppgaven ble stoppet.',

    'backup.schedule.columnSchedule' => 'Tidsplan',
    'backup.schedule.columnContent' => 'Innhold',
    'backup.schedule.columnStorage' => 'Lager',
    'backup.schedule.periodHourly' => 'Per time',
    'backup.schedule.periodHourlySchedule' => 'hver {period, plural, one {# time} other {# time}}',
    'backup.schedule.periodDaily' => 'Daglig',
    'backup.schedule.periodDailySchedule' => 'kl. %%hours%%:%%minutes%%',
    'backup.schedule.periodWeekly' => 'Ukentlig',
    'backup.schedule.periodWeeklySchedule' => 'den %%day%% kl. %%hours%%:%%minutes%%',
    'backup.schedule.periodMonthly' => 'Månedlig',
    'backup.schedule.periodMonthlySchedule' => 'den %%day%% day kl. %%hours%%:%%minutes%%',
    'backup.schedule.periodCustom' => 'Egendefinert',
    'backup.schedule.dayFirst' => 'først',
    'backup.schedule.dayLast' => 'siste',
    'backup.schedule.day' => '{day, selectordinal, other {#.}}',
    'backup.schedule.storageLocal' => 'Serverlager',
    'backup.schedule.storageBoth' => 'Både serverlagring og %%remoteStorage%%',
    'backup.schedule.deactivateSuccess' => 'Planlagt sikkerhetskopiering ble deaktivert',

    'custombuttons.buttonAdd' => 'Legg til kobling til tjenesten',
    'custombuttons.buttonAddDescription' => 'Legg inn en kobling til en nettbasert tjeneste og plasser den i Plesk.',
    'custombuttons.buttonRemove' => 'Fjern',
    'custombuttons.buttonRemoveDescription' => 'Slett de valgte koblinger.',
    'custombuttons.removeConfirmMessage' => 'Fjerne de valgte koblingene?',
    'custombuttons.headerPublic' => 'A',
    'custombuttons.headerLocation' => 'L',
    'custombuttons.headerImage' => 'Bilde',
    'custombuttons.headerPriority' => 'Prioritet',
    'custombuttons.headerLabel' => 'Etikett',
    'custombuttons.headerUrl' => 'URL',
    'custombuttons.headerDescription' => 'Beskrivelse',
    'custombuttons.publicEnabledDescription' => 'Koblingen er synlig for brukere.',
    'custombuttons.publicDisabledDescription' => 'Koblingen er ikke synlig for brukere.',
    'custombuttons.altPublicEnabledIcon' => 'Offentlig',
    'custombuttons.altPublicDisabledIcon' => 'Privat',
    'custombuttons.placeNavigationDescription' => 'Koblingen finnes på alle sidene.',
    'custombuttons.placeAdminDescription' => 'Koblingen er plassert på administratorens hjemmeside.',
    'custombuttons.placeAdminSettingsDescription' => 'Koblingen er plassert på administratorens Verktøy&Innstillinger-side.',
    'custombuttons.placeResellerDescription' => 'Koblingen finner du på forhandlerens startside',
    'custombuttons.placeResellerSettingsDescription' => 'Koblingen finner du på forhandlerens Nettsteder og domener-side.',
    'custombuttons.placeClientDescription' => 'Koblingen finner du på kundens startside.',
    'custombuttons.placeDomainDescription' => 'Koblingen finner du på siden Nettsteder og domener for abonnementet.',
    'custombuttons.placeDomainPropertiesDescription' => 'Koblingen finner du på området Nettstedsverktøy, som åpnes på siden Nettsteder og domener, ved å klikke på Vis mer under et domenenavn.',

    'databaseservers.addGroup' => 'Legg til',
    'databaseservers.addDatabaseServer' => 'Legg til databaseserver',
    'databaseservers.addDatabaseServerDescription' => 'Legg til en databaseserver.',
    'databaseservers.addDatabaseServerDescriptionDisabledByKey' => 'Eksterne vertstjenester for databasen støttes ikke av lisensnøkkelen.',
    'databaseservers.actionsGroup' => 'Handlinger',
    'databaseservers.hostingSettings' => 'Innstillinger',
    'databaseservers.hostingSettingsDescription' => 'Innstillinger for databasehosting.',
    'databaseservers.refresh' => 'Oppdater',
    'databaseservers.refreshDescription' => 'Oppdater informasjon om databaseserverne.',
    'databaseservers.removeGroup' => 'Fjern',
    'databaseservers.remove' => 'Fjern',
    'databaseservers.removeDescription' => 'Slett valgte databaseservere.',
    'databaseservers.lastError' => 'S',
    'databaseservers.type' => 'Servertype',
    'databaseservers.host' => 'Vertsnavn',
    'databaseservers.hostLink' => 'Vis eller modifiser egenskaper for databaseservere.',
    'databaseservers.port' => 'Port',
    'databaseservers.version' => 'Versjon',
    'databaseservers.databasesCount' => 'Databaser',
    'databaseservers.databasesCountLink' => 'Behandle databaser hostet på denne serveren.',
    'databaseservers.databaseUpgradeLink' => 'Oppgrader databaseserveren hostet på denne serveren.',
    'databaseservers.databasesLTSVersion' => 'Du har allerede LTS-versjonen. Plesk oppgraderer automatisk din MySQL-/MariaDB-installasjon til nyere punktversjoner.',
    'databaseservers.webadmin' => 'Webadmin',
    'databaseservers.webadminHint' => 'Få tilgang til denne serveren via DB Webadmin.',
    'databaseservers.downloadMsSqlClient' => 'Last ned en lokal SQL-klient',
    'databaseservers.downloadMsSqlClientHint' => 'Last ned en lokal SQL-klient',
    'databaseservers.changePassword' => 'Endre administratorpassord',
    'databaseservers.changePasswordHint' => 'Endre administratorpassord for databaseserveren.',
    'databaseservers.mysql' => 'MySQL',
    'databaseservers.mssql' => 'Microsoft SQL Server',
    'databaseservers.postgresql' => 'PostgreSQL',
    'databaseservers.mariadb' => 'MariaDB',
    'databaseservers.percona' => 'Percona',
    'databaseservers.default_for_mysql' => 'standard for MySQL',
    'databaseservers.default_for_mssql' => 'standard for MS SQL',
    'databaseservers.default_for_postgresql' => 'standard for PostgreSQL',
    'databaseservers.default_for_mariadb' => 'standard for MariaDB',
    'databaseservers.default_for_percona' => 'standard for Percona',
    'databaseservers.status_no_error' => 'Siste forsøk på å koble til denne serveren var vellykket.',
    'databaseservers.status_connection_failed' => 'Siste forsøk på å koble til denne serveren mislyktes på grunn av nettverksproblemer..',
    'databaseservers.status_permission_denied' => 'Under det siste forsøket på å koble til denne serveren, ble tilgang avslått. Kontroller administrator påloggingsinformasjon for serveren.',
    'databaseservers.status_other_error' => 'Under det siste forsøket på å koble til denne serveren, oppsto det en feil.',
    'databaseservers.status_credentials_not_set' => 'Du må oppgi gyldig brukernavn og passord for administrator før Plesk kan koble til denne serveren.',
    'databaseservers.mssqlServerPortUndefined' => 'Kan ikke finne TCP-portnummeret som brukes av Microsoft SQL-server %%host%%: TCP/IP-protokoll er ikke aktivert i konfigurasjonen for servernettverket, eller serveren er konfigurert til å bruke dynamiske TCP-porter.',
    'databaseservers.mssqlServerPortUndefinedHint' => 'For å la kundene konfigurere brannmuren automatisk for ekstern tilgang til databasen, må du konfigurere SQL-serveren manuelt for å lytte til en bestemt fast TCP-port.',
    'databaseservers.removeEmptySelection' => 'Ingen databaseserver valgt.',
    'databaseservers.removeConfirmation' => 'Er du sikker på at du vil fjerne {count, plural, =1 {databaseserveren {name}} one {den # valgte databaseserveren} other {de # valgte databaseserverne}}?',
    'databaseservers.removeSuccess' => 'De valgte databaseserverne er fjernet.',
    'databaseservers.upgradeNow' => 'Oppgrader nå',


    'databaseserverdatabases.actionsGroup' => 'Handlinger',
    'databaseserverdatabases.assignToSubscription' => 'Flytt til abonnement',
    'databaseserverdatabases.assignToSubscriptionDescription' => 'Flytt de valgte databasene til et annet abonnement.',
    'databaseserverdatabases.removeGroup' => 'Fjern',
    'databaseserverdatabases.remove' => 'Fjern',
    'databaseserverdatabases.removeDescription' => 'Slett de valgte databaser.',
    'databaseserverdatabases.name' => 'Navn',
    'databaseserverdatabases.subscription' => 'Abonnement',
    'databaseserverdatabases.client' => 'Abonnent',
    'databaseserverdatabases.manageDatabase' => 'Administrer hosting',
    'databaseserverdatabases.manageDatabaseDescription' => 'Administrer databasen.',
    'databaseserverdatabases.manageDatabaseInResellerPanel' => 'Åpne i forhandlerpanel',
    'databaseserverdatabases.manageDatabaseInResellerPanelDescription' => 'Administrer databasen i abonnentens forhandlerpanel.',
    'databaseserverdatabases.manageDatabaseInCustomerPanel' => 'Åpne i Kundepanel',
    'databaseserverdatabases.manageDatabaseInCustomerPanelDescription' => 'Administrer databasen på abonnentens Kundepanel.',
    'databaseserverdatabases.emptySelection' => 'Ingen databaser valgt.',
    'databaseserverdatabases.removeConfirmation' => 'Er du sikker på at du vil fjerne {count, plural, =1 {databasen {name}} one {den # valgte databasen} other {de # valgte databasene}}?',
    'databaseserverdatabases.removeSuccess' => 'De valgte databaseserverne er fjernet.',

    'logbrowser.issuesFoundInTheLogs' => 'Problemer i nettstedsloggene',
    'logbrowser.learnAboutProblemsFaster' => 'Finn nettstedsproblemer kjappere',
    'logbrowser.noProblemsFound' => 'Ingen problemer i nettstedsloggene',
    'logbrowser.lastCheckDetectsProblems' => '%%checkType%% kontroll av loggene har oppdaget problemer som kan påvirke driften av nettstedet sitt. Se detaljer og mulige løsninger ved å klikke på «Åpne kontrollrapport».',
    'logbrowser.lastCheckDetectsNoProblems' => '%%checkType%% kontroll av loggen har ikke oppdaget noen problemer som kan påvirke driften av nettstedet ditt.',
    'logbrowser.noChecksResults' => 'En automatisk daglig kontroll er aktivert og kjører i løpet av de neste 24 timene.',
    'logbrowser.manual' => 'Manuell',
    'logbrowser.regular' => 'Automatisk daglig',
    'logbrowser.enableRegularCheck' => 'En daglig kontroll av loggene oppdager problemer som kan påvirke driften av nettstedet ditt. Hvis det dukker opp noen problemer, vil Plesk informere deg og stille med mulige løsninger.',
    'logbrowser.new' => 'NY',
    'logbrowser.openCheckReport' => 'Åpne kontrollrapport',
    'logbrowser.openCheckSettings' => 'Åpne kontrollinnstillinger',

    'logbrowser.buttonStartRealtime' => 'Start sanntidsoppdateringer',
    'logbrowser.buttonStartRealtimeHint' => 'Oppdater loggdata i sanntid.',
    'logbrowser.buttonStopRealtime' => 'Stopp sanntidsoppdateringer',
    'logbrowser.buttonStopRealtimeHint' => 'Stopp oppdatering a loggdata i sanntid.',
    'logbrowser.buttonRefresh' => 'Oppdater',
    'logbrowser.buttonRefreshHint' => 'Oppdater loggdata.',
    'logbrowser.buttonClear' => 'Klar',
    'logbrowser.buttonClearHint' => 'Skjul oppføringer som allerede er lastet inn.',
    'logbrowser.buttonAddCustom' => 'Legg til Log Browser som egendefinert fil',
    'logbrowser.buttonAddCustomHint' => 'Filen vil vises i Log Browser sammen med andre loggfiler.',
    'logbrowser.date' => 'Dato',
    'logbrowser.dateFilterPlaceholder' => 'Fra',
    'logbrowser.type' => 'Type',
    'logbrowser.ip' => 'IP',
    'logbrowser.ipFilterPlaceholder' => 'IP',
    'logbrowser.code' => 'Kode',
    'logbrowser.codeFilterPlaceholder' => 'Kode',
    'logbrowser.message' => 'Melding',
    'logbrowser.messageFilterPlaceholder' => 'Melding',
    'logbrowser.source' => 'Kilde',
    'logbrowser.sourceFilterFiles' => '%%count%% filer',
    'logbrowser.sourceFilterAllLogs' => 'Alle logger',
    'logbrowser.sourceFilterNoLogs' => 'Ingen logger',
    'logbrowser.manageLogFiles' => 'Administrer loggfiler',
    'logbrowser.addCustomLogFile' => 'Legg til egendefinert logg',
    'logbrowser.customLogPopupTitle' => 'Legg til egendefinert logg',
    'logbrowser.invalidLogFormat' => 'Loggfilen er på et format som ikke støttes',
    'logbrowser.referer' => 'R',
    'logbrowser.refererHint' => 'Referent',
    'logbrowser.agent' => 'Agent',
    'logbrowser.agentHint' => 'Brukeragent',
    'logbrowser.size' => 'Størrelse',
    'logbrowser.unknown' => 'Ukjent',
    'logbrowser.more' => 'Mer',
    'logbrowser.less' => 'Mindre',
    'logbrowser.any' => 'Hvilken som helst',
    'logbrowser.none' => 'Ingen',
    'logbrowser.loadMoreOrUseFilters' => '%%loadMore%% eller bruk filtrene til å redusere antall oppføringer.',
    'logbrowser.loadMore' => 'Last tidligere oppføringer',
    'logbrowser.clear' => 'Klar',
    'logbrowser.hourAgo' => 'Time siden',
    'logbrowser.prevDay' => 'Forrige dag',
    'logbrowser.linkInMessageToViewFile' => 'Klikk her for å vise filen.',
    'logbrowser.buttonUnlinkHint' => 'Klikk for å stoppe sporing av oppdateringer for denne filen i Log Browser',
    'logbrowser.buttonUnlinkConfirmationDescription' => 'Er du sikker på at du vil stoppe sporing av oppdateringer for denne filen i Log Browser?',
    'logbrowser.buttonUnlinkConfirmationYes' => 'Ja',
    'logbrowser.buttonUnlinkConfirmationNo' => 'Nei',
    'logbrowser.logRotation' => 'Logg rotasjon',
    'logbrowser.logRotationHint' => 'Sett opp logg-rotasjonsinnstillingene for nettstedet.',
    'logbrowser.logRotationTitle' => 'Konfigurere loggrotasjon',

    'notifications.title' => 'Sett opp sending av e-postvarsler veds systemhendelser',
    'notifications.legendNotifications' => 'Varslinger',
    'notifications.legendSettings' => 'Innstillinger',
    'notifications.headerEvent' => 'Hendelse',
    'notifications.headerSendTo' => 'Send melding til:',
    'notifications.headerText' => 'Tekst',
    'notifications.headerPreview' => 'Forhåndsvisning',
    'notifications.headerAdmin' => 'Administrator',
    'notifications.headerReseller' => 'Forhandler',
    'notifications.headerClient' => 'Kunde',
    'notifications.headerEmailAddress' => 'E-postadresse',
    'notifications.expirationTime' => 'Send advarsler om utløpsdato',
    'notifications.days' => 'dager på forhånd',
    'notifications.smtpSettings' => 'For å la Plesk sende varslinger når videresending er stengt, kan du %%link%%',
    'notifications.smtpSettingsLink' => 'endre SMTP-innstillinger',
    'notifications.editHint' => 'Rediger meldingstekst.',
    'notifications.previewHint' => 'Se hvordan varslet ser ut i e-poster.',
    'notifications.reseller_creation' => 'Opprettelse av forhandlerkonto',
    'notifications.reseller_limits_exceed' => 'Grense for ressursbruk overskredet av forhandlerkonto',
    'notifications.reseller_blocked' => 'Forhandlerkonto suspendert på grunn av overforbruk av ressurs',
    'notifications.reseller_overuse_block' => 'Forhandlerens grenser for ressursbruk nådd av forhandlerens abonnement på grunn av oversalg',
    'notifications.client_creation' => 'Opprettelse av kundekonto',
    'notifications.domain_creation' => 'Oppretting av område',
    'notifications.domain_exp_warning' => 'Utløpsvarsel for abonnement',
    'notifications.domain_expiration' => 'Utløp av abonnement',
    'notifications.domain_limits_exceed' => 'Grense for ressursbruk overskredet av abonnement',
    'notifications.domain_blocked' => 'Abonnement suspendert på grunn av overforbruk av ressurs',
    'notifications.admin_aps_app_updates' => 'Oppdateringer av APS-applikasjon (administratorsammendrag)',
    'notifications.reseller_aps_app_updates' => 'Oppdateringer av APS-applikasjon (forhandlersammendrag)',
    'notifications.client_aps_app_updates' => 'Oppdateringer av APS-applikasjon (kundesammendrag)',
    'notifications.admin_pum_updates' => 'Systemoppdateringer: meldinger om nye oppdateringer',
    'notifications.admin_outgoing_mail_exceeded_limits' => 'Utgående e-post har overskredet grensene',
    'notifications.subscription_cgroups_limits_exceed' => 'RAM, CPU, og Disk I/O (Cgroups)',
    'notifications.admin_postponed_feedback' => 'Påminnelse om tilbakemelding',
    'notifications.errorInvalidEmail' => 'Feil e-postadresse.',
    'notifications.errorInvalidExpTime' => 'Antallet dager er ugyldig.',
    'notifications.errorUpdate' => 'Kan ikke oppdatere melding: %%error%%',
    'notifications.updated' => 'Varslingsinnstillingene er oppdatert',

    'outgoingmail.name' => 'Navn',
    'outgoingmail.maxOutgoingMessages' => 'Grense pr time',
    'outgoingmail.numOfExceedingAttempts' => 'Forsøk etter å ha nådd grensen',
    'outgoingmail.lastAttemptAt' => 'Siste forsøk',
    'outgoingmail.mailStatus' => 'Status for e-post',
    'outgoingmail.mailStatusSending' => 'Sender',
    'outgoingmail.mailStatusNotSending' => 'Sendes ikke',
    'outgoingmail.mailStatusSendingDesc' => 'E-post sendes.',
    'outgoingmail.mailStatusNotSendingDesc' => 'E-post sendes ikke.',
    'outgoingmail.limitValueUnlimited' => 'Ubegrenset',

    'scheduler.tasks.headerCommand' => 'Kommando',
    'scheduler.tasks.headerSchedule' => 'Tidsplan',
    'scheduler.tasks.headerSubscription' => 'Abonnement',
    'scheduler.tasks.headerSubscription_powerUser' => 'Webplass',
    'scheduler.tasks.buttonToggleHintOn' => 'Oppgaven er aktivert. Klikk for å deaktivere oppgaven.',
    'scheduler.tasks.buttonToggleHintOff' => 'Oppgaven er deaktivert. Klikk for å aktivere oppgaven.',
    'scheduler.tasks.add' => 'Legg til oppgave',
    'scheduler.tasks.hintAdd' => 'Planlegg en ny oppgave.',
    'scheduler.tasks.remove' => 'Fjern',
    'scheduler.tasks.hintRemove' => 'Fjern de valgte oppgavene.',
    'scheduler.tasks.confirmOnDelete' => 'Ønsker du å fjerne de valgte oppgavene?',
    'scheduler.tasks.sync' => 'Oppdater',
    'scheduler.tasks.hintSync' => 'Last inn oppgavelisten på nytt for å hente faktiske data.',
    'scheduler.tasks.settings' => 'Innstillinger',
    'scheduler.tasks.hintSettings' => 'Rediger innstillinger for planlagte oppgaver.',
    'scheduler.tasks.deleteSuccess' => 'De planlagte oppgavene ble fjernet.',
    'scheduler.tasks.serverTask' => 'server (bruker:%%user%%)',
    'scheduler.tasks.unknownUser' => 'ukjent',
    'scheduler.tasks.runTaskNow' => 'Kjør nå',
    'scheduler.tasks.runTaskNowHint' => 'Kjør oppgaven nå.',
    'scheduler.tasks.runningTask' => 'Kjører oppgaven &quot;%%task%%&quot;...',

    'server-components.bcTitle' => 'Serverkomponenter',
    'server-components.title' => 'Plesk-komponenter',
    'server-components.name' => 'Komponentnavn',
    'server-components.version' => 'Komponentversjon',
    'server-components.refresh' => 'Oppdater',
    'server-components.componentName' => 'Angi komponent-navn …',
    'server-components.noComponents' => 'Ingen komponenter funnet',
    'server-components.componentsListUpdated' => 'Listen over komponenter ble oppdatert',

    'server-components.componentName.urlrewrite' => 'Skriv URL-adresse på nytt',
    'server-components.componentName.dbconnector' => "Databasetilkobling",
    'server-components.componentName.mysqlserver' => 'MariaDB/MySQL-server',
    'server-components.componentName.troubleshooting' => 'Feilsøking',
    'server-components.componentName.waf' => 'Brannmur for webprogram',
    'server-components.componentName.vcs' => 'System for versjonskontroll',
    'server-components.componentName.dotnetcore' => '.NET Core',
    'server-components.componentName.nodejs' => 'Node.js',
    'server-components.componentName.appinit' => "Oppstart av applikasjon",
    'server-components.componentName.cors' => "Ressursdeling på tvers av opprinnelse",
    'server-components.componentName.httpcompression' => 'Kompresjon av HTTP-innhold',
    'server-components.componentName.antivirus' => "Antivirus",
    'server-components.componentName.database' => "SQL-server",
    'server-components.componentName.sqladmin' => "MariaDB/MySQL Webadmin",
    'server-components.componentName.sqladminmysql' => "MariaDB/MySQL Webadmin",
    'server-components.componentName.dnsserver' => "DNS-server",
    'server-components.componentName.firewall' => "Brannmur",
    'server-components.componentName.ftpserver' => "FTP-server",
    'server-components.componentName.java' => "Java",
    'server-components.componentName.mailserver' => "eposttjener",
    'server-components.componentName.local_mailserver' => "Lokal e-posttjener",
    'server-components.componentName.psa' => "Plesk",
    'server-components.componentName.script' => "Webskripting",
    'server-components.componentName.spamfilter' => "Filter for søppelpost",
    'server-components.componentName.stats' => "Webstatistikk",
    'server-components.componentName.stunnel' => "SSL/TLS Wrapper",
    'server-components.componentName.webmail' => "Webmail",
    'server-components.componentName.webpublish' => "Webpublisering",
    'server-components.componentName.webserver' => "Webserver",
    'server-components.componentName.network' => 'Nettverk',
    'server-components.componentName.sitebuilder' => 'Presence Builder',
    'server-components.componentName.cphosting' => "Plesk Hosting",
    'server-components.componentName.savi' => 'Sophos antivirus-grensesnitt',

    'server-components.tooltip.disabled' => 'Slått av',
    'server-components.tooltip.active' => 'Aktiv',
    'server-components.tooltip.notConfigured' => 'Ikke konfigurert',
    'server-components.tooltip.notStarted' => 'Ikke startet, kontroller komponentinnstillinger',

    'server-components.defaultComponents.circularDependencies' => "Sirkelavhengighet ble funnet mellom kategoriene %%cat1%% og %%cat2%%",
    'server-components.defaultComponents.not_installed' => "(ikke installert)",
    'server-components.defaultComponents.not_configured' => "(ikke konfigurert)",
    'server-components.defaultComponents.not_opted_to_install_support_files' => "Noen tjenestekategorier inneholder ugyldige valg, eller ingen valg ble gjort.",
    'server-components.defaultComponents.depends_on' => "(krever %%name%%)",
    'server-components.defaultComponents.not_activated' => 'ikke aktivert',
    'server-components.defaultComponents.imap_required' => '(Gjeldende e-postserver ikke støtter IMAP)',
    'server-components.defaultComponents.ftp_ipv6_hosting_not_supported' => "(FTP-serveren støtter ikke Ipv6-adresser.)",
    'server-components.defaultComponents.delegation_rule_not_exist' => '(den påkrevede delegeringsregelen \'appPoolPipeline, appPoolNetFx\' eksisterer ikke)',
    'server-components.defaultComponents.not_supported_version' => '(ikke støttet versjon)',
    'server-components.defaultComponents.no_license' => '(ikke tillatt med denne lisensnøkkelen)',
    'server-components.defaultComponents.license_expired' => '(lisensnøkkelen er utløpt)',
    'server-components.defaultComponents.license_mailboxes_limit_exceeded' => '(innboksgrense for lisensnøkkel er overskredet)',
    'server-components.defaultComponents.title' => 'Velg standard %%name%%-komponent',
    'server-components.defaultComponents.none' => 'Ingen',
    'server-components.defaultComponents.yes' => 'Ja',
    'server-components.defaultComponents.no' => 'Nei',
    'server-components.defaultComponents.warning' => 'Advarsel!',
    'server-components.defaultComponents.parametersOfComponent' => 'Parametere for %%component%%',
    'server-components.defaultComponents.success' => 'Standardkomponent ble oppdatert',

    'server-components.defaultComponents.mailserverSwitchingWarning' => "Endring av e-postserver er beregnet kun for første konfigurering. Hvis serveren allerede er i bruk, forårsaker det følgende problemer: tap av innstillinger og innhold, og, i tilfeller hvor serveren du bytter til er allerede konfigurert, diverse konflikter.\nHvis denne serveren er i bruk nå og du er sikker på at du vil bytte til en annen, kan du varsle kundene dine om dette slik at de kan laste ned og lagre e-posten sin.",
    'server-components.defaultComponents.dnsserverBindToMsdnsSwitchingWarning' => "Kun de første 254 IP-adressene av delnett med /8- og /16-masker plassert i tilgangskontrolllisten vil bli overført. De blir overført som separate IP-adresser. Vil du fortsette?",

    'server-components.componentConf.title' => 'Parametere for %%compDesc%%',
    'server-components.componentConf.parameterIsRequired' => 'Parameter er påkrevd',
    'server-components.componentConf.parameterShouldBeNumber' => 'Parameter må være et siffer',
    'server-components.componentConf.success' => 'Parametrene ble oppdatert',

    'spam-filter.groupAdd' => 'Legg til',
    'spam-filter.buttonAdd' => 'Legge til domene',
    'spam-filter.buttonAddAddress' => 'Legg til adresse',
    'spam-filter.buttonAddToBlackListHint' => 'Legg til domene i sorteliste',
    'spam-filter.buttonAddToWhiteListHint' => 'Legg et domene til hvitelisten',
    'spam-filter.buttonAddAddressToBlackListHint' => 'Legg til adresse i sorteliste',
    'spam-filter.buttonAddAddressToWhiteListHint' => 'Legg til adresse i hviteliste',
    'spam-filter.groupActions' => 'Handlinger',
    'spam-filter.buttonRemove' => 'Fjern',
    'spam-filter.entries' => 'Innlegg',
    'spam-filter.removeEmptySelection' => 'Ingen oppføringer valgt.',
    'spam-filter.removeConfirmation' => 'Fjern {count, plural, =1 {oppføringen {name}} one {# valgt oppføring} other {# valgte oppføringer}}?',
    'spam-filter.removeSuccess' => 'De valgte oppføringene ble fjernet.',
    'spam-filter.addAddressToBlackListEmptyTitle' => 'Liste med kjente søppelpostadresser',
    'spam-filter.addAddressToWhiteListEmptyTitle' => 'Liste med pålitelige adresser',
    'spam-filter.addAddressToBlackListEmptyDescription' => 'E-post fra adressene på denne listen blir behandlet som søppelpost.',
    'spam-filter.addAddressToWhiteListEmptyDescription' => 'E-post fra adressene på denne listen hopper over søppelpostfiltret.',

    'tasks.pollingOff' => 'Av',
    'tasks.pollingDelay' => '%%delay%% s',
    'tasks.stopTaskConfirm' => 'Er du sikker på at du vil stanse oppgaven?',
    'tasks.stopTaskError' => 'Kunne ikke stanse oppgave',
    'tasks.stopTask' => 'Stans oppgave',
    'tasks.buttonStopConfirm' => 'Ja, stopp',
    'tasks.processedLoadFailed' => 'Kunne ikke laste inn prosessliste',
    'tasks.retryTask' => 'Prøv oppgaven igjen',
    'tasks.retryTaskFailed' => 'Kunne ikke prøve oppgaven igjen',
    'tasks.taskCreated' => 'Ny oppgave opprettet',
    'tasks.moreDetails' => 'Se panellogg for detaljer',
    'tasks.searchTitle' => 'Søk',
    'tasks.searchPlaceholder' => 'Søk streng',
    'tasks.refresh' => 'Oppdater',
    'tasks.refreshDescription' => 'Oppdater oppgaveliste',
    'tasks.createTask' => 'Opprett oppgave',
    'tasks.openSwagger' => 'Åpne Swagger',
    'tasks.statusTitle' => 'Status',
    'tasks.createdTitle' => 'Opprettet',
    'tasks.descriptionTitle' => 'Beskrivelse',
    'tasks.processes.dataLoadFailed' => 'Kunne ikke hente data fra serveren',
    'tasks.processes.commandLineLoadFailed' => 'Kunne ikke hente oppgavens kommandolinje',
    'tasks.processes.buttonStopConfirm' => 'Ja, stopp',
    'tasks.processes.stopProcess' => 'Stans prosess',
    'tasks.processes.stopProcessFailed' => 'Kunne ikke stanse prosess',
    'tasks.processes.stopProcessConfirm' => 'Er du sikker på at du vil stanse prosessen?',
    'tasks.processes.copyToClipboard' => 'Kopier til utklippstavlen',
    'tasks.processes.concurrency' => 'Samsvar',
    'tasks.processes.taskIdSection' => 'Oppgave-ID',
    'tasks.processes.requestorIdSection' => 'Anmoder-ID',
    'tasks.processes.timeoutSection' => 'Tidsavbrudd',
    'tasks.processes.createdSection' => 'Opprettet',
    'tasks.processes.updatedSection' => 'Oppdatert',
    'tasks.processes.environmentSection' => 'Miljø',
    'tasks.processes.idTitle' => 'ID',
    'tasks.processes.statusTitle' => 'Status',
    'tasks.processes.startedTitle' => 'Startet',
    'tasks.processes.completedTitle' => 'Fullført',
    'tasks.processes.pidTitle' => 'PID',
    'tasks.processes.exitCodeTitle' => 'Utgangskode',

    'ts-sessions.columnStateTitle' => 'Område',
    'ts-sessions.columnUserTitle' => 'Bruker',
    'ts-sessions.columnNameTitle' => 'Navn',
    'ts-sessions.refresh' => 'Oppdater',
    'ts-sessions.logoff' => 'Logg av',
    'ts-sessions.logoffConfirmation' => 'Logg av %%count%% økt(er)?',
    'ts-sessions.logoffConfirmationSingle' => 'Logg av økten %%name%%?',
    'ts-sessions.logoffConfirmationButton' => 'Ja, logg av',
    'ts-sessions.logoffNoSelection' => 'Velg én eller flere økter for å logge av',
    'ts-sessions.logoffSuccess' => 'De valgte øktene er logget ut.',
    'ts-sessions.disconnect' => 'Koble fra',
    'ts-sessions.disconnectConfirmation' => 'Koble fra %%count%% økt(er)?',
    'ts-sessions.disconnectConfirmationSingle' => 'Koble fra økten %%name%%?',
    'ts-sessions.disconnectConfirmationButton' => 'Ja, koble fra',
    'ts-sessions.disconnectSuccess' => 'De valgte øktene ble koblet fra.',
    'ts-sessions.disconnectNoSelection' => 'Velg én eller flere økter for å koble fra',
    'ts-sessions.disconnectNotAvailable' => 'Du kan kun koble fra aktive eller tilkoblede økter.',

    'client-ip-address.title' => 'IP-adresser',
    'client-ip-address.status' => 'Status',
    'client-ip-address.type' => 'Type',
    'client-ip-address.ipAddress' => 'IP-adresse',
    'client-ip-address.certificate' => 'Sertifikat',
    'client-ip-address.hosting' => 'Hosting',
    'client-ip-address.adminCertificateRepository' => "Administrators depot",
    'client-ip-address.domainCertificateRepository' => 'Arkiv for domene %%owner%%',
    'client-ip-address.typeShared' => 'Delt',
    'client-ip-address.typeExclusive' => 'Dedikert',
    'client-ip-address.removeConfirmation' => 'Fjern {count, plural, =1 {IP-adressene for {name}} one {de # valgte IP-adressene} other {de # valgte IP-adressene}} fra brukerens IP-pool?',
    'client-ip-address.noItemsToRemove' => 'Velg ett eller flere elementer for fjerning.',
    'client-ip-address.ftpOverSSL' => 'FTP over SSL/TLS',
    'client-ip-address.ftpOverSSL-yes' => 'Ja',
    'client-ip-address.ftpOverSSL-no' => 'Nei',
    'client-ip-address.ftpOverSSL-allow' => 'Tillat',
    'client-ip-address.ftpOverSSL-notAllowed' => 'Ikke tillatt',
    'client-ip-address.add' => 'Legg til IP adresse',
    'client-ip-address.noAvailableIps' => 'Det finnes ingen tilgjengelige IP adresser.',
    'client-ip-address.isOk' => 'IP adressen fungerer ordentlig.',
    'client-ip-address.isBroken' => 'IP adressen finnes ikke i grensesnittet.',
    'client-ip-address.properties.title' => 'IP adressen %%address%% på grensesnittet %%interface%%',
    'client-ip-address.properties.distributedType' => 'IP adresse distribuert som',
    'client-ip-address.properties.allocatedType' => 'IP adresse allokert som',
    'client-ip-address.properties.none' => 'Ingen',
    'client-ip-address.properties.certificate' => 'SSL/TLS-sertifikat',
    'client-ip-address.properties.defaultSite' => 'Standardnettsted',
    'client-ip-address.assign.title' => 'Velg IP-adresser',
    'client-ip-address.assign.description' => 'Ledige IP\'er',
    'client-ip-address.assign.success' => '{count, plural, =1 {IP-adressen for {name}} one {Den # valgte IP-adressen} other {De # valgte IP-adressene}} ble lagt til brukerens IP-pool',

    'ip-address-reseller-usage.title' => 'Forhandlere som bruker %%type%% IP-adresse %%ipAddress%%',
    'ip-address-reseller-usage.nameColumnHeader' => 'Videreforhandler',
    'ip-address-reseller-usage.assignButton' => 'Tildel til videreforhandler',
    'ip-address-reseller-usage.alreadyAssignedToAllClients' => 'Denne IP adressen er allerede tilordnet til alle brukere.',
    'ip-address-reseller-usage.removeButton' => 'Fjern',
    'ip-address-reseller-usage.removeSuccess' => 'IP-adressen ble fjernet fra {count, plural, =1 {{name}-poolen} one {de # valgte videreforhandleres IP-pool} other {de # valgte videreforhandlernes IP-pool}}.',
    'ip-address-reseller-usage.removeConfirmation' => 'Fjern IP-adressen fra {count, plural, =1 {{name}-poolen} one {de # valgte videreforhandleres IP-pool} other {de # valgte videreforhandlernes IP-pool}}?',
    'ip-address-reseller-usage.typeSHARED' => 'Delt',
    'ip-address-reseller-usage.typeEXCLUSIVE' => 'Dedikert',
    'ip-address-reseller-usage.assign.title' => "Legg til %%ipAddress%% til videreforhandlerens IP-pool",
    'ip-address-reseller-usage.assign.resellersToAdd' => 'Videreforhandlere å legge til',
    'ip-address-reseller-usage.assign.success' => 'IP-adressen ble lagt til {count, plural, =1 {{name}-poolen} one {de # valgte videreforhandleres IP-pool} other {de # valgte videreforhandlernes IP-pool}}.',

    'ProtectedDirectoryUser.emptyViewTitle' => 'Legg til en brukerkonto med tilgang til den beskyttede mappen',
    'ProtectedDirectoryUser.addTooltip' => 'Opprett brukerkontoer som har tilgang til den beskyttede katalogen %%directory%%',
    'ProtectedDirectoryUser.add' => 'Legg til bruker',
    'ProtectedDirectoryUser.login' => 'Navn',
    'ProtectedDirectoryUser.changePassword' => 'Endre passord',
    'ProtectedDirectoryUser.noSelectionText' => 'Velg én eller flere brukere å fjerne.',
    'ProtectedDirectoryUser.remove' => 'Fjern',
    'ProtectedDirectoryUser.removeTooltip' => 'Fjern valgte brukere.',
    'ProtectedDirectoryUser.removeConfirmation' => 'Fjern {count, plural, one {}=1 {bruker {login}} other {# valgte brukere}}?',
    'ProtectedDirectoryUser.removeSuccess' => 'De valgte brukerne ble fjernet.',

    'TrafficUsageByClients.customerName' => 'Kundenavn',
    'TrafficUsageByClients.resellerName' => 'Forhandlernavn',
    'TrafficUsageByClients.totalUsage' => 'Brukt',
    'TrafficUsageByClients.limit' => 'Grense',
    'TrafficUsageByClients.limitRemaining' => 'Tilgjengelig',
    'TrafficUsageByClients.limitUsagePercent' => 'Brukt (i %)',
];
