<?php
// Copyright 1999-2025. WebPros International GmbH. All rights reserved.
$messages = [
    'problem-detail.nginx-upstream-sent-too-big-header.name' => 'Nginx "502 Bad Gateway: upstream sent too big header while reading response header"',
    'problem-detail.nginx-upstream-sent-too-big-header.description' => 'Brzy bude připraveno.',
    'problem-detail.nginx-upstream-sent-too-big-header.cause' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.solution1.title' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.solution1.text' => '',
    'problem-detail.apache-followsymlinks-not-allowed.name' => 'Apache "500 Internal Server Error: Option FollowSymLinks not allowed here"',
    'problem-detail.apache-followsymlinks-not-allowed.description' => 'Brzy bude připraveno.',
    'problem-detail.apache-followsymlinks-not-allowed.cause' => '',
    'problem-detail.phpfpm-server-reached-max-children.name' => 'PHP-FPM "server reached max_children setting"',
    'problem-detail.phpfpm-server-reached-max-children.description' => '<h4>Symptoms</h4><ul><li><p>Websites that have PHP handler set as <strong>FPM application served by Apache</strong> or <strong>FPM application served by nginx</strong> at <strong>Domains</strong> &gt; <strong>example.com</strong> &gt; <strong>PHP Settings</strong> experience one of the following issues:</p><ul><li><p>load slowly</p></li><li><p>not accessible (permanently or periodically) with a 50x error in a web-browser:</p><pre>502 Bad Gateway</pre><hr><pre>503 Service Temporarily Unavailable</pre><hr><pre>504 Gateway Time-out</pre></li></ul></li><li><p>The following message appears in the PHP-FPM error logfile <code>/var/log/plesk-php<strong>XX</strong>-fpm/error.log</code> (where <em>XX</em> is a PHP version used by the websites):</p><pre>WARNING: [pool example.com] server reached max_children setting (*), consider raising it</pre><ul><li><p>The message above is usually accompanied with this error:</p><pre>unable to read what child say: Bad file descriptor (9)</pre></li></ul></li><li><p>If nginx is enabled on the server, one of the following error messages may appear in domain\'s error logfile <code>/var/www/vhosts/system/example.com/logs/proxy_error_log</code>:</p><pre style="white-space: pre-wrap;">[error] 11456#0: *118348 connect() to unix:///var/www/vhosts/system/example.com/php-fpm.sock failed (11: Resource temporarily unavailable) while connecting to upstream, client: 203.0.113.2, server: example.com, request: "GET / HTTP/1.1", upstream: "fastcgi://unix:///var/www/vhosts/system/example.com/php-fpm.sock:", host: "example.com"</pre><hr><pre style="white-space: pre-wrap;">[error] 20058#0: *4725139 upstream prematurely closed connection while reading response header from upstream, client: 203.0.113.2, server: example.com, request: "POST /path/to/some/file HTTP/2.0", upstream:</pre></li></ul>',
    'problem-detail.phpfpm-server-reached-max-children.cause' => ' <p>The PHP-FPM <code>pm.max_children</code> has been reached by the website(s).</p>',
    'problem-detail.phpfpm-server-reached-max-children.solution1.title' => 'Zvýšit limit pm.max_children',
    'problem-detail.phpfpm-server-reached-max-children.solution1.text' => '<p>Increase the <code>pm.max_children</code> limit for the affected domains:</p><ol><li><p>Connect to the Plesk server via <a href="https://support.plesk.com/hc/en-us/articles/12377512781975" target="_blank" rel="noopener">SSH</a>.</p></li><li><p>Find affected domains using the command below:</p><div class="pul-alert pul-alert--info pul-status-message pul-status-message--info"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>Note:</strong> The number on the left indicates how many times the <code>pm.max_children</code> limit has been reached by the website.</div><pre style="white-space: pre-wrap;"># grep -r "server reached max_children setting" /var/log/*php*-fpm/error.log | cut -d\' \' -f5 | tr -d \']\' | sort | uniq -c | sort -nr<br><br>100 example.com<br>50 example.net<br>25 example.org<br>&lt;...&gt;</pre></li><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377667582743" target="_blank" rel="noopener">Log in to Plesk</a>.</p></li><li><p>Go to <strong>Domains</strong> &gt; <strong>example.com</strong> &gt; <strong>PHP Settings</strong> &gt; <strong>PHP-FPM Settings</strong>.</p></li><li><p>Increase the <code>pm.max_children</code> value for the domain and apply the changes. Increase this value for all domains listed in step 2.</p></li></ol>',
    'problem-detail.nginx-too-many-open-files.name' => 'Nginx "Too many open files"',
    'problem-detail.nginx-too-many-open-files.description' => '<p>nginx fails to start/reload on a Plesk server: Too many open files</p><h4>Symptoms</h4><ul><li><p>The nginx service fails to start/reload with the following error in the <code>/var/log/nginx/error.log</code> file:</p><pre style="white-space: pre-wrap;">nginx: [emerg] open() "/var/www/vhosts/system/example.com/logs/proxy_access_ssl_log" failed (24: Too many open files)</pre></li><li><p>Some or all websites are not accessible</p></li><li><p>Warning is shown in the <strong>Tools &amp; Settings &gt; Diagnose &amp; repair</strong>:</p><pre style="white-space: pre-wrap;">Checking for nginx ULIMIT value N domains have been found on server. Problem with nginx default limit for open files is possible</pre></li><li><p>NodeJS and Ruby web applications are showing 502 Bad Gateway error when performing some Plesk tasks such as creating domains, subscriptions, changes on Apache or Nginx, etc:</p><pre style="white-space: pre-wrap;">Server Error<br>502 Bad Gateway <br>Web server received an invalid response while acting as a gateway or proxy server.</pre></li><li><p>After <a href="https://support.plesk.com/hc/en-us/articles/12377676289815-How-to-install-SSL-certificate-for-a-domain-in-Plesk" target="_blank" rel="noopener noreferrer">installing a new certificate for the domain</a>, the old one is still shown in a web browser, however, the correct certificate is selected at the <strong>Domains &gt; example.com &gt; Hosting Settings</strong> page.</p></li></ul>',
    'problem-detail.nginx-too-many-open-files.cause' => '<p>Virtuální hostitel serveru Nginx otevírá pro každého virtuálního hostitele s fyzickým hostováním 4 soubory protokolu:</p><ul><li>proxy_access_log</li><li>proxy_access_ssl_log</li><li>webmail_access_log</li><li>webmail_access_ssl_log</li></ul><p>V důsledku této skutečnosti je maximální počet otevřených souborů serverem nginx překročen z důvodu velkého počtu domén (obvykle více než 100).</p>',
    'problem-detail.nginx-too-many-open-files.solution1.title' => 'Zvýšit limit otevřených souborů',
    'problem-detail.nginx-too-many-open-files.solution1.text' => '<div class="pul-alert pul-alert--warning pul-status-message pul-status-message--warning"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>Warning:</strong> Execution of the <code>websrv_ulimits</code> utility without <strong>--no-restart</strong> option initiates rebuilding of web configuration files for all domains and can cause significant downtime in case of a big number of hosted websites.<br><br>Execute the command during the maintenance time frame.</div><p>It is good practice to set open files limit value more than <strong>number of domains in Plesk * 16</strong> at least. In example below provided actions how to set limit to 4096:</p><ol><li><p>Connect to the server via <a href="https://support.plesk.com/hc/en-us/articles/12377512781975" target="_blank" rel="noopener noreferrer">SSH</a></p></li><li><p>Set open files limit to 4096 for both Apache and Nginx:</p><pre># /usr/local/psa/admin/sbin/websrv_ulimits --set 4096 --no-restart</pre></li><li><p>Restart Apache and nginx services at <strong><a href="https://support.plesk.com/hc/en-us/articles/12377667582743" target="_blank" rel="noopener noreferrer">Plesk</a> &gt;</strong> <strong>Tools &amp; Settings &gt; Services Management</strong> to apply changes.</p></li><li><p>Check that \'Max open files limit\' was applied properly, after web services restarting:</p><pre># grep \'Max open files\' /proc/$(cat /var/run/nginx.pid)/limits<br>Max open files 4096 4096 file</pre></li><li><p>If the solution above did not help, set the limit using the <code>ulimit</code> utility:</p><pre># ulimit -n 4096</pre></li></ol>',
    'problem-detail.apache-modsec-response-body-too-large.name' => 'ModSecurity "Response body too large"',
    'problem-detail.apache-modsec-response-body-too-large.description' => 'Brzy bude připraveno.',
    'problem-detail.apache-modsec-response-body-too-large.cause' => '',
    'problem-detail.modsec-access-denied.name' => 'ModSecurity "Access denied with code 403"',
    'problem-detail.modsec-access-denied.description' => '<h4>Příznaky</h4><ul><li><p>ModSecurity je nainstalováno a povoleno v nabídce <strong>Nástroje a nastavení > Brána firewall webové aplikace (ModSecurity) > Režim brány firewall webové aplikace > Zap</strong>.</p></li><li>Web hostovaný na platformě Plesk se nenačítá. Není možné provádět operace na webu, například spravovat WordPress, přistupovat k webovému poštovnímu serveru nebo k souboru <code>robots.txt</code>. Prohlížeč ale zobrazí někteoru z následujících chyb: <pre>ERR_CONNECTION_REFUSED</pre><hr><pre>403 Forbidden</pre><hr><pre>500 Internal Server Error</pre><hr><pre>ERR_CONNECTION_TIMED_OUT</pre></li><li>V souboru protokolu <code>/var/log/modsec_audit.log</code> nebo na stránce Protokoly v platformě Plesk (<strong>Domains</strong> &gt; <strong>example.com</strong> &gt; <strong>Logs</strong>) se zobrazí některá z níže uvedených chybových zpráv ModSecurity: <pre>ModSecurity: Přístup odepřen s kódem 403 (fáze 2). Operátor GE roven v TX:anomaly_score. [soubor "/etc/apache2/modsecurity.d/rules/owasp_modsecurity_crs_4-plesk/REQUEST-949-BLOCKING-EVALUATION.conf"] [řádek "57"] [id "949110"] [msg "Překročeno skóre příchozích anomálií (celkové skóre: 5)"] [závažnost "KRITICKÁ"] [tag "application-multi"] [tag "language-multi"] [tag "platform-multi"] [tag "attack-generic"] [hostname "example.com"] [uri "/robots.txt"] [unique_id "XPsROH8AAQEAABEiZFcAAABC"]</pre></li>',
    'problem-detail.modsec-access-denied.cause' => '<p>Brána firewall ModSecurity webové aplikace je aktivována s velmi omezující sadou pravidel, jako například OWASP, Comodo nebo s vlastní sadou pravidel, jako například Imunify360. Omezující sady pravidel mohou na webu zablokovat určité operace.</p><p><Strong>Poznámka:</strong> Chyba ModSecurity může poukazovat na útok na váš server. Níže uvedená řešení používejte pouze v případech, kdy si jste jistí, že ModSecurity blokuje oprávněné používání vašeho webu.</p>',
    'problem-detail.modsec-access-denied.solution1.title' => 'Zakažte sadu pravidel ModSecurity dle ID nebo tagu',
    'problem-detail.modsec-access-denied.solution1.text' => '<ol><li><p>Vyhledejte ID pravidla, které blokuje legitimní používání vašeho webu. ID najdete uvnitř chybových zpráv v protokolovém souboru <code>/var/log/modsec_audit.log</code>. ID je celé číslo v uvozovkách s předponou <code>id</code> v hranatých závorkách, například <strong>[id "210831"]</strong>.</p></li><li><a href="https://support.plesk.com/hc/en-us/articles/12377453278871" target="_blank" rel="noopener">Zakažte konkrétní sady pravidel v platformě Plesk</a>.</li></ol>',
    'problem-detail.modsec-access-denied.solution2.title' => 'Přejděte na jinou sadu pravidel ModSecurity',
    'problem-detail.modsec-access-denied.solution2.text' => '<ol><li><p>Přejděte na méně omezující sadu pravidel ModSecurity, například „Atomic ModSecurity Ruleset“. To provedete tak, že přejdete do nabídky <strong>Nástroje a nastavení</strong> > <strong>Brána firewall webové aplikace (ModSecurity)</strong> > <strong>Nastavení</strong>, vyberete <strong>Atomic Standard</strong> a pak kliknete na <strong>OK</strong>, čímž změny aplikujete.</p></li></ol>',
    'problem-detail.php-allowed-memory-size-exhausted.name' => 'PHP "Internal Server error 500: Allowed memory size of XXX exhausted"',
    'problem-detail.php-allowed-memory-size-exhausted.description' => '<h4>Příznaky</h4><ul><li><p>Web hostovaný na platformě Plesk není přístupný:</p><pre>500 Internal Server Error</pre></li><li><p>V protokolu webu se zobrazí následující chyba:</p><pre>Obdržena chyba "Zpráva PHP: Fatální chyba PHP: Byla překročena přípustná velikost paměti 4194304 bytů (byl učiněn pokus o alokaci 4000032 bytů) v /var/www/vhosts/example.com/httpdocs/somethingBig.php na řádku 3"</pre></li> </ul>',
    'problem-detail.php-allowed-memory-size-exhausted.cause' => '<p>Web nemá dostatek alokované paměti ke zpracování požadavku.</p>',
    'problem-detail.php-allowed-memory-size-exhausted.solution1.title' => 'Navyšte memory_limit na webu',
    'problem-detail.php-allowed-memory-size-exhausted.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377510316183" target="_blank" rel="noopener">Přečtěte si článek znalostní báze a řiďte se pokyny</a>.</p></li></ol>',
    'problem-detail.php-open-basedir-restriction-in-effect.name' => 'PHP "open_basedir restriction in effect"',
    'problem-detail.php-open-basedir-restriction-in-effect.description' => '<h4>Příznaky</h4><ul><li><p>Web není dostupný a ve webovém prohlížeči se zobrazí některá z následujících chyb:</p><pre>404 file not found</pre><hr><pre>500 Internal Server Error</pre><hr><pre>Error 500 move_uploaded_file(): Platí omezení open_basedir. Soubor (/cesta/do/cilove/slozky) není v přípustné cestě: (/var/www/vhosts/example.com/:/tmp/)</pre></li><li><p>Na stránce protokolů domény se zobrazuje následující chybová zpráva (<strong>Domains</strong> > <strong>example.com</strong> > <strong>Logs</strong>):</p><pre><...> platí omezení open_basedir. Soubor (/cesta/do/cilove/slozky) není v přípustné cestě <...></pre><hr><pre>Neošetřená výjimka: Relace: Konfigurovaná cesta pro uložení „/cesta/do/cilove/slozky“ není adresářem, neexistuje a nelze ji vytvořit.</pre></li></ul>',
    'problem-detail.php-open-basedir-restriction-in-effect.cause' => 'Skript PHP se snaží přistoupit k adresáři, do kterého nemá povolen přístup. Toto omezení je definováno direktivou PHP <code>open_basedir</code> pro každou doménu zvlášť. Ve výchozím nastavení <code>open_basedir</code> dovoluje přistupovat ke <code>tmp</code> a kořenovým adresářům dokumentů domény a také k výchozí cestě relací systému.',
    'problem-detail.php-open-basedir-restriction-in-effect.solution1.title' => 'Přidejte další cestu k direktivě open_basedir',
    'problem-detail.php-open-basedir-restriction-in-effect.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377510714135" target="_blank" rel="noopener">Přečtěte si článek znalostní báze a řiďte se pokyny</a>.</p></li></ol>',
    'problem-detail.php-open-basedir-restriction-in-effect.solution2.title' => 'Zakažte direktivu open_basedir',
    'problem-detail.php-open-basedir-restriction-in-effect.solution2.text' => '<ol><li><p>Přejděte na stránku <strong>Domény &gt example.com &gt Nastavení PHP </strong> a nastavte direktivu <code>open_basedir</code> na „none“ (žádnou).</p></li></ol>',
    'problem-detail.apache-client-denied-by-server.name' => 'Apache .htaccess "403 Forbidden AH01797: client denied by server configuration"',
    'problem-detail.apache-client-denied-by-server.description' => '<h4>Příznaky</h4><ul><li><p>Web zobrazuje chybu podobnou následujícímu příkladu:</p><pre>Server Error 403<br>Forbidden</pre></li><li><p>Soubor protokolu <code>/var/www/vhosts/system/example.com/logs/error_log</code> obsahuje například následující chyby:</p><pre>AH01797: klient odmítnut kvůli konfiguraci serveru: /var/www/vhosts/example.com/index.php</pre></li></ul>',
    'problem-detail.apache-client-denied-by-server.cause' => '<p>Současné nastavení Apache neumožňuje přístup k tomuto webu.</p><p> Pro soubory jako .htaccess a .htpasswd se to dá očekávat, protože tyto soubory by neměly být přes webový server dostupné.</p>',
    'problem-detail.apache-client-denied-by-server.solution1.title' => 'Zkontrolujte konfiguraci serveru a soubory .htaccess',
    'problem-detail.apache-client-denied-by-server.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377654829463" target="_blank" rel="noopener">Přečtěte si článek znalostní báze a řiďte se pokyny</a>.</p></li></ol>',
    'problem-detail.apache-no-directory-index.name' => 'Apache "Cannot access a website directory in Plesk: 403 Forbidden"',
    'problem-detail.apache-no-directory-index.description' => '<h4>Příznaky</h4><ul><li><p>Nelze přistoupit ke konkrétnímu umístění na webu, například <code>http://example.com/some_folder</code>. Objeví se následující chyba:</p><pre>Server Error 403<br>Forbidden</pre></li><li><p>V souboru protokolu <code>/var/www/vhosts/example.com/logs/error_log<code/> se objeví následující chyba:</p><pre>[autoindex:error] [pid 16314:tid 140300215322368] [client 203.0.113.2:55714] AH01276: Nelze obsloužit složku /var/www/vhosts/example.com/httpdocs/some_folder/: Neexistuje odpovídající DirectoryIndex (index.html,index.cgi,index.pl,index.php,index.xhtml,index.htm,index.shtml) a index adresáře vygenerovaný serverem byl zakázán nastavující direktivou</pre></li></ul>',
    'problem-detail.apache-no-directory-index.cause' => '<p>Požadovaný adresář neobsahuje soubory indexu, nebo procházení adresáře není povoleno.</p>',
    'problem-detail.apache-no-directory-index.solution1.title' => 'Přidejte soubor indexu do adresáře',
    'problem-detail.apache-no-directory-index.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377654829463" target="_blank" rel="noopener">Přečtěte si článek znalostní báze a řiďte se pokyny</a>.</p></li></ol>',
    'problem-detail.apache-no-directory-index.solution2.title' => 'Povolit procházení adresáře',
    'problem-detail.apache-no-directory-index.solution2.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377172809495" target="_blank" rel="noopener">Přečtěte si článek znalostní báze a řiďte se pokyny</a>.</p></li></ol>',
    'problem-detail.nginx-no-directory-index.name' => 'Nginx "Cannot access a website directory in Plesk: 403 Forbidden"',
    'problem-detail.nginx-no-directory-index.description' => '<h4>Příznaky</h4><ul><li><p>Nelze získat přístup ke konkrétnímu umístění na webu, například k <code>http://example.com/some_folder</code>. Vyskytnou se následující chyby:</p><pre>Server Error 403<br>Forbidden</pre></li><li><p>V souboru protokolu <code>/var/www/vhosts/example.com/logs/error_log file</code> se zobrazí následující chyba:</p><pre>[autoindex:error] [pid 16314:tid 140300215322368] [client 203.0.113.2:55714] AH01276: Nelze obsloužit adresář /var/www/vhosts/example.com/httpdocs/some_folder/: Neexistuje odpovídající DirectoryIndex (index.html,index.cgi,index.pl,index.php,index.xhtml,index.htm,index.shtml) a serverem vygenerovaný index adresáře je zakázán nastavující direktivou</pre></li></ul>',
    'problem-detail.nginx-no-directory-index.cause' => '<p>Požadovaný adresář neobsahuje soubory indexu, nebo procházení adresáře není povoleno.</p>',
    'problem-detail.nginx-no-directory-index.solution1.title' => 'Přidejte soubor indexu do adresáře',
    'problem-detail.nginx-no-directory-index.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377654829463" target="_blank" rel="noopener">Přečtěte si článek znalostní báze a řiďte se pokyny</a>.</p></li></ol>',
    'problem-detail.nginx-no-directory-index.solution2.title' => 'Povolit procházení adresáře',
    'problem-detail.nginx-no-directory-index.solution2.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377172809495" target="_blank" rel="noopener">Přečtěte si článek znalostní báze a řiďte se pokyny</a>.</p></li></ol>',
    'problem-detail.apache-reached-max-request-workers.name' => 'Apache "server reached MaxRequestWorkers setting"',
    'problem-detail.apache-reached-max-request-workers.description' => 'Brzy bude připraveno.',
    'problem-detail.apache-reached-max-request-workers.cause' => '',
    'problem-detail.php-post-content-length-exceeds-limit.name' => 'PHP request body limit "client intended to send too large body"',
    'problem-detail.php-post-content-length-exceeds-limit.description' => 'Brzy bude připraveno.',
    'problem-detail.php-post-content-length-exceeds-limit.cause' => '',
    'problem-detail.nginx-client-sent-too-large-body.name' => 'PHP request body limit "client intended to send too large body"',
    'problem-detail.nginx-client-sent-too-large-body.description' => 'Brzy bude připraveno.',
    'problem-detail.nginx-client-sent-too-large-body.cause' => '',
    'problem-detail.php-failed-to-read-session-data.name' => 'PHP sessions "503 Internal Server Error" or "Failed to read session data"',
    'problem-detail.php-failed-to-read-session-data.description' => 'Brzy bude připraveno.',
    'problem-detail.php-failed-to-read-session-data.cause' => '',
    'problem-detail.apache-unable-to-check-htaccess-file.name' => 'Apache .htaccess "403 Forbidden: pcfg_openfile: unable to check htaccess file, ensure it is readable"',
    'problem-detail.apache-unable-to-check-htaccess-file.description' => '<h4>Příznaky</h4><ul><li><p>Web hostovaný na platformě Plesk nefunguje:</p><pre>Nemáte oprávnění pro přístup k tomuto serveru. <br> Navíc došlo k výskytu chyby 403 Forbidden při snaze použít rutinu ErrorDocument k obsluze požadavku.</pre><p>Namísto výše uvedené chyby se může zobrazit také prázdná stránka.</p></li><li><p>Protokol chyb domény v <strong>Domains &gt example.com &gt Logs</strong> obsahuje následující informace:</p><pre>(13)Permission denied: [client 203.0.113.2:39024] AH00529: /var/www/vhosts/example.com/httpdocs/.htaccess pcfg_openfile: Nelze zkontrolovat soubor htaccess, ujistěte se, že je čitelný a že „/var/www/vhosts/example.com/httpdocs/“ lze spustit</pre></li></ul>',
    'problem-detail.apache-unable-to-check-htaccess-file.cause' => 'Nesprávná oprávnění pro soubory nebo složky domény.',
    'problem-detail.apache-unable-to-check-htaccess-file.solution1.title' => 'Opravte oprávnění pro webový obsah',
    'problem-detail.apache-unable-to-check-htaccess-file.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377773681815" target="_blank" rel="noopener">Přečtěte si článek znalostní báze a řiďte se pokyny</a>.</p></li></ol>',
];
