<?php
// Copyright 1999-2025. WebPros International GmbH. All rights reserved.

$messages = [
    'additional-key-info.title' => 'Свойства дополнительного ключа',
    'additional-key-info.update' => 'Получить дополнительный ключ',
    'additional-key-info.updateDescription' => 'Получить дополнительный ключ и установить его.',
    'additional-key-info.download' => 'Скачать ключ',
    'additional-key-info.downloadDescription' => 'Загрузить текущий ключ лицензии.',
    'additional-key-info.install' => 'Установить ключ',
    'additional-key-info.installDescription' => 'Установить текущий ключ лицензии.',
    'additional-key-info.revert' => 'Откат ключа',
    'additional-key-info.revertDescription' => 'Вернуться к предыдущему ключу лицензии.',
    'additional-key-info.revertNotAvailableDescription' => 'Ключ не установлен',
    'additional-key-info.installSuccess' => 'Процедура установки лицензионного ключа запущена.',

    'additional-key-revert.title' => 'Возврат к предыдущему дополнительному ключу',
    'additional-key-revert.success' => 'Вы вернулись к предыдущему дополнительному ключу.',

    'additional-key-upload.title' => 'Установить ключ лицензии',
    'additional-key-upload.success' => 'Новый дополнительный ключ был загружен',

    'additional-keys.title' => 'Дополнительные лицензионные ключи',

    'change-subscriptions-owner.title' => 'Назначить нового владельца для выбранных подписок',
    'change-subscriptions-owner.success' => 'Владелец подписки изменен',

    'customers.hint' => 'На этой странице вы можете управлять учетными записями своих хостинг-клиентов: создавать новые учетные записи с подписками, управлять существующими клиентами и удалять учетные записи. Для управления сайтами, почтой и другими услугами того или иного клиента перейдите в его Панель клиента, нажав на соответствующую ссылку в колонке справа.',

    'customer-domains.hint' => 'Здесь вы можете создавать сайты и управлять ими.',

    'customer-subscriptions.hint' => 'Здесь вы можете управлять подписками данного клиента.',

    'domains.hint' => 'Здесь вы можете просматривать информацию обо всех доменах, зарегистрированных в системе, и можете перейти к управлению услугами хостинга. Чтобы добавить домен для себя или обслуживаемых клиентов, нажмите "Добавить домен". При создании домена вам будет предложено создать нового клиента или подписку или выбрать из существующих.',

    'database-servers.title' => 'Серверы баз данных',

    'database-server-create.title' => 'Новый сервер баз данных',

    'database-server-properties.title' => 'Сервер баз данных',

    'database-server-upgrade.drawerTitle' => 'Обновление MariaDB',
    'database-server-upgrade.drawerTitle.completed' => 'Обновление завершено',
    'database-server-upgrade.drawerSubTitle.line1' => 'Боковое меню нельзя закрыть, когда выполняется обновление.',
    'database-server-upgrade.drawerSubTitle.line2' => 'Если во время обновления возникнут проблемы, см. %%troubleshootingArticle%%.',
    'database-server-upgrade.drawerSubTitle.completed' => 'Сервер баз данных MariaDB был обновлен до версии %%releaseVersion%%. Если у вас возникнут проблемы, см. %%troubleshootingArticle%%.',
    'database-server-upgrade.upToDate' => 'У вас уже установлена версия LTS.',
    'database-server-upgrade.troubleshootingArticle' => 'эту статью базы знаний',
    'database-server-upgrade.troubleshootingArticleDescription' => 'Для устранения проблем, связанных с обновлением MariaDB, см. %%troubleshootingArticle%%.',

    'database-server-upgrade.chooseReleaseStep.infoBlock.par1' => 'Обновите свой локальный сервер баз данных MariaDB до текущей версии с долгосрочной поддержкой (LTS).',
    'database-server-upgrade.chooseReleaseStep.infoBlock.par2' => 'Мы настоятельно рекомендуем перед обновлением создать резервную копию сервера и начать обновление в непиковые часы работы сервера.',
    'database-server-upgrade.chooseReleaseStep.infoBlock.par3' => 'Во время обновления MariaDB сервер Plesk и размещенные на нем сайты будут недоступны. Обновление MariaDB обычно выполняется без ошибок и занимает около 10 минут, однако может повлиять на работу всего сервера.',
    'database-server-upgrade.chooseReleaseStep.infoBlock.par4' => 'Примечание. Если у вас установлена версия MariaDB 5.5, Plesk сначала обновит ее до MariaDB 10.5. После завершения обновления снова запустите этот мастер, чтобы выполнить обновление до текущей LTS-версии MariaDB.',
    'database-server-upgrade.chooseReleaseStep.currentVersionTitle' => 'Текущая версия',
    'database-server-upgrade.chooseReleaseStep.currentMariaDBVersion' => 'MariaDB %%version%%',
    'database-server-upgrade.chooseReleaseStep.selectVersion' => 'Выберите версию, до которой требуется обновить',
    'database-server-upgrade.chooseReleaseStep.noMajorReleases' => 'Нет основных версий',
    'database-server-upgrade.chooseReleaseStep.releaseNotes' => 'Заметки о выпуске',
    'database-server-upgrade.chooseReleaseStep.releaseDate' => 'Дата выпуска: %%date%%',
    'database-server-upgrade.chooseReleaseStep.endOfLifeDate' => 'Дата окончания поддержки: %%date%%',
    'database-server-upgrade.chooseReleaseStep.notDetected' => 'Обновить можно только ветки MariaDB, предоставленные поставщиками ОС или разработчиком MariaDB.',

    'database-server-upgrade.preUpgradeCheckProgressStep.title' => 'Предварительные проверки',
    'database-server-upgrade.preUpgradeCheckProgressStep.configChecker' => 'Разбор конфигурационных файлов MariaDB',
    'database-server-upgrade.preUpgradeCheckProgressStep.mysqlChecker' => 'Анализ баз данных с помощью mysqlcheck',
    'database-server-upgrade.preUpgradeCheckProgressStep.packageManagerChecker' => 'Анализ настроек менеджера пакетов',
    'database-server-upgrade.preUpgradeCheckProgressStep.systemCompatibilityChecker' => 'Проверка совместимости системы',
    'database-server-upgrade.preUpgradeCheckProgressStep.webSocketChecker' => 'Проверка WebSocket',

    'database-server-upgrade.preUpgradeCheckStep.shouldBeConfirmed' => 'Поставьте все флажки, чтобы продолжить обновление. Так вы подтвердите, что принимаете все изменения конфигурации, которые будут сделаны во время обновления, и у вас имеется доступ к средствам восстановления.',
    'database-server-upgrade.preUpgradeCheckStep.removedSystemVariables' => 'Для обеспечения совместимости с новой версией будут удалены следующие переменные:',
    'database-server-upgrade.preUpgradeCheckStep.removedConfigFiles' => 'Следующие конфигурационные файлы будут удалены, поскольку они входят в пакет mariadb-server, который будет обновлен:',
    'database-server-upgrade.preUpgradeCheckStep.fromFiles' => '{variable} из {count, plural, one {# файла: {files}} few {# файлов: {files}} many {# файлов: {files}} other {# файла: {files}}}',
    'database-server-upgrade.preUpgradeCheckStep.accessToolsSection' => 'Доступ к средствам восстановления (консоль командной строки сервера и Repair Kit)',
    'database-server-upgrade.preUpgradeCheckStep.sshAccess' => 'Я подтверждаю, что у меня имеется доступ к серверу по SSH',
    'database-server-upgrade.preUpgradeCheckStep.sshAccessDescription' => 'Используйте SSH-клиент или откройте %%sshTerminalExtension%% в новой вкладке браузера (не закрывайте окно с расширением SSH Terminal до завершения обновления). В случае проблем с обновлением открытый сеанс SSH поможет выполнить восстановление.',
    'database-server-upgrade.preUpgradeCheckStep.sshTerminalExtension' => 'Расширение SSH Terminal',
    'database-server-upgrade.preUpgradeCheckStep.repairKitAccess' => 'Я подтверждаю, что у меня имеется доступ к Repair Kit',
    'database-server-upgrade.preUpgradeCheckStep.repairKitAccessDescription' => 'Откройте %%repairKit%% в новой вкладке браузера и войдите под учетной записью администратора. Не закрывайте окно с расширением Repair Kit до завершения обновления.',
    'database-server-upgrade.preUpgradeCheckStep.repairKit' => 'Repair Kit',
    'database-server-upgrade.preUpgradeCheckStep.dumpSection' => 'Создать резервную копию баз данных',
    'database-server-upgrade.preUpgradeCheckStep.withDump' => 'Перед обновлением создайте резервные копии всех баз данных, размещенных на сервере',
    'database-server-upgrade.preUpgradeCheckStep.withDumpDescription' => 'Plesk хранит резервные копии баз данных в папке %%path%%.',
    'database-server-upgrade.preUpgradeCheckStep.webSocketNotAvailable' => 'WebSocket в Plesk недоступен',
    'database-server-upgrade.preUpgradeCheckStep.webSocketNotAvailableDescription' => 'Без WebSocket вы не сможете видеть в режиме реального времени вывод процесса обновления.',

    'database-server-upgrade.submitPopover.title' => 'В целях предотвращения потери данных мы настоятельно рекомендуем перед продолжением создать дамп размещенных на сервере баз данных. Продолжить без создания дампа?',

    'database-server-databases.title' => 'Базы данных',

    'database-server-change-password.title' => 'Пароль администратора',

    'home.title' => 'Главная',

    'license.title' => 'Информация о лицензии',

    'primary-key-info.title' => 'Ключ лицензии Plesk',
    'primary-key-info.update' => 'Получить ключи',
    'primary-key-info.updateDescription' => 'Получить заказанные лицензионные ключи и установить их.',
    'primary-key-info.upload' => 'Установить ключ',
    'primary-key-info.uploadDescription' => 'Загрузить и установить новый ключ лицензии.',
    'primary-key-info.revert' => 'Откат ключа',
    'primary-key-info.revertDescription' => 'Вернуться к предыдущему ключу лицензии.',
    'primary-key-info.expireTitle' => 'Закончился срок действия вашей лицензии Plesk',
    'primary-key-info.header' => 'В результате этого некоторые критичные услуги стали недоступны. %%warning%%',
    'primary-key-info.headWarning' => 'Ваши сайты могут быть под угрозой!',
    'primary-key-info.softwareUpdatesTitle' => 'Обновления программного обеспечения',
    'primary-key-info.softwareUpdates' => '%%title%% отключены. Ваша система может быть уязвима к угрозам.',
    'primary-key-info.websiteBackupsTitle' => 'Резервные копии сайтов',
    'primary-key-info.websiteBackups' => '%%title%% больше недоступны. Вы под угрозой потери данных.',
    'primary-key-info.sslCertificatesTitle' => 'SSL/TLS-сертификаты',
    'primary-key-info.sslCertificates' => '%%title%% не будут продляться автоматически. Это может привести к снижению уровня безопасность и потере доверия.',
    'primary-key-info.monitoringTitle' => 'Мониторинг',
    'primary-key-info.monitoring' => '%%title%% недоступен. Перегрузки и проблемы производительности могут остаться незамеченными.',
    'primary-key-info.fileDbManagementTitle' => 'Управление файлами и базами данных',
    'primary-key-info.fileDbManagement' => '%%title%% отключено. Вы не можете эффективно управлять своими файлами и базами данных.',
    'primary-key-info.technicalSupportTitle' => 'Техническая поддержка',
    'primary-key-info.technicalSupport' => '%%title%% недоступна. Невозможность получить помощь в случае проблем с сервером может привести к длительным перебоям в работе.',
    'primary-key-info.renewLicense' => 'Чтобы восстановить эти услуги, купите новую лицензию Plesk.',
    'primary-key-info.footer' => 'По всем вопросам и проблемам ',
    'primary-key-info.supportLink' => 'обращайтесь в службу поддержки Plesk',

    'primary-key-revert.title' => 'Возврат к предыдущему лицензионному ключу',
    'primary-key-revert.success' => 'Вы вернулись к предыдущему ключу Plesk.',

    'primary-key-upload.title' => 'Установить ключ лицензии',
    'primary-key-upload.success' => 'Новый ключ Plesk загружен.',

    'resellers.hint' => 'Здесь вы можете управлять учетными записями реселлеров — ваших клиентов, которые перепродают услуги хостинга и размещают собственные сайты. Здесь вы можете создавать учетные записи с подписками, управлять существующими реселлерами и удалять учетные записи.',

    'reseller-customers.hint' => 'Здесь вы можете создавать учетные записи клиентов и управлять ими.',

    'reseller-domains.hint' => 'Здесь вы можете создавать сайты и управлять ими.',

    'reseller-subscriptions.hint' => 'Здесь вы можете управлять подписками данного реселлера.',

    'subscriptions.hint' => 'Для того чтобы воспользоваться вашими услугами хостинга, клиентам необходимо подписаться на один из ваших хостинг-планов. На этой странице вы можете управлять такими подписками, а также подписками, которые вы создали для хостинга собственных сайтов. Для управления сайтами, почтой и другими услугами в рамках той или иной подписки перейдите в Панель клиента конкретного подписчика, нажав на соответствующую ссылку в колонке справа.',

    'server-mail-settings.title' => 'Настройки',
    'server-mail-spam-filter.title' => 'Антиспам',
    'server-mail-antivirus.title' => 'Антивирус',
    'server-mail-black-list.title' => 'Черный список',
    'server-mail-white-list.title' => 'Белый список',
    'server-mail-queue.title' => 'Очередь почтовых сообщений',
    'server-mail-statistics.title' => 'Статистика',
    'server-mail-smarthost.title' => 'Промежуточный узел',

    'server-spam-filter.settings' => 'Настройки',
    'server-spam-filter.black-list' => 'Черный список',
    'server-spam-filter.white-list' => 'Белый список',

    'firewall.title' => 'Управление брандмауэром',
    'firewall-general.title' => 'Общие',
    'firewall-general.toggleStatus' => 'Защита брандмауэра',
    'firewall-general.buttonDefault' => 'Вернуться к значениям по умолчанию',
    'firewall-general.buttonPanic' => 'Панический режим',
    'firewall-general.confirmationDefault' => 'Сбросить настройки брандмауэра на значения по умолчанию?',
    'firewall-general.confirmationPanic' => 'Включить режим максимальной защиты? Пользователи не смогут получить доступ к своим доменам, а некоторые сетевые службы могут перестать работать.',
    'firewall-general.successDefault' => 'Настройки брандмауэра были сброшены на значения по умолчанию.',
    'firewall-general.successPanic' => 'Режим максимальной защиты включен.',
    'firewall-general.info' => 'В целях безопасности брандмауэр блокирует все подключения, кроме специально разрешенных. Вы можете разрешить подключение, создав правило. Более подробную информацию смотрите в документации.',
    'firewall-general.interfaces' => 'сетевых интерфейсов',
    'firewall-icmp.title' => 'Протокол ICMP',
    'firewall-rules.title' => 'Правила брандмауэра',

    'dns.title' => 'Настройки DNS',
    'dns-records.title' => 'Шаблон записей зоны',
    'dns-soa-record.title' => 'Шаблон настроек зоны',

    'php-handler.title' => 'Настройки для %%name%%',
    'php-handler.extensions.title' => 'Расширения',
    'php-handler.extensions.description' => 'Эти настройки библиотек PHP действуют только для этого обработчика.',
    'php-handler.extensions.descriptionShared' => 'Эти настройки являются общими для следующих обработчиков PHP: %%handlers%%. Настройки действуют для всех сайтов, использующих эти обработчики.',
    'php-handler.extensions.buttonManage' => 'Управление пакетами PECL',
    'php-handler.extensions.manage.title' => 'Управление пакетами PECL',
    'php-handler.extensions.manage.risks' => 'Расширения PHP представлены в сторонних пакетах PECL. Вы устанавливаете их под свою ответственность.',
    'php-handler.extensions.manage.description' => 'Устанавливайте, улучшайте и удаляйте пакеты PECL. Изменения будут применены для всех сайтов, работающих на %%handlers%%.',
    'php-handler.extensions.manage.notFound' => 'Почему желаемого пакета нет в списке?',
    'php-handler.extensions.manage.limitations' => 'В списке не отражены расширения PHP, предоставленные провайдером панели управления и поставщиками ОС.',
    'php-handler.php-ini.title' => 'php.ini',


    'ServerInformation.refresh' => "Обновить",
    'ServerInformation.sectionGeneral' => "Общие",
    'ServerInformation.cpu' => "Процессор",
    'ServerInformation.version' => "Версия",
    'ServerInformation.os' => "Операционная система",
    'ServerInformation.key' => "Ключ лицензии Plesk",
    'ServerInformation.uptime' => "Время непрерывной работы",
    'ServerInformation.uptimeValue' => "{days, plural, =0 {} one {# день} few {# дня} many {# дней} other {# день}} {hours, plural, one {# час} few {# часа} many {# часов} other {# час}} {minutes, plural, one {# минута} few {# минуты} many {# минут} other {# минута}}",
    'ServerInformation.sectionCpu' => "Загрузка процессора",
    'ServerInformation.la1min' => "За последнюю минуту",
    'ServerInformation.la5min' => "За последние 5 минут",
    'ServerInformation.la15min' => "За последние 15 минут",
    'ServerInformation.sectionMemory' => "Использование памяти",
    'ServerInformation.memoryHardware' => "Оборудование",
    'ServerInformation.memoryTotalNoKernel' => "Всего (за исключением ядра)",
    'ServerInformation.memoryTotal' => "Всего",
    'ServerInformation.memoryUsed' => "Используется",
    'ServerInformation.memoryFree' => "Свободно",
    'ServerInformation.memoryShared' => "В общем доступе",
    'ServerInformation.memoryBuffer' => "Буфер",
    'ServerInformation.memoryCached' => "Кэш",
    'ServerInformation.memoryAvailable' => "Доступно",
    'ServerInformation.memoryUsage' => "Использование",
    'ServerInformation.sectionSwap' => "Использование подкачки",
    'ServerInformation.sectionVirtualMemory' => "Использование виртуальной памяти",
    'ServerInformation.swapTotal' => "Всего",
    'ServerInformation.swapUsed' => "Используется",
    'ServerInformation.swapFree' => "Свободно",
    'ServerInformation.swapUsage' => "Использование",
    'ServerInformation.sectionHarddisk' => "Использование места на жестком диске",
    'ServerInformation.harddiskDirectory' => "Файловая система",
    'ServerInformation.harddiskProtectedDir' => "Важные папки",
    'ServerInformation.harddiskTotal' => "Всего",
    'ServerInformation.harddiskUsed' => "Занято",
    'ServerInformation.harddiskAvailable' => "Доступно",
    'ServerInformation.harddiskCapacity' => "Объем",
    'ServerInformation.sectionDomains' => "Домены",
    'ServerInformation.activeDomains' => "Активные",
    'ServerInformation.inactiveDomains' => "Неактивные",
    'ServerInformation.problemDomains' => "Проблемы",
    'ServerInformation.refreshed' => "Информация обновлена.",

    'ServerAbout.copyright' => '© 2025 WebPros International GmbH. Все права защищены.',
    'ServerAbout.linkLicenseManagement' => 'Перейти к информации о лицензии',
    'ServerAbout.panelVersion' => 'Версия',
    'ServerAbout.installedPatchVersion' => 'Обновление #%%patch%%',
    'ServerAbout.licenseKey' => 'Ключ лицензии',
    'ServerAbout.productDescription' => 'Plesk - ведущая платформа WebOps для запуска, автоматизации и масштабирования приложений, сайтов и хостингового бизнеса.',
    'ServerAbout.readEula' => 'Читать %%link%%.',
    'ServerAbout.linkEula' => 'Лицензионное соглашение с конечным пользователем',
    'ServerAbout.visitForum' => 'Посмотреть %%link%%',
    'ServerAbout.linkForum' => 'Форум Plesk',
    'ServerAbout.followUs' => 'Следите за нами',
    'ServerAbout.visitSite' => 'Узнать больше на %%link%%',
    'ServerAbout.linkSite' => 'plesk.com',
    'ServerAbout.visitBlog' => 'Искать вдохновения на %%link%%',
    'ServerAbout.linkBlog' => 'Блог Plesk',
    'ServerAbout.ip2locationCopyright' => 'Plesk использует базу данных IP2Location LITE для %%link%%.',
    'ServerAbout.linkGeolocation' => 'геолокации IP-адресов',

    'ServerAbout.darkThemePromoTitle' => 'Поздравляем!',
    'ServerAbout.darkThemePromoDescription' => 'Вы нашли волшебного кисулькена.',
    'ServerAbout.darkThemePromoButton' => 'Вжух! Переходи на темную сторону',
    'ServerAbout.darkThemeTourDescription' => 'С помощью этой опции можно включить или отключить темную тему интерфейса.',
    'ServerAbout.darkThemeTourButton' => 'Понятно',

    'ts-sessions.title' => 'Удаленные сеансы',
    'ts-sessions-properties.title' => 'Свойства сеанса',

    'BandwidthLimiting.bandwidthThrottling' => 'Вы не можете управлять пропускной способностью, потому что не установлено QoS.',
    'BandwidthLimiting.virtualHostingRequired' => 'Пропускная способность доступна только для доменов с веб-хостингом.',
    'BandwidthLimiting.bandwidthLabel' => 'Максимальный объем трафика',
    'BandwidthLimiting.bandwidthHint' => 'Ограничение трафика распространяется только на данные, передаваемые по протоколу HTTP.',
    'BandwidthLimiting.maxConnectionLabel' => 'Количество соединений',
    'BandwidthLimiting.maxConnectionHint' => 'Если вы ограничиваете трафик, мы рекомендуем также ограничить число одновременных подключений к сайту. Иначе в случае частых обращений к сайту процессы веб-сервера увеличат нагрузку на сервер.',
    'BandwidthLimiting.kbps' => 'Кб/с',
    'BandwidthLimiting.success' => 'Изменены настройки пропускного лимита.',
    'BandwidthLimiting.unlimited' => 'Без ограничений',

    'ip-address-domains.title' => 'Сайты, использующие %%type%% IP-адрес %%ipAddress%%',
    'ip-address-domains.site' => 'Сайт',
    'ip-address-domains.setAsDefault' => 'Установить по умолчанию',
    'ip-address-domains.type-SHARED' => 'общий',
    'ip-address-domains.type-EXCLUSIVE' => 'выделенный',

    'HotlinkProtection.virtualHostingRequired' => 'Защита от хотлинкинга доступна только для доменов с веб-хостингом.',
    'HotlinkProtection.enabledLabel' => 'Включить защиту от хотлинкинга',
    'HotlinkProtection.extensionsLabel' => 'Расширения защищенных файлов',
    'HotlinkProtection.friendsLabel' => 'Адреса надежных сайтов',
    'HotlinkProtection.success' => 'Настройки защиты от хотлинкинга были изменены.',

    'Odbc.add' => 'Добавить ODBC DSN',
    'Odbc.resourceUsage' => '%%used%% создано / %%allowed%% разрешено.',
    'Odbc.limitExceeded' => 'Превышен лимит соединений ODBC DSN.',
    'Odbc.unlimited' => 'Без ограничений',
    'Odbc.addTooltip' => 'Добавить источник данных в ODBC.',
    'Odbc.status' => 'Статус',
    'Odbc.name' => 'Имя соединения',
    'Odbc.driver' => 'Драйвер',
    'Odbc.description' => 'Описание соединения',
    'Odbc.hostname' => 'Имя хоста',
    'Odbc.statusSystem' => 'Это системный источник данных.',
    'Odbc.statusConfigured' => 'Источник данных настроен.',
    'Odbc.statusNotConfigured' => 'Источник данных не настроен.',
    'Odbc.noSelectionText' => 'Выберите один или несколько элементов для удаления.',
    'Odbc.removeConfirmation' => 'Удалить {count, plural, =1 {соединение {name} } one {# выбранное соединение} few {# выбранных соединения} other {# выбранных соединений}}?',
    'Odbc.removeSuccess' => 'Выбранные соединения удалены.',

    'DomainAliasSettings.title' => 'Настройки псевдонима домена',
    'DomainAliasSettings.updateSuccess' => 'Настройки псевдонима домена %%name%% изменены. %%apacheRestartInterval%%',
    'DomainAliasSettings.apacheRestartInterval' => 'Настройки сайта будут применены через %%restartInterval%% минут.',

    'Home.Backup.offStatus' => 'Некорректная резервная копия. Входящие в нее данные не подлежат восстановлению.',
    'Home.Backup.task-failedStatus' => 'Не выполнена задача резервного копирования.',
    'Home.Backup.activeSchedule' => 'Расписание: %%schedule%%',
    'Home.Backup.activeSchedules' => 'Расписания: %%schedules%%',
    'Home.Backup.noSchedule' => "Резервное копирование не настроено",
    'Home.Backup.period_hourly' => 'По часам %%schedule%%',
    'Home.Backup.period_daily' => 'Ежедневно %%schedule%%',
    'Home.Backup.period_weekly' => 'Еженедельно %%schedule%%',
    'Home.Backup.period_monthly' => 'Ежемесячно %%schedule%%',
    'Home.Backup.create' => 'Создать резервную копию',
    'Home.Backup.schedule' => 'Расписание',
    'Home.ChangeLog.seeHistory' => 'Посмотреть историю изменений',
    'Home.CustomButtons.add' => 'Добавить персональную кнопку',
    'Home.CustomButtons.noButtons' => 'Нет персональных кнопок',
    'Home.Customization.title' => 'Информационная панель',
    'Home.Customization.description' => 'Выберите нужные параметры',
    'Home.Customization.pleskSection' => 'Plesk',
    'Home.Customization.serverSection' => 'Сервер',
    'Home.Customization.securitySection' => 'Безопасность',
    'Home.Customization.backup' => 'Последняя резервная копия сервера',
    'Home.Customization.ipBan' => 'Блокировка IP-адресов',
    'Home.Customization.mailQueue' => 'Очередь почтовых сообщений',
    'Home.Customization.mySubscriptions' => 'Мои подписки',
    'Home.Customization.overusedSubscriptions' => 'Подписки с перерасходом',
    'Home.Customization.serverInfo' => 'Сведения о сервере',
    'Home.Customization.updates' => 'Обновления Plesk',
    'Home.Customization.promo' => 'Промо-баннер',
    'Home.Customization.changeLog' => 'Что нового',
    'Home.Customization.customButtons' => 'Персональные кнопки',
    'Home.Customization.drag' => 'Перетащите, чтобы переместить панель',
    'Home.EmptyView.title' => 'Получите максимум пользы от своей информационной панели, выбрав, что на ней будет отображаться.',
    'Home.EmptyView.titleLocked' => 'Информационная панель заблокирована вашим сервис-провайдером.',
    'Home.EmptyView.customize' => 'Настроить',
    'Home.Extension.title' => 'Расширение',
    'Home.IpBan.banned' => 'Заблокированные',
    'Home.IpBan.trusted' => 'Надежные',
    'Home.IpBan.more' => 'Подробнее',
    'Home.MailQueue.total' => 'Всего',
    'Home.MailQueue.deferred' => 'Отсроченные',
    'Home.MailQueue.held' => 'Отложенные',
    'Home.MailQueue.more' => 'Подробнее',
    'Home.MailQueue.clean' => 'Очистить очередь сообщений',
    'Home.MailQueue.checkLogs' => 'Проверить журналы',
    'Home.MailQueue.repair' => 'Исправить',
    'Home.MailQueue.cleanConfirmQuestion' => 'Очистить очередь сообщений?',
    'Home.MailQueue.cleanConfirmYes' => 'Да',
    'Home.MailQueue.cleanConfirmNo' => 'Нет',
    'Home.MailQueue.queueCleaned' => 'Очередь успешно очищена.',
    'Home.OverusedSubscriptions.empty' => 'Подписки с перерасходом не найдены',
    'Home.OverusedSubscriptions.usage' => '%%formattedUsed%% из %%formattedValue%%',
    'Home.OverusedSubscriptions.more' => 'Просмотреть все с перерасходом: [%%total%%]',
    'Home.OverusedSubscriptions.list' => 'Открыть в списке',
    'Home.PromoNewHomeView.title' => 'Добро пожаловать на новую домашнюю страницу!',
    'Home.PromoNewHomeView.description' => 'Если у вас возникнут проблемы, пожалуйста, сообщите нам. Это поможет нам при работе над дальнейшими улучшениями.',
    'Home.PromoNewHomeView.feedback' => 'Оставить отзыв',
    'Home.PromoNewHomeView.switch' => 'Вернуться к Домашней странице',
    'Home.ServerInfo.hostname' => 'Имя хоста',
    'Home.ServerInfo.copyHostname' => 'Копировать имя хоста',
    'Home.ServerInfo.ipAddress' => 'IP-адрес',
    'Home.ServerInfo.copyIpAddress' => 'Копировать IP-адрес',
    'Home.ServerInfo.publicIpAddress' => 'Внешний IP-адрес',
    'Home.ServerInfo.copyPublicIpAddress' => 'Копировать внешний IP-адрес',
    'Home.ServerInfo.os' => 'ОС',
    'Home.ServerInfo.copyOs' => 'Копировать ОС',
    'Home.ServerInfo.uptime' => 'Время непрерывной работы',
    'Home.ServerInfo.uptimeValue' => "{days, plural, =0 {} one {# день} few {# дня} many {# дней} other {# день}} {hours, plural, one {# час} few {# часа} many {# часов} other {# час}} {minutes, plural, one {# минута} few {# минуты} many {# минут} other {# минута}}",
    'Home.ServerInfo.more' => 'Подробнее',
    'Home.Subscriptions.add' => 'Добавить',
    'Home.Subscriptions.empty' => 'Создайте подписки для хостинга нескольких сайтов в рамках изолированного пространства на сервере. %%link%%',
    'Home.Subscriptions.help' => 'Подробнее',
    'Home.Updates.title' => 'Обновления продуктов',
    'Home.Updates.version' => '%%name%% %%version%%',
    'Home.Updates.patch' => '%%version%% с обновлением № %%patch%%',
    'Home.Updates.manageComponents' => 'Добавить или удалить компоненты',
    'Home.Updates.lastUpdated' => 'Последнее обновление: %%lastUpdateDate%%',
    'Home.Updates.checkUpdates' => 'Проверить наличие обновлений',
    'Home.Updates.enableAutoupdate' => 'Разрешить автоматические обновления',
    'Home.Updates.lastChecked' => 'Последняя проверка: %%lastCheckDate%%',
    'Home.Updates.newVersionAvailable' => 'Версия %%availableVersion%% доступна',
    'Home.Updates.installNewVersion' => 'Установить',
    'Home.Updates.patchAvailable' => 'Доступны промежуточные обновления',
    'Home.Updates.patchAvailableVersion' => 'Доступны промежуточные обновления для %%currentVersion%%',
    'Home.Updates.installPatch' => 'Обновить сейчас',
    'Home.Updates.pumUpdates' => '{total, select, 1 {Доступно обновление для {package}} other {Доступны обновления для {package}}}',
    'Home.Updates.pumPackage' => '%%name%% %%availableVersion%%',
    'Home.Updates.pumPackages' => '{total, plural, one {# пакет} few {# пакета} many {# пакетов} other {# пакетов}}',
    'Home.Updates.installUpdates' => '{total, select, 1 {Обновить сейчас} other {Обновить все}}',
    'Home.Promo.close' => 'Закрыть блок',
    'Home.Promo.viewSlide' => 'Просмотреть слайд %%slideNumber%%',
    'Home.Promo.Customize.title' => 'Персонализируйте свою информационную панель!',
    'Home.Promo.Customize.content' => 'На новой персонализированной информационной панели ваши избранные функции всегда у вас под рукой',
    'Home.Promo.Customize.action' => 'Настроить',
    'Home.Promo.SwitchToPuv.title' => 'Вы знаете о вариантах просмотра интерфейса в Plesk?',
    'Home.Promo.SwitchToPuv.content' => 'Если вы не предоставляете услуги хостинга своим клиентам по тарифным планам, возможно, вам подойдет интерфейс, который более удобен для управления сайтами, файлами сайтов, базами данных, учетными записями почты и веб-приложениями.',
    'Home.Promo.SwitchToPuv.action' => 'Попробовать',
    'Home.Status.error' => 'Ошибка',
    'Home.Status.warning' => 'Предупреждение',
    'Home.Status.info' => 'Информация',

    'HostingSettings.title' => 'Настройки хостинга',
    'HostingSettings.updateSuccess' => 'Настройки обновлены.',
    'HostingSettings.emptyLogin' => 'Вам нужно указать имя пользователя.',
    'HostingSettings.emptyPassword' => 'Вам нужно указать пароль.',
    'HostingSettings.ipV6OnlyNotSupported' => 'FTP-сервер не поддерживает IPv6. Предоставьте хотя бы один IPv4-адрес, иначе пользователь не сможет загружать файлы на сервер по FTP.',
    'HostingSettings.domainSettingsSection.sectionTitle' => 'Настройки домена',
    'HostingSettings.domainSettingsSection.domainName' => 'Имя домена',
    'HostingSettings.domainSettingsSection.description' => 'Например, example.com ',

    'HostingSettings.submitPopover.title' => 'Удалить содержимое из %%website%%',
    'HostingSettings.submitPopover.descriptionMainDomain' => 'Переключение типа хостинга «Сайт» на «%%type%%» навсегда удалит все содержимое сайта, включая следующие папки:',
    'HostingSettings.submitPopover.descriptionSubDomain' => 'Вы хотите изменить тип хостинга для своего сайта?',

    'HostingSettings.domainSettingsSection.creatingWebspaceAlert' => 'Чтобы получить доступ к другим настройкам, введите учетные данные системного пользователя и нажмите "Создать веб-пространство".',
    'HostingSettings.domainSettingsSection.creatingHostingAlert' => 'Чтобы получить доступ к другим настройкам, нажмите "Далее" для создания хостинга.',
    'HostingSettings.domainSettingsSection.hostingTypeTitle' => 'Тип хостинга',
    'HostingSettings.domainSettingsSection.hostingType.title' => 'Тип',
    'HostingSettings.domainSettingsSection.hostingType.website' => 'Сайт',
    'HostingSettings.domainSettingsSection.hostingType.forwarding' => 'Перенаправление',
    'HostingSettings.domainSettingsSection.hostingType.noHosting' => 'Нет веб-хостинга',
    'HostingSettings.domainSettingsSection.hostingType.noHostingHint' => 'Используйте зону DNS домена, чтобы пользоваться почтовыми ящиками с этим именем домена',
    'HostingSettings.domainSettingsSection.hostingType.pathToTheWebsite' => 'Путь к домашней папке этого сайта',
    'HostingSettings.domainSettingsSection.preferredDomainTitle' => 'Предпочтительный домен',
    'HostingSettings.domainSettingsSection.preferredDomainDescription' => 'Посетители будут перенаправлены сюда через перенаправление HTTP 301 для SEO.',
    'HostingSettings.domainSettingsSection.forwardVisitorsTo' => 'Перенаправлять посетителей на',
    'HostingSettings.domainSettingsSection.forwardingType.title' => 'Тип перенаправления',
    'HostingSettings.domainSettingsSection.forwardingType.movedPermanently' => 'Окончательно перенесен (код 301)',
    'HostingSettings.domainSettingsSection.forwardingType.movedPermanentlyDescription' => 'Перенаправлять посетителей на другой сайт и показывать им его адрес. Это позволит сохранить поисковый рейтинг сайта',
    'HostingSettings.domainSettingsSection.forwardingType.movedTemporarily' => 'Временно перенесен (код 302)',
    'HostingSettings.domainSettingsSection.forwardingType.movedTemporarilyDescription' => 'Перенаправлять посетителей на временный экземпляр сайта, если не хотите, чтобы он индексировался поисковыми системами.',
    'HostingSettings.domainSettingsSection.forwardingType.frameForwarding' => 'Перенаправление во фрейме',
    'HostingSettings.domainSettingsSection.forwardingType.frameForwardingDescription' => 'Перенаправлять посетителей веб-сайта на другой сайт, но не показывать им целевой адрес, чтобы они не знали о перенаправлении.',
    'HostingSettings.domainSettingsSection.preferredDomain.title' => 'Предпочтительный домен',
    'HostingSettings.domainSettingsSection.preferredDomain.none' => 'Нет',
    'HostingSettings.domainSettingsSection.preferredDomain.www' => 'www.%%domainName%%',
    'HostingSettings.domainSettingsSection.documentRootTitle' => 'Корневая папка',
    'HostingSettings.domainSettingsSection.documentRootHint' => 'Невозможно изменить корневую папку сайта, так как на сайте установлены веб-приложения.',
    'HostingSettings.domainSettingsSection.save' => 'Сохранить',
    'HostingSettings.domainSettingsSection.sameSsl.title' => 'Режим совместимости',
    'HostingSettings.domainSettingsSection.sameSsl.enabled' => 'Запустить сайт в режиме совместимости для опции "Разделять SSL/TLS и не-SSL/TLS содержимое"',
    'HostingSettings.domainSettingsSection.sameSsl.hint' => 'Этот сайт работает в режиме совместимости, и вы не можете управлять им через интерфейс Plesk. Это связано с тем, что до обновления вы использовали устаревшую опцию "Разделять SSL/TLS и не-SSL/TLS содержимое". Начиная с версии Plesk 11 сайты хранят контент, доступный по HTTP и HTTPS, в одной и той же папке. Мы рекомендуем перенести все ваши данные из папки httpsdocs/ в папку httpdocs/ и затем отключить режим совместимости. В результате этого приложения, установленные в папку httpsdocs/, станут доступными через Интернет. Обратите внимание, что после этого вы больше не сможете включить режим совместимости.',
    'HostingSettings.domainSettingsSection.security.secureSettingsDialogTitle' => 'Изменить эти настройки?',
    'HostingSettings.domainSettingsSection.security.secureSettingsDialogDescription' => 'Изменение этого параметра противоречит политике безопасности сервера и может снизить производительность или сделать сервер уязвимым для атак.',
    'HostingSettings.domainSettingsSection.security.buttonChange' => 'Изменить',
    'HostingSettings.domainSettingsSection.security.buttonRevert' => 'Отменить',
    'HostingSettings.domainSettingsSection.security.secureSettingsPresetApplied' => 'Применен пресет настроек безопасности',
    'HostingSettings.domainSettingsSection.security.secureSettingsPresetMessage' => 'Для повышения безопасности примените пресет настроек безопасности. Обратите внимание, что определенные разрешения позволяют подписчикам изменять эти настройки.',
    'HostingSettings.domainSettingsSection.security.applySecureSettingsPreset' => 'Применить пресет безопасности',
    'HostingSettings.domainSettingsSection.security.exploreSecureSettings' => 'Подробнее о настройках безопасности хостинга',
    'HostingSettings.domainSettingsSection.security.sslTlsSupport' => 'Поддержка SSL/TLS',
    'HostingSettings.domainSettingsSection.security.sslTlsSupportEnabled' => 'Включено',
    'HostingSettings.domainSettingsSection.security.sslTlsSupportDescription' => 'Зашифруйте соединения между сайтом и браузером посетителя.',
    'HostingSettings.domainSettingsSection.security.certificate' => 'Сертификат',
    'HostingSettings.domainSettingsSection.security.certificateDescription' => 'Чтобы включить HTTPS, загрузите сертификат SSL/TLS в репозиторий домена, а затем выберите его здесь.',
    'HostingSettings.domainSettingsSection.security.permanentRedirect' => 'Перенаправляйте посетителей с HTTP на HTTPS через переадресацию 301 для SEO',
    'HostingSettings.domainSettingsSection.security.noCertificates' => 'В вашем хранилище нет ни одного SSL/TLS-сертификата. Чтобы добавить сертификат, откройте %%link%%.',
    'HostingSettings.domainSettingsSection.security.noCertificatesLink' => 'эту страницу',
    'HostingSettings.domainSettingsSection.security.certificateFromDomainRepository' => '%%name%% (%%repository%%)',
    'HostingSettings.domainSettingsSection.security.certificateFromOtherRepository' => '%%name%% (другое хранилище)',
    'HostingSettings.domainSettingsSection.security.certificateNotSelected' => 'Не выбран',
    'HostingSettings.domainSettingsSection.webScripting.title' => 'Веб-скрипты',
    'HostingSettings.domainSettingsSection.webScripting.description' => 'Выберите, какие языки программирования и скриптов должны интерпретироваться веб-сервером.',
    'HostingSettings.domainSettingsSection.webScripting.fastCgi' => 'FastCGI',
    'HostingSettings.domainSettingsSection.webScripting.cgi' => 'CGI',
    'HostingSettings.domainSettingsSection.webScripting.cgiReadonly' => 'папка cgi-bin расположена в %%value%%',
    'HostingSettings.domainSettingsSection.webScripting.ssi' => 'SSI',
    'HostingSettings.domainSettingsSection.webScripting.ssiHtml' => 'Использовать SSI для файлов с расширениями *.htm, *.html',
    'HostingSettings.domainSettingsSection.webScripting.asp' => 'Microsoft ASP',
    'HostingSettings.domainSettingsSection.webScripting.aspDotNet' => 'Microsoft ASP.NET',
    'HostingSettings.domainSettingsSection.webScripting.aspDotNetVersion' => 'Версия Microsoft ASP.NET',
    'HostingSettings.domainSettingsSection.webScripting.perl' => 'Perl',
    'HostingSettings.domainSettingsSection.webScripting.python' => 'Python',
    'HostingSettings.domainSettingsSection.webScripting.customErrorDocuments' => 'Пользовательские страницы ошибок',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.title' => 'папка cgi-bin расположена в',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.wwwRoot' => 'корневая папка этого домена',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.webspace' => 'корневая папка веб-пространства',
    'HostingSettings.domainSettingsSection.webScripting.cgiMode.oldStyle' => 'корневая папка этого домена в устаревшем формате',
    'HostingSettings.domainSettingsSection.webScripting.errorDocs' => 'Пользовательские страницы ошибок',
    'HostingSettings.domainSettingsSection.webScripting.writeModify' => 'Дополнительные права на запись/редактирование',
    'HostingSettings.domainSettingsSection.webScripting.webDeploy' => 'Публикация с помощью инструмента веб-развертывания',
    'HostingSettings.domainSettingsSection.webStatistics.title' => 'Веб-статистика',
    'HostingSettings.domainSettingsSection.webStatistics.tool' => 'Инструмент',
    'HostingSettings.domainSettingsSection.webStatistics.webstatProtected' => 'Защитить доступ к веб-статистике именем пользователя и паролем FTP',
    'HostingSettings.domainSettingsSection.webStatistics.disabled' => 'Отключено',

    'HostingSettings.webspaceSettingsSection.sectionTitle' => 'Настройки веб-пространства',
    'HostingSettings.webspaceSettingsSection.ipAddresses' => 'IP-адреса',
    'HostingSettings.webspaceSettingsSection.quota.title' => 'Квота места на диске',
    'HostingSettings.webspaceSettingsSection.quota.enabled' => 'Включено',
    'HostingSettings.webspaceSettingsSection.quota.description' => 'Запретить операции с файлами сайта, если превышена квота дискового пространства, установленная в настройках подписки (если она есть).',
    'HostingSettings.webspaceSettingsSection.quota.unlimitedDesc' => 'Квота места на диске не поддерживается из-за настроек файловой системы сервера.',
    'HostingSettings.webspaceSettingsSection.quota.mbUnits' => 'Mб',
    'HostingSettings.webspaceSettingsSection.quota.readonly' => '%%quota%% Mб',
    'HostingSettings.webspaceSettingsSection.systemUser' => 'Учетные данные системного пользователя',
    'HostingSettings.webspaceSettingsSection.systemUserUnixDesc' => 'Управляйте файлами и папками сайта через FTP или менеджер файлов. Доступ к серверу через SSH, если он разрешен.',
    'HostingSettings.webspaceSettingsSection.systemUserWinDesc' => 'Управляйте файлами и папками сайта через FTP или менеджер файлов. Доступ к серверу через удаленный рабочий стол, если он разрешен.',
    'HostingSettings.webspaceSettingsSection.systemUserLogin' => 'Имя пользователя',
    'HostingSettings.webspaceSettingsSection.systemUserPasswd' => 'Пароль',
    'HostingSettings.webspaceSettingsSection.systemUserPasswdDesc' => 'Укажите здесь новый пароль, чтобы изменить пароль системного пользователя.',
    'HostingSettings.webspaceSettingsSection.shell.unixTitle' => 'Доступ по SSH',
    'HostingSettings.webspaceSettingsSection.shell.winTitle' => 'Доступ к удаленному рабочему столу',
    'HostingSettings.webspaceSettingsSection.shell.enabled' => 'Включено',
    'HostingSettings.webspaceSettingsSection.shell.description' => "Доступ к серверу с учетными данными системного пользователя.",
    'HostingSettings.webspaceSettingsSection.shell.type' => 'Тип',
    'HostingSettings.webspaceSettingsSection.shell.disabled' => 'Отключено',
    'HostingSettings.webspaceSettingsSection.affectedDomainsLabel' => 'Для {count, plural, one {# домена} few {# доменов} many {# доменов} other {# домена}}',
    'HostingSettings.webspaceSettingsSection.affectedDomainsDescription' => 'Следующие настройки распространяются на {count, plural, one {# домен в веб-пространстве {name}} few {# домена в веб-пространстве {name}} many {# доменов в веб-пространстве {name}} other {# домена в веб-пространстве {name}}}:',

    'OdbcAdd.title' => 'Добавить ODBC DSN',
    'OdbcAdd.nameLabel' => 'Имя соединения',
    'OdbcAdd.descriptionLabel' => 'Описание соединения',
    'OdbcAdd.driver' => 'Драйвер',
    'OdbcAdd.submit' => 'Создать ODBC DSN',

    'OdbcEdit.title' => 'Настроить ODBC-подключение',
    'OdbcEdit.saveSuccess' => 'Настройки соединения сохранены.',
    'OdbcEdit.test' => 'Проверить соединение',
    'OdbcEdit.connectSuccess' => 'Соединение выполнено успешно.',

    'OdbcEdit.excel.driver.label' => 'Драйвер',
    'OdbcEdit.excel.dbq.label' => 'Путь к файлу базы данных',
    'OdbcEdit.excel.defaultdir.label' => 'Папка с данными по умолчанию',
    'OdbcEdit.excel.fil.label' => 'Версия базы данных',
    'OdbcEdit.excel.maxbuffersize.label' => 'Макс. размер буфера',
    'OdbcEdit.excel.pagetimeout.label' => 'Время ожидания загрузки страницы',

    'OdbcEdit.access.driver.label' => 'Драйвер',
    'OdbcEdit.access.dbq.label' => 'Путь к файлу базы данных',
    'OdbcEdit.access.uid.label' => 'Идентификатор входа в систему',
    'OdbcEdit.access.pwd.label' => 'Пароль',
    'OdbcEdit.access.pagetimeout.label' => 'Время ожидания загрузки страницы',
    'OdbcEdit.access.pagetimeout.description' => 'Период времени в десятках секунд, в течение которого неиспользуемая страница оставалась в буфере. Эту опцию можно применить ко всем источникам данных, которые используют драйвер Microsoft Access.',
    'OdbcEdit.access.maxbuffersize.label' => 'Макс. размер буфера',
    'OdbcEdit.access.maxbuffersize.description' => 'Размер внутреннего буфера в килобайтах, скорректированный для границы 256 Кб',
    'OdbcEdit.access.readonly.label' => 'Только чтение',
    'OdbcEdit.access.readonly.description' => 'Назначает базу данных доступной только для чтения, чтобы запретить выполнение любых обновлений.',
    'OdbcEdit.access.exclusive.label' => 'Эксклюзивный',
    'OdbcEdit.access.exclusive.description' => 'Назначает базу данных эксклюзивной, чтобы запретить общий доступ к обновлению.',
    'OdbcEdit.access.safetransactions.label' => 'Безопасные транзакции',
    'OdbcEdit.access.safetransactions.description' => 'При значении, равном 0 (значение по умолчанию), все транзакции выполняются незамедлительно. При значении, равном 1, все транзакции сохраняются на диск только после выполнения операции, однако при этом немного снижается производительность.',
    'OdbcEdit.access.threads.label' => 'Потоки',
    'OdbcEdit.access.threads.description' => 'Количество фоновых потоков, которые могут быть созданы подсистемой.',
    'OdbcEdit.access.maxscanrows.label' => 'Макс. сканируемых строк',
    'OdbcEdit.access.maxscanrows.description' => 'Количество строк, для которых следует выполнить сканирование при установке типа данных в столбце на основании существующих данных.',
    'OdbcEdit.access.implicitcommitsync.label' => 'ImplicitCommitSync',
    'OdbcEdit.access.implicitcommitsync.description' => 'Указывает, каким образом изменения, сделанные без помощи транзакций, записаны в базу данных.',
    'OdbcEdit.access.usercommitsync.label' => 'UserCommitSync',
    'OdbcEdit.access.usercommitsync.description' => 'Указывает, будет ли драйвер MS Access выполнять асинхронно явным образом определенные пользователем транзакции.',

    'OdbcEdit.mssql.driver.label' => 'Драйвер',
    'OdbcEdit.mssql.server.label' => 'Сервер',
    'OdbcEdit.mssql.uid.label' => 'Идентификатор входа в систему',
    'OdbcEdit.mssql.pwd.label' => 'Пароль',
    'OdbcEdit.mssql.database.label' => 'База данных по умолчанию',
    'OdbcEdit.mssql.app.label' => 'Название приложения',
    'OdbcEdit.mssql.wsid.label' => 'ID рабочей станции',
    'OdbcEdit.mssql.language.label' => 'Язык по умолчанию',
    'OdbcEdit.mssql.oemtoansi.label' => 'Преобразование расширенных символов в OEM-значения',

    'OdbcEdit.mysql.driver.label' => 'Драйвер MySQL ODBC',
    'OdbcEdit.mysql.server.label' => 'Сервер',
    'OdbcEdit.mysql.server.description' => 'Имя хоста сервера MariaDB/MySQL',
    'OdbcEdit.mysql.database.label' => 'База данных по умолчанию',
    'OdbcEdit.mysql.user.label' => 'Имя пользователя',
    'OdbcEdit.mysql.user.description' => 'Имя пользователя для подключения к MariaDB/MySQL',
    'OdbcEdit.mysql.password.label' => 'Пароль',
    'OdbcEdit.mysql.password.description' => 'Пароль для учетной записи пользователя на сервере',
    'OdbcEdit.mysql.port.label' => 'Порт',
    'OdbcEdit.mysql.port.description' => 'Порт TCP/IP, который следует использовать, если сервер не является локальным хостом',
    'OdbcEdit.mysql.socket.label' => 'Сокет',
    'OdbcEdit.mysql.socket.description' => 'Канал с именем Windows для подключения в случае, если сервер не является локальным хостом',
    'OdbcEdit.mysql.option.label' => 'Опция',
    'OdbcEdit.mysql.option.description' => 'Опции, определяющие, как должен работать MyODBC. Ознакомьтесь с <a target="_blank" href="https://www.linuxtopia.org/online_books/database_guides/mysql_5.1_database_reference_guide_OLD/connection-parameters.html">документацией</a>.',

    'ProtectedDirectoryList.add' => 'Добавить защищенную папку',
    'ProtectedDirectoryList.addTooltip' => 'Создать защищенную папку.',
    'ProtectedDirectoryList.name' => 'Имя',
    'ProtectedDirectoryList.realmTitle' => 'Название защищенного раздела',
    'ProtectedDirectoryList.noSelectionText' => 'Выберите один или несколько элементов для удаления.',
    'ProtectedDirectoryList.edit' => 'Изменить',
    'ProtectedDirectoryList.remove' => 'Снять защиту',
    'ProtectedDirectoryList.removeTooltip' => 'Снять защиту с выбранных папок.',
    'ProtectedDirectoryList.removeConfirmation' => 'Эта операция приведет к снятию защиты {count, plural, =1 {с папки {name}} few {с # выбранных папок} many {с # выбранных папок} other {с # выбранной папки}}. {count, plural, =1 {Эта папка станет доступна} other {Эти папки станут доступны}} всем пользователям Интернета.',
    'ProtectedDirectoryList.removeSuccess' => 'Выбранные папки удалены.',

    'ProtectedDirectoryAdd.title' => 'Создать защищенную папку',
    'ProtectedDirectoryAdd.submit' => 'Создать',
    'ProtectedDirectoryAdd.success' => 'Защищенная папка %%path%% была успешно создана',

    'ProtectedDirectoryEdit.title' => 'Настройки защищенной папки',
    'ProtectedDirectoryEdit.success' => 'Настройки защищенной папки были изменены',

    'ProtectedDirectoryUserAdd.title' => 'Создать пользователя защищенной папки',
    'ProtectedDirectoryUserAdd.subtitle' => 'Папка %%directory%%',
    'ProtectedDirectoryUserAdd.loginLabel' => 'Имя пользователя',
    'ProtectedDirectoryUserAdd.passwordLabel' => 'Пароль',
    'ProtectedDirectoryUserAdd.submit' => 'Создать',
    'ProtectedDirectoryUserAdd.success' => 'Пользователь защищенной папки %%login%% создан.',

    'ProtectedDirectoryUserPassword.title' => 'Пароль пользователя защищенной папки',
    'ProtectedDirectoryUserPassword.subtitle' => 'Пользователь %%login%%',
    'ProtectedDirectoryUserPassword.passwordLabel' => 'Пароль',
    'ProtectedDirectoryUserPassword.submit' => 'Сохранить',
    'ProtectedDirectoryUserPassword.success' => 'Учетные данные пользователя сохранены.',

    'SummaryReport.Layout.title' => 'Свойства шаблона отчета',
    'SummaryReport.Layout.success' => 'Шаблон отчета %%name%% был обновлен.',

    'SummaryReport.Layout.Add.title' => 'Создать шаблон отчета',
    'SummaryReport.Layout.Add.success' => 'Шаблон отчета %%name%% был создан.',

    'SummaryReport.Report.buttonLayouts' => 'Шаблоны',
    'SummaryReport.Report.buttonSchedule' => 'Расписание',
    'SummaryReport.Report.buttonProperties' => 'Свойства',
    'SummaryReport.Report.buttonTrafficHistory' => 'Статистика по трафику',
    'SummaryReport.Report.buttonPrint' => 'Печатать',
    'SummaryReport.Report.buttonSend' => 'Отправить по почте',
    'SummaryReport.Report.successSent' => 'Отчет отправлен по адресу %%email%%',

    'SummaryReport.Schedule.Properties.title' => 'Расписание доставки на %%name%%',
    'SummaryReport.Schedule.Properties.success' => 'Расписание доставки отчетов было обновлено.',

    'SummaryReport.Schedule.Add.title' => 'Создать расписания доставки для %%name%%',
    'SummaryReport.Schedule.Add.success' => 'Расписание доставки отчетов было создано.',

    'VirtualDirectory.errNotExist' => 'Эта виртуальная папка привязана к несуществующей физической папке.',
    'VirtualDirectory.errNoPermissions' => 'Вам запрещено просматривать содержимое этой папки.',
    'VirtualDirectory.tabBrowse' => 'Папки',
    'VirtualDirectory.tabBrowseHint' => 'Управление физическими и виртуальными файлами и папками на сайте %%site%%.',
    'VirtualDirectory.tabMimeTypes' => 'Типы MIME',
    'VirtualDirectory.tabMimeTypesHint' => 'Управление зарегистрированными типами MIME.',
    'VirtualDirectory.tabErrorDocs' => 'Страницы ошибок',
    'VirtualDirectory.tabErrorDocsHint' => 'Управление страницами ошибок.',
    'VirtualDirectory.tabProtection' => 'Защита',
    'VirtualDirectory.tabProtectionHint' => 'Ограничить доступ к папке с помощью пароля.',

    'VirtualDirectory.errorDocType.default' => 'По умолчанию',
    'VirtualDirectory.errorDocType.file' => 'Файл',
    'VirtualDirectory.errorDocType.url' => 'URL-адрес',

    'VirtualDirectory.Sidebar.buttonProperties' => 'Свойства папки',
    'VirtualDirectory.Sidebar.buttonPropertiesHint' => 'Просмотреть и изменить свойства виртуальной папки.',
    'VirtualDirectory.Sidebar.buttonPermissions' => 'Права доступа к папке',
    'VirtualDirectory.Sidebar.buttonPermissionsHint' => 'Настроить права доступа к папке.',
    'VirtualDirectory.Sidebar.buttonAspDotNet' => 'ASP.NET',
    'VirtualDirectory.Sidebar.buttonAspDotNetHint' => 'Измените настройки ASP.NET.',
    'VirtualDirectory.Sidebar.buttonPhp' => 'PHP',
    'VirtualDirectory.Sidebar.buttonPhpHint' => 'Измените настройки PHP.',

    'VirtualDirectory.CreateDirectory.title' => 'Создать папку',
    'VirtualDirectory.CreateDirectory.name' => 'Имя папки',
    'VirtualDirectory.CreateDirectory.success' => 'Папка %%name%% была создана.',
    'VirtualDirectory.CreateDirectory.errExists' => 'Папка %%name%% уже существует.',

    'VirtualDirectory.CreateVirtualDirectory.title' => 'Создать виртуальную папку',
    'VirtualDirectory.CreateVirtualDirectory.success' => 'Папка %%name%% была создана.',

    'VirtualDirectory.EditVirtualDirectory.title' => 'Свойства виртуальной папки',
    'VirtualDirectory.EditVirtualDirectory.success' => 'Виртуальная папка была изменена.',
    'VirtualDirectory.EditVirtualDirectory.close' => 'Закрыть',

    'VirtualDirectory.MimeTypeList.add' => 'Добавить тип MIME',
    'VirtualDirectory.MimeTypeList.edit' => 'Изменить свойства типа MIME',
    'VirtualDirectory.MimeTypeList.addHint' => 'Зарегистрировать новый тип MIME.',
    'VirtualDirectory.MimeTypeList.columnExtension' => 'Расширение',
    'VirtualDirectory.MimeTypeList.columnContent' => 'Содержимое',
    'VirtualDirectory.MimeTypeList.noSelectionText' => 'Выберите один или несколько элементов для удаления.',
    'VirtualDirectory.MimeTypeList.removeConfirmation' => 'Удалить {count, plural, =1 {выбранный тип MIME} one {# выбранный тип MIME} few {# выбранных типа MIME} other {# выбранных типов MIME}}?',
    'VirtualDirectory.MimeTypeList.removeSuccess' => 'Выбранные типы MIME были удалены.',

    'VirtualDirectory.CreateMimeType.title' => 'Добавить тип MIME',
    'VirtualDirectory.CreateMimeType.success' => 'Новый тип MIME был зарегистрирован.',

    'VirtualDirectory.EditMimeType.title' => 'Изменить свойства типа MIME',
    'VirtualDirectory.EditMimeType.success' => 'Тип MIME был изменен.',

    'VirtualDirectory.ErrorDocList.columnCode' => 'Ошибка',
    'VirtualDirectory.ErrorDocList.columnName' => 'Описание',
    'VirtualDirectory.ErrorDocList.columnType' => 'Тип',
    'VirtualDirectory.ErrorDocList.columnLocation' => 'Расположение',
    'VirtualDirectory.ErrorDocList.edit' => 'Изменить',

    'VirtualDirectory.EditErrorDoc.title' => 'Редактирование страницы ошибки',
    'VirtualDirectory.EditErrorDoc.success' => 'Страница ошибки изменена.',

    'VirtualDirectory.EditErrorDoc.EditErrorDocForm.error' => 'Ошибка',
    'VirtualDirectory.EditErrorDoc.EditErrorDocForm.type' => 'Тип',
    'VirtualDirectory.EditErrorDoc.EditErrorDocForm.location' => 'Расположение',

    'VirtualDirectory.Protection.notSupported' => 'Защита папки не поддерживается для этой папки, так как ее имя длиннее 245 символов или содержит неподдерживаемые символы.',
    'VirtualDirectory.Protection.NoProtectionView.title' => 'Защита виртуальной папки отключена',
    'VirtualDirectory.Protection.NoProtectionView.protect' => 'Защитить',
    'VirtualDirectory.Protection.NoProtectionView.successProtection' => 'Папка %%path%% была защищена.',
    'VirtualDirectory.Protection.tools' => 'Инструменты',
    'VirtualDirectory.Protection.removeProtection' => 'Снять защиту',
    'VirtualDirectory.Protection.removeProtectionTooltip' => 'Сделать URL папки доступным для всех.',
    'VirtualDirectory.Protection.removeProtectionConfirmation' => 'Отключить защиту виртуальной папки? Это приведет к удалению всех пользователей защищенной папки и ее настроек защиты.',
    'VirtualDirectory.Protection.settings' => 'Настройки',
    'VirtualDirectory.Protection.settingsTooltip' => 'Посмотреть расположение папки и указать название защищенного раздела.',

    'VirtualDirectory.AspDotNet.title' => 'Изменить настройки ASP.NET',

    'VirtualDirectory.Php.title' => 'Версия PHP',
    'VirtualDirectory.Php.version' => 'Версия',
    'VirtualDirectory.Php.success' => 'Версия PHP обновлена.',


    'MassMailPage.sendEmail' => 'Отправить групповое сообщение',
    'MassMailPage.selectAtLeastOneTemplate' => 'Выберите хотя бы один шаблон',
    'MassMailPage.confirmRemoval' => 'Вы уверены, что хотите удалить {count, select, 1 {выбранный шаблон} other {выбранные шаблоны}}?',
    'MassMailPage.remove' => 'Удалить',
    'MassMailPage.filters' => 'Фильтры',
    'MassMailPage.name' => 'Название шаблона',
    'MassMailPage.sender' => 'Отправитель',
    'MassMailPage.recipients' => 'Получатели',
    'MassMailPage.subject' => 'Тема',
    'MassMailPage.created' => 'Дата создания',
    'MassMailPage.send' => 'Отправить',
    'MassMailPage.recipientsNone' => 'Нет',
    'MassMailPage.recipientsAdmins' => 'Администратор',
    'MassMailPage.recipientsResellers' => 'Все реселлеры',
    'MassMailPage.recipientsResellersSelected' => 'Выбранные реселлеры',
    'MassMailPage.recipientsResellersExcept' => 'Все реселлеры, кроме выбранных',
    'MassMailPage.recipientsClients' => 'Все клиенты',
    'MassMailPage.recipientsClientsSelected' => 'Выбранные клиенты',
    'MassMailPage.recipientsClientsExcept' => 'Все клиенты, кроме выбранных',
    'MassMailPage.templatesRemoved' => '{count, select, 1 {Шаблон удален} other {Шаблоны удалены}}.',
    'MassMailPage.emptyViewTitle' => 'Нет шаблонов сообщений почтовых рассылок',
    'MassMailPage.addNew' => 'Создание шаблона',
    'CreateMassMailTemplatePage.templateCreated' => 'Шаблон был создан.',
    'EditMassMailTemplatePage.templateUpdated' => 'Шаблон был обновлен.',
    'SendMassMailPage.emailSent' => 'Сообщение отправлено.',
    'SendMassMailPage.fieldIsRequired' => 'Поле не может быть пустым',
    'SendMassMailPage.saveAsTemplate' => 'Сохранить составленное сообщение как новый шаблон',
    'SendMassMailPage.newTemplateName' => 'Имя нового шаблона',
    'SendMassMailPage.selectedTemplate' => 'Выбранный шаблон',
    'SendMassMailPage.send' => 'Отправить',
    'VirtualHostTemplatePage.name' => 'Имя',
    'VirtualHostTemplatePage.sizeInBytes' => 'Размер',
    'VirtualHostTemplatePage.modified' => 'Дата изменения',
    'VirtualHostTemplatePage.permissions' => 'Права',
    'VirtualHostTemplatePage.user' => 'Пользователь',
    'VirtualHostTemplatePage.group' => 'Группа',
    'VirtualHostTemplatePage.uploadTemplate' => 'Загрузить',
    'VirtualHostTemplatePage.succesfullyUploaded' => 'Шаблон загружен.',
    'VirtualHostTemplatePage.root' => 'Виртуальный шаблон',
    'VirtualHostTemplatePage.emptyViewTitle' => 'В шаблоне нет файлов',
    'VirtualHostTemplatePage.total' => 'Всего элементов в папке {breadcrumbs}: {total}',
    'VirtualHostTemplatePage.resetTemplate' => 'Восстановить по умолчанию',
    'VirtualHostTemplatePage.successfullyReset' => 'Шаблон был изменен на шаблон по умолчанию.',

    'TrafficUsageByDomain.List.service' => 'Служба',
    'TrafficUsageByDomain.List.usage' => 'Используется',
    'TrafficUsageByDomain.List.incoming' => 'Входящие',
    'TrafficUsageByDomain.List.outgoing' => 'Исходящие',
    'TrafficUsageByDomain.List.percentOfAll' => '% от всего',

    'TrafficUsageByDomains.Viewer.List.domainName' => 'Имя домена',
    'TrafficUsageByDomains.Viewer.List.clientName' => "Имя владельца",
    'TrafficUsageByDomains.Viewer.List.totalUsage' => 'Используется',
    'TrafficUsageByDomains.Viewer.List.subscriptionLimit' => 'Ограничение',
    'TrafficUsageByDomains.Viewer.List.subscriptionLimitRemaining' => 'Доступно',
    'TrafficUsageByDomains.Viewer.List.subscriptionLimitUsagePercent' => 'Используется (в %)',
    'TrafficUsageByDomains.Viewer.Filters.ownOnly' => 'Только мои домены',
    'TrafficUsageByDomains.Viewer.Filters.resellerOnly' => 'Только домены реселлера',
    'TrafficUsageByDomains.Viewer.Filters.clientName' => 'Имя владельца',

    'TrafficUsageByReseller.emptyView' => 'У реселлера нет клиентов',
    'TrafficUsageByReseller.TotalUsage.usageByResellerDomains' => '%%resellerDomainsLink%%: %%usage%%',
    'TrafficUsageByReseller.TotalUsage.resellerDomains' => "Собственные домены реселлера",
    'TrafficUsageByReseller.TotalUsage.usageByCustomerDomains' => "Домены клиентов реселлера: %%usage%%",

    'InfoAndStatistics.Main.title' => 'Информация и статистика',
    'InfoAndStatistics.Main.overview' => 'Обзор',
    'InfoAndStatistics.Main.domains' => 'Домены',
    'InfoAndStatistics.Main.trafficUsage' => 'Использование трафика',
    'InfoAndStatistics.Main.reports' => 'Отчеты',
    'InfoAndStatistics.Main.serverSettings' => 'Настройки сервера',
    'InfoAndStatistics.TrafficUsage.customers' => 'Клиенты',
    'InfoAndStatistics.TrafficUsage.resellers' => 'Реселлеры',
    'InfoAndStatistics.TrafficUsage.domains' => 'Домены',

    'ConfigureMailClient.title' => 'Выберите свой почтовый клиент',
    'ConfigureMailClient.description' => 'для автоматической настройки %%email%%',
    'ConfigureMailClient.thunderbird' => 'Thunderbird',
    'ConfigureMailClient.manual' => 'Вручную',
    'ConfigureMailClient.Common.email' => 'Электронная почта:',
    'ConfigureMailClient.Common.start' => 'Запустить',
    'ConfigureMailClient.Common.finish' => 'Закончить',
    'ConfigureMailClient.Common.next' => 'Далее',
    'ConfigureMailClient.Common.prev' => 'Назад',
    'ConfigureMailClient.Common.back' => 'Назад',
    'ConfigureMailClient.Common.manualLink' => 'Возникли проблемы с добавлением учетной записи почты? Выполните настройку вручную.',
    'ConfigureMailClient.Thunderbird.title' => 'Настройка учетной записи почты',
    'ConfigureMailClient.Thunderbird.description' => 'Следуйте инструкциям ниже, чтобы добавить свою учетную запись почты в Mozilla Thunderbird.',
    'ConfigureMailClient.Thunderbird.step1.title' => 'Откройте Thunderbird',
    'ConfigureMailClient.Thunderbird.step1.description' => 'Откройте приложение Thunderbird на компьютере и выберите "Параметры учётной записи" в главном меню Thunderbird.',
    'ConfigureMailClient.Thunderbird.step2.title' => 'Добавьте учетную запись',
    'ConfigureMailClient.Thunderbird.step2.description' => 'Нажмите "Действия для учётной записи" и выберите "Добавить учётную запись почты".',
    'ConfigureMailClient.Thunderbird.step3.title' => 'Укажите свои учетные данные',
    'ConfigureMailClient.Thunderbird.step3.description' => 'Введите имя, которое будет отображаться в качестве отправителя во всех отсылаемых вами сообщениях. Укажите также свой адрес электронной почты и пароль, а затем нажмите "Продолжить".',
    'ConfigureMailClient.Thunderbird.step4.title' => 'Готово!',
    'ConfigureMailClient.Thunderbird.step4.description' => 'Thunderbird сейчас попытается автоматически добавить вашу учетную запись почты.',

    'ConfigureMailClient.Outlook.title' => 'Настройка учетной записи почты',
    'ConfigureMailClient.Outlook.warning' => 'Мы не можем автоматически добавить вашу учетную запись почты в Outlook 2019 и более поздние версии.',
    'ConfigureMailClient.Outlook.warningTooltip' => 'Мы используем функцию автообнаружения для автоматического добавления учетных записей почты. Outlook 2019 и более поздние версии для запросов автообнаружения используют прокси-серверы Microsoft, которые не поддерживаются в Plesk расширением Plesk Premium Email.',
    'ConfigureMailClient.Outlook.description' => 'Следуйте инструкциям, чтобы добавить свою учетную запись почты в Microsoft Office Outlook 2016.',
    'ConfigureMailClient.Outlook.step1.title' => 'Добавьте новую учетную запись',
    'ConfigureMailClient.Outlook.step1.description' => 'Откройте Outlook 2016 на компьютере и перейдите на вкладку "Файл".',
    'ConfigureMailClient.Outlook.step2.title' => 'Добавьте новую учетную запись',
    'ConfigureMailClient.Outlook.step2.description' => 'Нажмите "Добавить учетную запись".',
    'ConfigureMailClient.Outlook.step3.title' => 'Укажите адрес электронной почты',
    'ConfigureMailClient.Outlook.step3.description' => 'Введите свой адрес электронной почты.',
    'ConfigureMailClient.Outlook.step4.title' => 'Укажите пароль',
    'ConfigureMailClient.Outlook.step4.description' => 'Введите пароль своей учетной записи электронной почты и нажмите "Подключить".',
    'ConfigureMailClient.Outlook.step5.title' => 'Готово!',
    'ConfigureMailClient.Outlook.step5.description' => 'Нажмите "ОК", чтобы завершить настройку своей учетной записи.',

    'ConfigureMailClient.Outlook365.title' => 'Настройка учетной записи почты',
    'ConfigureMailClient.Outlook365.warning' => 'Мы не можем автоматически добавить вашу учетную запись почты в Outlook 2019 и более поздние версии.',
    'ConfigureMailClient.Outlook365.warningTooltip' => 'Мы используем функцию автообнаружения для автоматического добавления учетных записей почты. Outlook 2019 и более поздние версии для запросов автообнаружения используют прокси-серверы Microsoft, которые не поддерживаются в Plesk расширением Plesk Premium Email.',
    'ConfigureMailClient.Outlook365.description' => 'Следуйте инструкциям, чтобы добавить свою учетную запись почты в Microsoft Outlook 365.',
    'ConfigureMailClient.Outlook365.step1.title' => 'Добавьте новую учетную запись',
    'ConfigureMailClient.Outlook365.step1.description' => 'Откройте Outlook 365 на компьютере. Если вы еще не настроили учетную запись электронной почты в Outlook 365, введите свой адрес на странице мастера настройки.',
    'ConfigureMailClient.Outlook365.step2.title' => 'Добавьте новую учетную запись',
    'ConfigureMailClient.Outlook365.step2.description' => 'Выберите IMAP в качестве провайдера электронной почты. Введите свой пароль, используйте рекомендуемые настройки и затем нажмите «Продолжить».',
    'ConfigureMailClient.Outlook365.step3.title' => 'Укажите адрес электронной почты',
    'ConfigureMailClient.Outlook365.step3.description' => 'Подтвердите синхронизацию своей учетной записи IMAP и дождитесь завершения настройки.',
    'ConfigureMailClient.Outlook365.step4.title' => 'Добавление других учетных записей',
    'ConfigureMailClient.Outlook365.step4.description' => 'Чтобы добавить другие учетные записи электронной почты в Outlook 365, нажмите «Добавить учетную запись».',
    'ConfigureMailClient.Outlook365.step5.title' => 'Готово!',
    'ConfigureMailClient.Outlook365.step5.description' => 'Повторите указанные выше шаги, чтобы добавить новую учетную запись.',

    'ConfigureMailClient.Gmail.title' => 'Настройка учетной записи почты',
    'ConfigureMailClient.Gmail.description' => 'Следуйте инструкциям, чтобы добавить свою учетную запись почты в приложение Gmail на мобильном устройстве.',
    'ConfigureMailClient.Gmail.step1.title' => 'Добавьте новую учетную запись',
    'ConfigureMailClient.Gmail.step1.description1' => 'Откройте приложение Gmail на телефоне Android. В правом верхнем углу нажмите изображение своего профиля.',
    'ConfigureMailClient.Gmail.step1.description2' => 'Нажмите "Добавить аккаунт".',
    'ConfigureMailClient.Gmail.step1.description3' => 'Нажмите "Другой".',
    'ConfigureMailClient.Gmail.step2.title' => 'Укажите адрес электронной почты',
    'ConfigureMailClient.Gmail.step2.description' => 'Введите свой адрес электронной почты и нажмите "Далее".',
    'ConfigureMailClient.Gmail.step3.title' => 'Выберите тип учетной записи',
    'ConfigureMailClient.Gmail.step3.description' => 'Чтобы хранить копии загруженных писем на сервере, выберите "Личный (IMAP)". Чтобы удалять загруженные письма с сервера, выберите "Личный (POP3)".',
    'ConfigureMailClient.Gmail.step4.title' => 'Укажите пароль',
    'ConfigureMailClient.Gmail.step4.description' => 'Введите пароль своей учетной записи почты и нажмите "Далее".',
    'ConfigureMailClient.Gmail.step5.title' => 'Настройки удаления почты',
    'ConfigureMailClient.Gmail.step5.description' => 'Выберите, требуется ли удалять письма с сервера при удалении их в приложении, и нажмите "Далее".',
    'ConfigureMailClient.Gmail.step6.title' => 'Параметры учетной записи',
    'ConfigureMailClient.Gmail.step6.description1' => 'Приложение автоматически получит настройки сервера исходящей почты.',
    'ConfigureMailClient.Gmail.step6.description2' => 'При необходимости измените параметры по умолчанию для учетной записи и нажмите "Далее".',
    'ConfigureMailClient.Gmail.step7.title' => 'Готово!',
    'ConfigureMailClient.Gmail.step7.description1' => '(Необязательно) Укажите имя, которое будет отображаться в качестве отправителя во всех отсылаемых вами сообщениях.',
    'ConfigureMailClient.Gmail.step7.description2' => 'Нажмите "Далее", чтобы завершить настройку своей учетной записи.',

    'ConfigureMailClient.Ios.title' => 'Настройка учетной записи почты',
    'ConfigureMailClient.Ios.description' => 'Отсканируйте QR-код или откройте ссылку ниже на устройстве iOS, чтобы автоматически добавить свою учетную запись почты в приложение iOS Mail.',
    'ConfigureMailClient.Ios.link'  =>  'Добавить учетную запись в iOS Mail',

    'ConfigureMailClient.Manual.title' => 'Настройка учетной записи почты вручную',
    'ConfigureMailClient.Manual.description' => 'Используйте следующие данные, чтобы добавить %%email%% в свой почтовый клиент.',
    'ConfigureMailClient.Manual.username' => 'Имя пользователя почтового сервера:',
    'ConfigureMailClient.Manual.outgoingServer' => 'Сервер исходящей почты (требуется авторизация):',
    'ConfigureMailClient.Manual.incomingServer' => 'Сервер входящих сообщений:',
    'ConfigureMailClient.Manual.supportedIncomingProtocols' => 'Поддерживаемые протоколы входящей почты:',
    'ConfigureMailClient.Manual.supportedOutgoingProtocols' => 'Поддерживаемые протоколы исходящей почты:',


    'Databases.Page.title' => 'Базы данных для %%database%%',
    'Databases.Page.databaseTab' => 'Базы данных',
    'Databases.Page.userTab' => 'Управление пользователями',
    'Databases.Page.serversLink' => 'Серверы баз данных',
    'Databases.Page.backupLink' => 'Менеджер резервного копирования',

    'Databases.List.add' => 'Добавить базу данных',
    'Databases.List.find' => 'Найти базу данных...',
    'Databases.List.databaseColumn' => 'База данных',
    'Databases.List.relatedToColumn' => 'Относятся к',
    'Databases.List.relatedToDomains' => 'Относящиеся к %%domains%%',
    'Databases.List.noRelatedDomains' => 'Назначить эту базу данных сайту',
    'Databases.List.noDomainRelations' => 'Нет соответствующих сайтов',
    'Databases.List.openWebAdmin' => 'phpMyAdmin',
    'Databases.List.changeRelatedDomain' => 'Изменить',
    'Databases.List.connectionInfo' => 'Информация о подключении',
    'Databases.List.downloadDump' => 'Экспортировать дамп',
    'Databases.List.uploadDump' => 'Импортировать дамп',
    'Databases.List.copy' => 'Копировать базу данных',
    'Databases.List.checkDatabase' => 'Проверить и исправить',
    'Databases.List.assignToSubscription' => 'Перенести в подписку',
    'Databases.List.assignToSubscription_powerUser' => 'Перенести в веб-пространство',
    'Databases.List.remove' => 'Удалить',
    'Databases.List.removeConfirmation' => 'Удалить базу данных %%name%%?',
    'Databases.List.removeButtonDisabledHint' => 'База данных не может быть удалена, так как она используется установленным веб-приложением.',
    'Databases.List.databaseRemoved' => 'База данных удалена.',
    'Databases.List.downloadMsSqlClient' => 'Скачайте локальный SQL-клиент',
    'Databases.List.downloadMsSqlClientHint' => 'Скачайте локальный SQL-клиент',
    'Databases.List.webadmin' => 'Веб-администратор',
    'Databases.List.webadminHint' => 'Войдите на этот сервер через веб-администратор базы данных.',
    'Databases.List.dumpSubscriptionIsTurnedOff' => 'Невозможно %%action%% дамп: подписка приостановлена.',
    'Databases.List.dumpExport' => 'экспортировать',
    'Databases.List.dumpImport' => 'импортировать',
    'Databases.List.copyDatabaseName' => 'Скопировать имя базы данных',
    'Databases.List.copySuccess' => 'Имя %%name%% скопировано в буфер обмена',

    'Databases.DatabaseSummary.host' => 'Хост',
    'Databases.DatabaseSummary.serverUnavailable' => 'Недоступен сервер.',
    'Databases.DatabaseSummary.user' => 'Пользователь',
    'Databases.DatabaseSummary.users' => 'Пользователи',
    'Databases.DatabaseSummary.noUser' => 'Нет пользователей баз данных',
    'Databases.DatabaseSummary.seeAll' => 'показать все',
    'Databases.DatabaseSummary.createUser' => 'Создать пользователя',
    'Databases.DatabaseSummary.calculatingSize' => 'Подсчитывается размер...',
    'Databases.DatabaseSummary.tablesCount' => 'Таблицы',
    'Databases.DatabaseSummary.size' => 'Размер',

    'Databases.InPlaceSelect.editButtonHint' => 'Изменить',
    'Databases.InPlaceSelect.saveButtonHint' => 'Сохранить',
    'Databases.InPlaceSelect.closeButtonHint' => 'Отмена',
    'Databases.InPlaceSelect.selectWebsiteAriaLabel' => 'выбрать сайт',

    'Databases.ConnectionInfo.title' => 'Параметры соединения',
    'Databases.ConnectionInfo.description' => 'для базы данных %%database%%',
    'Databases.ConnectionInfo.hint' => 'Вы можете использовать эти параметры соединения с базой данных, например, при установке веб-приложения.',
    'Databases.ConnectionInfo.host' => 'Хост',
    'Databases.ConnectionInfo.copyHost' => 'Скопировать хост в буфер обмена',
    'Databases.ConnectionInfo.databaseName' => 'Имя базы данных',
    'Databases.ConnectionInfo.copyDatabaseName' => 'Скопировать имя базы данных в буфер обмена',
    'Databases.ConnectionInfo.user' => 'Имя пользователя',
    'Databases.ConnectionInfo.copyUser' => 'Скопировать имя пользователя в буфер обмена',
    'Databases.ConnectionInfo.password' => 'Пароль',
    'Databases.ConnectionInfo.noDefaultUser' => 'Не назначено пользователя по умолчанию',

    'Databases.Add.title' => 'Добавить базу данных',
    'Databases.Add.name' => 'Имя базы данных',
    'Databases.Add.server' => 'Сервер баз данных',
    'Databases.Add.versionCut' => 'версия %%version%%',
    'Databases.Add.relatedDomain' => 'Соответствующий сайт',
    'Databases.Add.noDomainRelations' => 'Нет соответствующих сайтов',
    'Databases.Add.userSection' => 'Пользователи',
    'Databases.Add.userSectionDescription' => 'Создайте пользователя базы данных по умолчанию. Это пользователь, от лица которого Plesk будет подключаться к базе данных. Если базе данных не назначить ни одного пользователя, она будет недоступна.',
    'Databases.Add.createUser' => 'Создать пользователя базы данных',
    'Databases.Add.username' => 'Имя пользователя базы данных',
    'Databases.Add.password' => 'Пароль',
    'Databases.Add.passwordConfirmation' => 'Подтверждение пароля',
    'Databases.Add.allDbAccess' => 'Пользователь имеет доступ ко всем базам данных выбранной подписки',
    'Databases.Add.aclRadio' => 'Управление доступом',
    'Databases.Add.aclLocalhost' => 'Разрешить только локальные подключения',
    'Databases.Add.aclAny' => 'Разрешить удаленные подключения с любого компьютера',
    'Databases.Add.aclCustom' => 'Разрешить удаленные подключения с указанных компьютеров',
    'Databases.Add.aclExample' => "thomas.loc.gov\n%.loc.gov\nx.y.%\n144.155.166.177\n144.155.166.%\n144.155.166.0/255.255.255.0\n\nУказанным здесь компьютерам разрешено подключаться к базе данных от лица этого пользователя.",
    'Databases.Add.aclHostsLabel' => 'Введите имена хостов или IP-адреса удаленных серверов, которым разрешен доступ',
    'Databases.Add.remoteAccess' => 'Удаленный доступ',
    'Databases.Add.remoteAccessDenied' => 'Использовать правила системного брандмауэра',
    'Databases.Add.remoteAccessAllowed' => 'Разрешить удаленные подключения с указанных компьютеров',
    'Databases.Add.remoteAccessExample' => "10.1.0.0/16\n192.168.1.110\n\nУказанным здесь IP-адресам разрешено подключаться к базе данных через правила брандмауэра. Изменения, которые вы внесете в этот список, будут предварительно проверены вашим хостинг-провайдером.",
    'Databases.Add.remoteAccessHint' => 'Пожалуйста, уточните у своего хостинг-провайдера, не противоречит ли указанный вами адрес текущим правилам брандмауэра относительно входящих подключений к MariaDB/MySQL.',
    'Databases.Add.example' => "Пример:\n%%example%%",
    'Databases.Add.denied' => 'Использовать правила системного брандмауэра',
    'Databases.Add.allowed' => 'Разрешить удаленные подключения с указанных компьютеров',
    'Databases.Add.databaseCreated' => 'База данных %%name%% создана.',
    'Databases.Add.create' => 'Создать базу данных',

    'Databases.Clone.title' => 'Копировать базу данных',
    'Databases.Clone.clone' => 'OK',
    'Databases.Clone.warning' => 'Предупреждение: если имена таблиц совпадают, таблица исходной базы данных заменит таблицу конечной.',
    'Databases.Clone.formDescription' => 'Копировать содержимое базы данных в новую или существующую базу данных. При копировании в существующую базу данных таблицы исходной базы данных добавляются к списку таблиц конечной базы данных.',
    'Databases.Clone.copyData' => 'Создать полную копию',
    'Databases.Clone.copyDataHint' => 'Если отмечено, будет копироваться вся база данных (включая структуру и данные). Если не отмечено, будет копироваться только структура таблиц.',
    'Databases.Clone.copyHint' => 'Вы собираетесь скопировать базу данных %%databaseName%%',
    'Databases.Clone.server' => 'Целевой сервер баз данных',
    'Databases.Clone.versionCut' => 'версия %%version%%',
    'Databases.Clone.externalServer' => 'Другое...',
    'Databases.Clone.database' => 'Конечная база данных',
    'Databases.Clone.newDatabase' => 'Создать базу данных с именем',
    'Databases.Clone.newDatabaseName' => 'Имя новой базы данных',
    'Databases.Clone.existingDatabaseName' => 'Имя существующей базы данных',
    'Databases.Clone.existingDatabase' => 'Копировать в существующую базу данных',
    'Databases.Clone.externalDbHost' => 'Имя хоста или IP-адрес',
    'Databases.Clone.externalDbLogin' => 'Имя пользователя',
    'Databases.Clone.externalDbPassword' => 'Пароль',
    'Databases.Clone.subscription' => 'Конечная подписка',
    'Databases.Clone.subscription_powerUser' => 'Конечное веб-пространство',
    'Databases.Clone.cloneInProgress' => 'Выполняется клонирование базы данных %%source%% в базу данных %%destination%%. Вы будете получать уведомления о ходе этой операции на адрес %%email%%.',
    'Databases.Clone.unableToClone' => 'Не удалось скопировать базу данных: "%%source%%".',
    'Databases.Clone.unableToCreateExternalDatabase' => 'Невозможно создать базу данных "%%destination%%" на указанном сервере.',
    'Databases.Clone.databaseCloned' => 'База данных "%%source%%" скопирована.',
    'Databases.Clone.emailSubjSuccess' => 'База данных "%%sourceDatabase%%" скопирована.',
    'Databases.Clone.emailSubjFailure' => 'Не удалось скопировать базу данных "%%sourceDatabase%%".',
    'Databases.Clone.emailBodySuccess' => 'База данных "%%sourceDatabase%%" (%%sourceHost%%) скопирована в базу данных "%%destDatabase%%" (%%destHost%%).',
    'Databases.Clone.emailBodyFailure' => 'Невозможно скопировать базу данных "%%sourceDatabase%%" (%%sourceHost%%) в базу данных "%%destDatabase%%" (%%destHost%%). Копирование не удалось.',
    'Databases.Clone.localServer' => 'локальный сервер',

    "Databases.Import.confirm" => 'Импортировать дамп',
    'Databases.Import.recreateDatabase' => 'Заново создать базу данных',
    'Databases.Import.rootDirectory' => 'Корневая папка',
    'Databases.Import.uploadFromFile' => 'Загрузить дамп с локального компьютера',
    'Databases.Import.uploadFromWebspace' => 'Импортировать дамп, хранящийся на хостинговом сервере',
    'Databases.Import.uploadHint' => 'Вы собираетесь импортировать дамп в %%databaseName%%',
    'Databases.Import.uploadPopupTitle' => 'Импортировать дамп базы данных',
    'Databases.Import.uploading' => 'Импортируется...',
    'Databases.Import.waitMessage' => 'Пожалуйста, подождите...',

    "Databases.Export.confirm" => 'Экспортировать дамп',
    'Databases.Export.downloadDumpAutomatically' => 'Автоматически скачать дамп после его создания',
    'Databases.Export.downloadDumpName' => 'Имя файла дампа',
    'Databases.Export.downloadHint' => 'Вы собираетесь создать дамп базы данных %%database%% и скачать его',
    'Databases.Export.downloadPopupTitle' => 'Экспортировать дамп',
    'Databases.Export.downloadRelativePath' => 'Сохранить дамп в следующей папке',
    'Databases.Export.rootDirectory' => 'Корневая папка',
    'Databases.Export.waitMessage' => 'Пожалуйста, подождите...',

    'MoveDatabasePage.title' => 'Перенести базы данных в другую подписку',
    'MoveDatabasePage.title_powerUser' => 'Перенести базы данных в другое веб-пространство',
    'MoveDatabasePage.description' => 'Вы собираетесь перенести базу данных %%name%%',
    'MoveDatabasePage.hint' => 'Выбранные базы данных будут перенесены в выбранную подписку. Пользователи баз данных также будут перенесены, за исключением имеющих доступ к другим базам данных. Обратите внимание: после переноса пользователи, имевшие доступ к базе данных до переноса, не смогут использовать ссылку в Plesk для получения доступа к базе данных.',
    'MoveDatabasePage.subscriptionName' => 'Перенести в подписку',
    'MoveDatabasePage.subscriptionName_powerUser' => 'Перенести в веб-пространство',
    'MoveDatabasePage.save' => 'Переместить',

    'WebProsAccountPage.descriptionHead' => 'Доступ ко всем службам WebPros и серверу Plesk через единый безопасный вход.',
    'WebProsAccountPage.descriptionBody' => 'WebPros Account обеспечивает доступ к информационной панели, порталу поддержки и сервисам Monitoring, Plesk University и KA Partner Central, упрощая управление всеми службами экосистемы WebPros.',
    'WebProsAccountPage.buttonLogin' => 'Аутентификация с помощью WebPros Account',
    'WebProsAccountPage.buttonSkip' => 'Пропустить до следующего входа',
];