<?php
// Copyright 1999-2025. WebPros International GmbH. All rights reserved.
$messages = [
    'problem-detail.nginx-upstream-sent-too-big-header.name' => 'Nginx "Erreur 502 Passerelle incorrecte : envoi d\'un en-tête trop volumineux par upstream lors de la lecture de l\'en-tête de la réponse"',
    'problem-detail.nginx-upstream-sent-too-big-header.description' => 'Disponible bientôt.',
    'problem-detail.nginx-upstream-sent-too-big-header.cause' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.solution1.title' => '',
    'problem-detail.nginx-upstream-sent-too-big-header.solution1.text' => '',
    'problem-detail.apache-followsymlinks-not-allowed.name' => 'Apache "500 Erreur interne du serveur : Option FollowSymLinks non autorisée ici"',
    'problem-detail.apache-followsymlinks-not-allowed.description' => 'Disponible bientôt.',
    'problem-detail.apache-followsymlinks-not-allowed.cause' => '',
    'problem-detail.phpfpm-server-reached-max-children.name' => 'PHP-FPM "paramètre max_children atteint par le serveur"',
    'problem-detail.phpfpm-server-reached-max-children.description' => '<h4>Symptômes</h4><ul><li><p>Les sites Web avec le gestionnaire PHP défini comme <strong>application FPM servie par Apache</strong> ou <strong>application FPM application servie par nginx</strong> sous <strong>Domaines</strong> &gt; <strong>example.com</strong> &gt; <strong>Les paramètres PHP</strong> ont l\'un des problèmes suivants :</p><ul><li><p>charge lentement</p></li><li><p>non accessible (en permanence ou temporairement) avec une erreur 50x dans un navigateur Web :</p><pre>502 Passerelle incorrecte</pre><hr><pre>503 Service temporairement indisponible</pre><hr><pre>504 Expiration de la passerelle</pre></li></ul></li><li><p>Le message d\'erreur suivant s\'affiche dans le fichier journal PHP-FPM <code>/var/log/plesk-php<strong>XX</strong>-fpm/error.log</code> (<em>XX</em> correspond à la version PHP utilisée par les sites Web):</p><pre>WARNING: [pool example.com] server reached max_children setting (*), consider raising it</pre><ul><li><p>Le message ci-dessus est accompagné de l\'erreur :</p><pre>unable to read what child say: Bad file descriptor (9)</pre></li></ul></li><li><p>If nginx is enabled on the server, one of the following error messages may appear in domain\'s error logfile <code>/var/www/vhosts/system/example.com/logs/proxy_error_log</code>:</p><pre style="white-space: pre-wrap;">[error] 11456#0: *118348 connect() to unix:///var/www/vhosts/system/example.com/php-fpm.sock failed (11: Resource temporarily unavailable) while connecting to upstream, client: 203.0.113.2, server: example.com, request: "GET / HTTP/1.1", upstream: "fastcgi://unix:///var/www/vhosts/system/example.com/php-fpm.sock:", host: "example.com"</pre><hr><pre style="white-space: pre-wrap;">[error] 20058#0: *4725139 upstream prematurely closed connection while reading response header from upstream, client: 203.0.113.2, server: example.com, request: "POST /path/to/some/file HTTP/2.0", upstream:</pre></li></ul>',
    'problem-detail.phpfpm-server-reached-max-children.cause' => ' <p>PHP-FPM <code>pm.max_children</code> a été atteint par le ou les sites Web.</p>',
    'problem-detail.phpfpm-server-reached-max-children.solution1.title' => 'Augmenter la limite pm.max_children',
    'problem-detail.phpfpm-server-reached-max-children.solution1.text' => '<p>Augmentez la limite <code>pm.max_children</code> pour les domaines concernés :</p><ol><li><p>Connectez-vous au serveur Plesk via <a href="https://support.plesk.com/hc/en-us/articles/12377512781975" target="_blank" rel="noopener">SSH</a>.</p></li><li><p>Trouvez les domaines concernés à l\'aide de la commande suivante :</p><div class="pul-alert pul-alert--info pul-status-message pul-status-message--info"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>Remarque :</strong> le nombre à gauche indique le nombre de fois que la limite <code>pm.max_children</code> a été atteinte par le site Web.</div><pre style="white-space: pre-wrap;"># grep -r "server reached max_children setting" /var/log/*php*-fpm/error.log | cut -d\' \' -f5 | tr -d \']\' | sort | uniq -c | sort -nr<br><br>100 example.com<br>50 example.net<br>25 example.org<br>&lt;...&gt;</pre></li><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377667582743" target="_blank" rel="noopener">Connectez-vous à Plesk</a>.</p></li><li><p>Allez sous <strong>Domaines</strong> &gt; <strong>example.com</strong> &gt; <strong>Paramètres PHP</strong> &gt; <strong>Paramètres PHP-FPM</strong>.</p></li><li><p>Augmentez la valeur <code>pm.max_children</code> pour le domaine et appliquez les modifications. Augmentez cette valeur pour tous les domaines répertoriés à l\'étape 2.</p></li></ol>',
    'problem-detail.nginx-too-many-open-files.name' => 'Nginx "Trop de fichiers ouverts"',
    'problem-detail.nginx-too-many-open-files.description' => '<p>nginx ne parvient pas à démarrer/se recharger sur un serveur Plesk : trop de fichiers ouverts</p><h4>Symptômes</h4><ul><li><p>Le service nginx ne parvient pas à démarrer/se recharger et le fichier <code>/var/log/nginx/error.log</code> contient l\'erreur suivante :</p><pre style="white-space: pre-wrap;">nginx: [emerg] open() "/var/www/vhosts/system/example.com/logs/proxy_access_ssl_log" failed (24 : trop de fichiers ouverts)</pre></li><li><p>Certains ou tous les sites Web sont inaccessibles</p></li><li><p>L\'avertissement est affiché dans <strong>Outils &amp; Paramètres &gt; Diagnostiquer &amp; réparer</strong>:</p><pre style="white-space: pre-wrap;">Lors de la vérification de la valeur de nginx ULIMIT, N domaines ont été trouvés sur le serveur. Il y a peut-être un problème avec la limite par défaut nginx concernant le nombre de fichiers ouverts</pre></li><li><p>Les applications Web NodeJS et Ruby affichent une erreur 502 Passerelle incorrecte lors de l\'exécution de certaines tâches de Plesk comme la création de domaines, d\'abonnements, lors de modifications sur Apache ou Nginx :</p><pre style="white-space: pre-wrap;">Erreur serveur<br>502 Passerelle incorrecte <br>Le serveur Web a reçu une réponse non valide en agissant comme passerelle ou serveur proxy.</pre></li><li><p>Après <a href="https://support.plesk.com/hc/en-us/articles/12377676289815-How-to-install-SSL-certificate-for-a-domain-in-Plesk" target="_blank" rel="noopener noreferrer">l\'installation d\'un nouveau certificat pour le domaine</a>, l\'ancien s\'affiche toujours dans un navigateur Web. Toutefois, le certificat correct est sélectionné sur la page <strong>Domaines &gt; example.com &gt; Paramètres d\'hébergement</strong> .</p></li></ul>',
    'problem-detail.nginx-too-many-open-files.cause' => '<p>L\'hôte virtuel Nginx ouvre 4 fichiers journaux pour chaque hôte virtuel avec un hébergement physique :</p><ul><li>proxy_access_log</li><li>proxy_access_ssl_log</li><li>webmail_access_log</li><li>webmail_access_ssl_log</li></ul><p>Par conséquent, le nombre maximum de fichiers ouverts est dépassé par serveur lenginx, car il y a un nombre élevé de domaines (en général, plus de 100).</p>',
    'problem-detail.nginx-too-many-open-files.solution1.title' => 'Augmenter la limite des fichiers ouverts',
    'problem-detail.nginx-too-many-open-files.solution1.text' => '<div class="pul-alert pul-alert--warning pul-status-message pul-status-message--warning"><span class="pul-icon pul-status-message__icon"><svg focusable="false"><use href="/ui-library/images/symbols.svg?6bd5879cb9a032639fb375ff6f1dcd26#info-circle-filled:16"></use></svg></span><strong>Avertissement :</strong> l\'exécution de l\'utilitaire <code>websrv_ulimits</code> sans l\'option <strong>--no-restart</strong> initie la reconstruction des fichiers de configuration Web pour tous les domaines et peut entraîner des périodes d\'interruption significatives pour tous les domaines lorsque de nombreux sites Web sont hébergés.<br><br>Exécutez la commande pendant les périodes de maintenance.</div><p>Nous vous recommandons de définir la valeur limite des fichiers ouverts sur une valeur supérieure au <strong>nombre de domaines sur Plesk * 16</strong> au moins. Dans l\'exemple suivant, découvrez comment définir la limite sur 4096 :</p><ol><li><p>connectez-vous au serveur via <a href="https://support.plesk.com/hc/en-us/articles/12377512781975" target="_blank" rel="noopener noreferrer">SSH</a></p></li><li><p>Définissez la limite sur 4096 pour Apache et Nginx :</p><pre># /usr/local/psa/admin/sbin/websrv_ulimits --set 4096 --no-restart</pre></li><li><p>Redémarrez les services Apache et nginx sous <strong><a href="https://support.plesk.com/hc/en-us/articles/12377667582743" target="_blank" rel="noopener noreferrer">Plesk</a> &gt;</strong> <strong>Outils &amp; Paramètres &gt; Gestion de services</strong> pour appliquer les modifications.</p></li><li><p>Vérifiez si \'la limite max de fichiers ouverts\' a été appliquée correctement après le redémarrage des services Web :</p><pre># grep \'Max open files\' /proc/$(cat /var/run/nginx.pid)/limits<br>Max open files 4096 4096 file</pre></li><li><p>Si la solution ci-dessus ne résout pas le problème, définissez la limite à l\'aide de l\'utilitaire <code>ulimit</code> :</p><pre># ulimit -n 4096</pre></li></ol>',
    'problem-detail.apache-modsec-response-body-too-large.name' => 'ModSecurity "Corps de la réponse trop volumineux"',
    'problem-detail.apache-modsec-response-body-too-large.description' => 'Disponible bientôt.',
    'problem-detail.apache-modsec-response-body-too-large.cause' => '',
    'problem-detail.modsec-access-denied.name' => 'ModSecurity "Accès refusé avec le code 403"',
    'problem-detail.modsec-access-denied.description' => '<h4>Symptômes</h4><ul><li><p>ModSecurity est installé et activé dans <strong>Outils & Paramètres > Pare-feu applicatif (ModSecurity) > Mode du pare-feu applicatif > On</strong>.</p></li><li>Un site Web hébergé sur Plesk ne charge pas. Aucune opération ne peut être exécutée sur le site, comme gérer WordPress, accéder à la messagerie Web ou accéder au fichier <code>robots.txt</code>. Le navigateur peut afficher l\'une des erreurs suivantes : <pre>ERR_CONNECTION_REFUSED</pre><hr><pre>403 Forbidden</pre><hr><pre>500 Internal Server Error</pre><hr><pre>ERR_CONNECTION_TIMED_OUT</pre></li><li>Un message d\'erreur de ModSecurity similaire à l\'un des messages suivants est visible dans le fichier journal <code>/var/log/modsec_audit.log</code>ou sur la page Journaux dans Plesk (<strong>Domaines</strong> &gt; <strong>exemple.com</strong> &gt; <strong>Journaux</strong>) : <pre>ModSecurity: Access denied with code 403 (phase 2). Operator GE matched 5 at TX:anomaly_score. [file "/etc/apache2/modsecurity.d/rules/owasp_modsecurity_crs_4-plesk/REQUEST-949-BLOCKING-EVALUATION.conf"] [line "57"] [id "949110"] [msg "Inbound Anomaly Score Exceeded (Total Score: 5)"] [severity "CRITICAL"] [tag "application-multi"] [tag "language-multi"] [tag "platform-multi"] [tag "attack-generic"] [hostname "example.com"] [uri "/robots.txt"] [unique_id "XPsROH8AAQEAABEiZFcAAABC"]</pre></li>',
    'problem-detail.modsec-access-denied.cause' => '<p>Le Pare-feu applicatif ModSecurity est activé avec une règle très restrictive comme OWASP, Comodo ou un autre jeu de règles comme Imunify360. Les jeux de règles restrictifs peuvent bloquer certaines opérations sur le site Web.</p><p><Strong>Remarque :</strong> l\'erreur ModSecurity peut aussi indiquer une attaque de votre serveur. Utilisez les solutions ci-dessous seulement si vous avez la certitude que ModSecurity bloque l\'utilisation valide de votre site Web.</p>',
    'problem-detail.modsec-access-denied.solution1.title' => 'Désactiver le jeu de règles ModSecurity par ID ou Étiquette',
    'problem-detail.modsec-access-denied.solution1.text' => '<ol><li><p>Trouvez l\'ID de la règle qui bloque l\'utilisation légitime de votre site Web. Vous trouverez l\'ID dans les messages d\'erreur ou dans le fichier journal <code>/var/log/modsec_audit.log</code>. L\'ID est un nombre entier entre guillemets avec le préfixe <code>id</code> entre crochets, par exemple, <strong>[id "210831"]</strong>.</p></li><li><a href="https://support.plesk.com/hc/en-us/articles/12377453278871" target="_blank" rel="noopener">Désactivez des jeux de règles spécifiques dans Plesk</a>.</li></ol>',
    'problem-detail.modsec-access-denied.solution2.title' => 'Passer à un autre jeu de règles ModSecurity',
    'problem-detail.modsec-access-denied.solution2.text' => '<ol><li><p>Passez à un jeu de règles ModSecurity moins restrictif comme le "Jeu de règles Atomic ModSecurity". Pour cela, allez sous <strong>Outils & Paramètres</strong> > <strong>Pare-feu applicatif (ModSecurity)</strong> > <strong>Paramètres</strong> et sélectionnez <strong>Atomic Standard</strong>. Ensuite, cliquez sur <strong>OK</strong> pour appliquer les modifications.</p></li></ol>',
    'problem-detail.php-allowed-memory-size-exhausted.name' => 'PHP "Erreur 500 - Erreur interne du serveur : taille de mémoire de XXX autorisée dépassée"',
    'problem-detail.php-allowed-memory-size-exhausted.description' => '<h4>Symptômes</h4><ul><li><p>Un site Web hébergé sur Plesk n\'est pas accessible :</p><pre>500 Erreur serveur interne</pre></li><li><p>L\'erreur suivante est visible dans le journal du site Web :</p><pre>Got error "PHP message: PHP Fatal error: Allowed memory size of 4194304 bytes exhausted (tried to allocate 4000032 bytes) in /var/www/vhosts/example.com/httpdocs/somethingBig.php on line 3"</pre></li> </ul>',
    'problem-detail.php-allowed-memory-size-exhausted.cause' => '<p>La mémoire allouée au site Web pour fonctionner est insuffisante.</p>',
    'problem-detail.php-allowed-memory-size-exhausted.solution1.title' => 'Augmenter la valeur memory_limit du site Web',
    'problem-detail.php-allowed-memory-size-exhausted.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377510316183" target="_blank" rel="noopener">Consultez l\'article de la base de connaissances et suivez les instructions</a>.</p></li></ol>',
    'problem-detail.php-open-basedir-restriction-in-effect.name' => 'PHP "restriction open_basedir en vigueur"',
    'problem-detail.php-open-basedir-restriction-in-effect.description' => '<h4>Symptômes</h4><ul><li><p>Un site Web n\'est pas accessible et l\'une des erreurs suivantes s\'affiche dans le navigateur :</p><pre>404 file not found</pre><hr><pre>500 Internal Server Error</pre><hr><pre>Error 500 move_uploaded_file(): open_basedir restriction in effect. File(/path/to/the/directory) is not within the allowed path(s): (/var/www/vhosts/example.com/:/tmp/)</pre></li><li><p>Le message d\'erreur suivant est affiché sur la page des Journaux du domaine (<strong>Domaines</strong> > <strong>exemple.com</strong> > <strong>Journaux</strong>):</p><pre><...> open_basedir restriction in effect. File(/path/to/the/directory) is not within the allowed path(s) <...></pre><hr><pre>Uncaught Exception: Session: Configured save path "/path/to/the/directory" is not a directory, doesn\'t exist or cannot be created.</pre></li></ul>',
    'problem-detail.php-open-basedir-restriction-in-effect.cause' => 'Le script PHP tente d\'accéder à un répertoire pour lequel l\'accès n\'est pas autorisé. Cette restriction est définie par la directive PHP <code>open_basedir</code> individuellement pour chaque domaine. Par défaut, <code>open_basedir</code> autorise l\'accès aux répertoires <code>tmp</code> et racine du document du domaine, ainsi qu\'au chemin d\'accès des sessions par défaut du système.',
    'problem-detail.php-open-basedir-restriction-in-effect.solution1.title' => 'Ajouter le chemin supplémentaire à la directive open_basedir',
    'problem-detail.php-open-basedir-restriction-in-effect.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377510714135" target="_blank" rel="noopener">Consultez l\'article de la base de connaissances et suivez les instructions</a>.</p></li></ol>',
    'problem-detail.php-open-basedir-restriction-in-effect.solution2.title' => 'Désactiver la directive open_basedir',
    'problem-detail.php-open-basedir-restriction-in-effect.solution2.text' => '<ol><li><p>Allez sur la page <strong>Domaines &gt exemple.com &gt Paramètres PHP</strong> et définissez la valeur de la directive <code>open_basedir</code> sur "none".</p></li></ol>',
    'problem-detail.apache-client-denied-by-server.name' => 'Apache .htaccess "403 Interdit AH01797: client refusé par la configuration serveur"',
    'problem-detail.apache-client-denied-by-server.description' => '<h4>Symptômes</h4><ul><li><p>Le site Web affiche une erreur similaire à celle-ci :</p><pre>Server Error 403<br>Forbidden</pre></li><li><p>Le fichier journal <code>/var/www/vhosts/system/example.com/logs/error_log</code> contient des erreurs comme celle-ci :</p><pre>AH01797: client denied by server configuration: /var/www/vhosts/example.com/index.php</pre></li></ul>',
    'problem-detail.apache-client-denied-by-server.cause' => '<p>La configuration Apache actuelle ne permet pas l\'accès au site.</p><p>Pour les fichiers .htaccess et .htpasswd, ce comportement est attendu, car ces fichiers ne doivent pas être accessibles via le serveur web.</p>',
    'problem-detail.apache-client-denied-by-server.solution1.title' => 'Vérifier les fichiers de configuration du serveur et .htaccess',
    'problem-detail.apache-client-denied-by-server.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377654829463" target="_blank" rel="noopener">Consultez l\'article de la base de connaissances et suivez les instructions</a>.</p></li></ol>',
    'problem-detail.apache-no-directory-index.name' => 'Apache "Impossible d\'accéder à un répertoire d\'un site Web Plesk: 403 Interdit"',
    'problem-detail.apache-no-directory-index.description' => '<h4>Symptômes</h4><ul><li><p>Impossible d\'accéder à l\'emplacement spécifique d\'un site Web, par exemple : <code>http://example.com/some_folder</code>. L\'erreur suivante se produit :</p><pre>Server Error 403<br>Forbidden</pre></li><li><p>L\'erreur suivante est affichée dans le fichier <code>/var/www/vhosts/example.com/logs/error_log<code/> :</p><pre>[autoindex:error] [pid 16314:tid 140300215322368] [client 203.0.113.2:55714] AH01276: Cannot serve directory /var/www/vhosts/example.com/httpdocs/some_folder/: No matching DirectoryIndex (index.html,index.cgi,index.pl,index.php,index.xhtml,index.htm,index.shtml) found, and server-generated directory index forbidden by Options directive</pre></li></ul>',
    'problem-detail.apache-no-directory-index.cause' => '<p>Le répertoire demandé ne contient pas les fichiers index ou la navigation dans le répertoire n\'est pas autorisée.</p>',
    'problem-detail.apache-no-directory-index.solution1.title' => 'Ajouter un fichier index au répertoire',
    'problem-detail.apache-no-directory-index.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377654829463" target="_blank" rel="noopener">Consultez l\'article de la base de connaissances et suivez les instructions</a>.</p></li></ol>',
    'problem-detail.apache-no-directory-index.solution2.title' => 'Autoriser la navigation dans le répertoire',
    'problem-detail.apache-no-directory-index.solution2.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377172809495" target="_blank" rel="noopener">Consultez l\'article de la base de connaissances et suivez les instructions</a>.</p></li></ol>',
    'problem-detail.nginx-no-directory-index.name' => 'Nginx "Impossible d\'accéder à un répertoire d\'un site Web Plesk: 403 Interdit"',
    'problem-detail.nginx-no-directory-index.description' => '<h4>Symptômes</h4><ul><li><p>Impossible d\'accéder à l\'emplacement spécifique d\'un site Web, par exemple : <code>http://example.com/some_folder</code>. L\'erreur suivante se produit :</p><pre>Server Error 403<br>Forbidden</pre></li><li><p>L\'erreur suivante est visible dans le fichier <code>/var/www/vhosts/example.com/logs/error_log </code> :</p><pre>[autoindex:error] [pid 16314:tid 140300215322368] [client 203.0.113.2:55714] AH01276: Cannot serve directory /var/www/vhosts/example.com/httpdocs/some_folder/: No matching DirectoryIndex (index.html,index.cgi,index.pl,index.php,index.xhtml,index.htm,index.shtml) found, and server-generated directory index forbidden by Options directive</pre></li></ul>',
    'problem-detail.nginx-no-directory-index.cause' => '<p>Le répertoire demandé ne contient pas les fichiers index ou la navigation dans le répertoire n\'est pas autorisée.</p>',
    'problem-detail.nginx-no-directory-index.solution1.title' => 'Ajouter un fichier index au répertoire',
    'problem-detail.nginx-no-directory-index.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377654829463" target="_blank" rel="noopener">Consultez l\'article de la base de connaissances et suivez les instructions</a>.</p></li></ol>',
    'problem-detail.nginx-no-directory-index.solution2.title' => 'Autoriser la navigation dans le répertoire',
    'problem-detail.nginx-no-directory-index.solution2.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377172809495" target="_blank" rel="noopener">Consultez l\'article de la base de connaissances et suivez les instructions</a>.</p></li></ol>',
    'problem-detail.apache-reached-max-request-workers.name' => 'Apache "paramètre MaxRequestWorkers atteint par le serveur"',
    'problem-detail.apache-reached-max-request-workers.description' => 'Disponible bientôt.',
    'problem-detail.apache-reached-max-request-workers.cause' => '',
    'problem-detail.php-post-content-length-exceeds-limit.name' => 'Limite du corps pour la requête PHP "le client tente d\'envoyer un corps trop volumineux "',
    'problem-detail.php-post-content-length-exceeds-limit.description' => 'Disponible bientôt.',
    'problem-detail.php-post-content-length-exceeds-limit.cause' => '',
    'problem-detail.nginx-client-sent-too-large-body.name' => 'Limite du corps pour la requête PHP "le client tente d\'envoyer un corps trop volumineux "',
    'problem-detail.nginx-client-sent-too-large-body.description' => 'Disponible bientôt.',
    'problem-detail.nginx-client-sent-too-large-body.cause' => '',
    'problem-detail.php-failed-to-read-session-data.name' => 'Sessions PHP "Erreur interne du serveur 503" ou "Échec de la lecture des données de la session"',
    'problem-detail.php-failed-to-read-session-data.description' => 'Disponible bientôt.',
    'problem-detail.php-failed-to-read-session-data.cause' => '',
    'problem-detail.apache-unable-to-check-htaccess-file.name' => 'Apache .htaccess "403 Interdit : pcfg_openfile: impossible de vérifier le fichier htaccess, vérifiez si la lecture est possible"',
    'problem-detail.apache-unable-to-check-htaccess-file.description' => '<h4>Symptômes</h4><ul><li><p>Un site Web hébergé sur Plesk ne fonctionne pas :</p><pre>Vous n\'avez pas le droit d\'accéder à / sur ce serveur. <br> De plus, une erreur 403 Forbidden se produit lors de la tentative d\'utilisation de ErrorDocument pour traiter la requête.</pre><p>À la place de l\'erreur ci-dessus, vous pouvez aussi voir une page vierge.</p></li><li><p>Le journal d\'erreur du domaine dans <strong>Domaines &gt exemple.com &gt Journaux</strong> contient le message suivant :</p><pre>(13)Permission denied: [client 203.0.113.2:39024] AH00529: /var/www/vhosts/example.com/httpdocs/.htaccess pcfg_openfile: unable to check htaccess file, ensure it is readable and that "/var/www/vhosts/example.com/httpdocs/" is executable</pre></li></ul>',
    'problem-detail.apache-unable-to-check-htaccess-file.cause' => 'Droits incorrects pour les fichiers ou les dossiers du domaine.',
    'problem-detail.apache-unable-to-check-htaccess-file.solution1.title' => 'Réparer les droits pour le contenu du site Web',
    'problem-detail.apache-unable-to-check-htaccess-file.solution1.text' => '<ol><li><p><a href="https://support.plesk.com/hc/en-us/articles/12377773681815" target="_blank" rel="noopener">Consultez l\'article de la base de connaissances et suivez les instructions</a>.</p></li></ol>',
];